# Rename a topic

Zulip makes it possible to rename topics. This is useful for keeping messages
organized, even if some users are still learning how to use topics effectively.
You can also [move content to another
topic](/help/move-content-to-another-topic).

When a topic is renamed, Zulip's [permanent links to messages in
context](/help/link-to-a-message-or-conversation#get-a-link-to-a-specific-message)
will automatically redirect to the new location of the message. [Muted
topics](/help/mute-a-topic) are automatically migrated when a topic is renamed.

Organizations can [configure](/help/restrict-moving-messages) which
[roles](/help/roles-and-permissions) have permission to rename topics.

## Rename a topic

### Via the message recipient bar

{start_tabs}

1. Click the **pencil** (<i class="fa fa-pencil"></i>) icon in the message
   recipient bar. If you do not see the **pencil** (<i class="fa
   fa-pencil"></i>) icon, you do not have permission to rename this topic.

1. Edit the topic name.

1. Click the **checkmark** (<i class="fa fa-check"></i>) icon to save your changes.

{end_tabs}

### Via the left sidebar (alternate method)

{start_tabs}

{!topic-actions.md!}

1. Select **Move topic** or **Rename topic**. If you do not see either option,
   you do not have permission to rename this topic.

1. Edit the topic name.

1. _(optional)_  If using the **Move topic** menu, select the destination channel
   for the topic from the channels dropdown list.

1. Toggle whether automated notices should be sent.

1. Click **Confirm** to rename the topic.

{end_tabs}

## Related articles

* [Move content to another topic](/help/move-content-to-another-topic)
* [Move content to another channel](/help/move-content-to-another-channel)
* [Resolve a topic](/help/resolve-a-topic)
* [Restrict moving messages](/help/restrict-moving-messages)
