# Schedule a message

Zulip lets you schedule a message to be sent at a later time. For example, if
you are working outside of regular business hours for your organization, you
can schedule a message for next morning to avoid disturbing others.

## Schedule a message

{start_tabs}

{tab|desktop-web}

{!start-composing.md!}

1. Write a message.

1. Click on the **ellipsis** (<i class="zulip-icon
   zulip-icon-more-vertical"></i>) next to the **Send**
   (<i class="zulip-icon zulip-icon-send"></i>) button.

1. Click **Schedule message**.

1. Select one of the suggested scheduling options, or pick a custom time.

!!! keyboard_tip ""

    From the compose box, you can use <kbd>Tab</kbd>, <kbd>Tab</kbd>,
    <kbd>Enter</kbd> to open the compose menu and start scheduling a message.

{end_tabs}

## Edit or reschedule a message

{start_tabs}

{tab|desktop-web}

{!go-to-scheduled-messages.md!}

1. Click the **pencil** (<i class="fa fa-pencil"></i>) icon on the message you
   want to edit or reschedule.

1. *(optional)* Edit the message.

1. Click the **ellipsis** (<i class="zulip-icon
   zulip-icon-more-vertical"></i>) next to the **Send**
   (<i class="zulip-icon zulip-icon-send"></i>) button.

1. Select the previously scheduled time, or click **Schedule message** to pick a
   new time.

!!! tip ""

    You can also click **Undo** in the confirmation banner shown immediately
    after a message is scheduled.

{end_tabs}

## Send a scheduled message now

{start_tabs}

{tab|desktop-web}

{!go-to-scheduled-messages.md!}

1. Click the **pencil** (<i class="fa fa-pencil"></i>) icon on the message you
   want to send now.

1. *(optional)* Edit the message.

1. Click the **Send** (<i class="zulip-icon zulip-icon-send"></i>) button.

!!! keyboard_tip ""

    You can also use <kbd>Enter</kbd> within the scheduled messages view to
    edit or reschedule the selected message.

{end_tabs}

## Delete a scheduled message

{start_tabs}

{tab|desktop-web}

{!go-to-scheduled-messages.md!}

1. Click the **trash** (<i class="fa fa-trash-o"></i>) icon on the message you
   want to delete.

!!! keyboard_tip ""

    You can also use <kbd>Backspace</kbd> within the scheduled messages view to
    delete the selected message.

{end_tabs}

## View scheduled messages

{start_tabs}

{tab|desktop-web}

{!go-to-scheduled-messages.md!}

!!! tip ""

    You can also view scheduled messages by clicking on the **ellipsis**
    (<i class="zulip-icon zulip-icon-more-vertical"></i>) next to the **Send**
    (<i class="zulip-icon zulip-icon-send"></i>) button in the compose
    box, and selecting **View scheduled messages**.

{end_tabs}

## Related articles

* [Message drafts](/help/view-and-edit-your-message-drafts)
* [Preview messages before sending](/help/preview-your-message-before-sending)
* [Verify a message was sent](/help/verify-your-message-was-successfully-sent)
* [Edit a message](/help/edit-a-message)
* [Delete a message](/help/delete-a-message)
