# Status and availability

Status and availability let everyone know roughly how quickly you'll be
responding to messages.

A **status** is a customizable emoji, along with a short message. A typical
status might be "📅 In a meeting" or "🏠 Working remotely". To make it easy to
notice, the status emoji is shown next to your name in the sidebars, message
feed, and compose box.

Your **availability** is a colored dot (like <span class="indicator green
solid"></span>) that indicates if you're currently active on Zulip, idle,
or offline. You can also [go invisible](#invisible-mode) to appear offline
to other users.

## Statuses

### Set a status

You can set a status emoji, status message, or both.

{start_tabs}

{tab|via-user-card}

{!self-user-card.md!}

{!set-status.md!}

{tab|via-personal-settings}

{!personal-menu.md!}

{!set-status.md!}

{tab|mobile}

{!mobile-profile-menu.md!}

1. Tap **Set your status**.

1. Tap to select one of the common statuses, *or* choose any emoji and/or
   write a short message.

1. Tap **Save**.

{end_tabs}

### Clear a status

{start_tabs}

{tab|via-user-card}

{!self-user-card.md!}

{!clear-status.md!}

{tab|via-personal-settings}

{!personal-menu.md!}

{!clear-status.md!}

{tab|mobile}

{!mobile-profile-menu.md!}

1. Tap **Set your status**.

1. Tap the **x**
   (<img src="/static/images/help/mobile-x-icon.svg" alt="x" class="help-center-icon"/>)
   to the right of your current status.

1. Tap **Save**.

{end_tabs}

### View a status

Status emoji are shown next to a user's name in the sidebars, message feed,
and compose box. Status emoji and status messages are also shown on
[user cards](/help/user-cards).

{start_tabs}

{tab|desktop-web}

1. Hover over a user's name in the right sidebar, or in the **Direct messages**
   section in the left sidebar, to view their status message if they have one
   set.

!!! tip ""

    You can also click on a user's profile picture or name on a message they
    sent to view their status in their **user card**, or configure status text
    to always be shown in the right sidebar.

{tab|mobile}

1. Tap on a user's profile picture or name to open their profile.

1. Look for their status below the user's role (e.g., Member) if they have one
   set.

{!mobile-view-user-profile-tip.md!}

{end_tabs}

### Configure how statuses are displayed

You can choose whether or not status text is displayed in the right sidebar.
With the compact option, only status emoji are shown.

{start_tabs}

{tab|desktop-web}

{settings_tab|preferences}

1. Under **Information**, select **Compact** or **Show status and text** for the
   user list style.

!!! tip ""

    You can always hover over a user's name in the right sidebar to view their
    status message if they have one set.

{end_tabs}

## Availability

There are three availability states:

* **Active** (<span class="indicator green solid"></span>): Zulip is
  open and in focus on web, desktop or mobile, or was in the last 140
  seconds.

* **Idle** (<span class="indicator orange"></span>): Zulip is open on
  your computer (either desktop or web), but you are not active.

* **Offline** (<span class="indicator grey"></span>): Zulip is not open
  on your computer, or you have turned on invisible mode.

You can see when someone offline was last active by hovering over their
name in the left or right sidebar.

### Invisible mode

Zulip supports the privacy option of never updating the availability
information for your account. The result is that you will always
appear to other users as **Offline**, regardless of your activity in
Zulip.

With this setting, your "Last active" time displayed to other users in
the UI will be frozen as the approximate time you enabled this setting.

### Toggle invisible mode

{start_tabs}

{tab|desktop-web}

{!self-user-card.md!}

1. To enable, you'll select **Go invisible**.

1. To disable, you'll select **Turn off invisible mode**.

!!! tip ""

    You can also toggle this setting in the **Account & privacy**
    tab of your **Personal settings** menu.

{tab|mobile}

{!mobile-profile-menu.md!}

1. Toggle **Invisible mode**.

{end_tabs}

## Related articles

* [Typing notifications](/help/typing-notifications)
* [Read receipts](/help/read-receipts)
