# Support the Zulip project

{!supporting-zulip-motivation.md!}

The Zulip community (which includes you!) is a huge part of what makes Zulip
successful. If you appreciate Zulip, there are many different ways you can
support the project. Some of these will only take a few minutes of your
time, but still make a big difference.

* [Support Zulip financially](#support-zulip-financially): Sponsoring Zulip
  helps fund free [Zulip Cloud Standard](https://zulip.com/plans/) hosting for
  hundreds of open source projects, research communities, and other worthy
  organizations.

* [Help others find Zulip](#help-others-find-zulip): As a business that's
  [growing sustainably](https://zulip.com/values/) without venture capital
  funding, Zulip cannot afford splashy ad campaigns to compete with giant
  corporations like Salesforce (Slack) and Microsoft (Teams). Zulip depends
  on users and other members of the community to spread the word about the
  difference that using Zulip's organized team chat has made for you or your
  organization.

* [Help improve Zulip](#help-improve-zulip): Zulip is developed by a [vibrant
  open-source community](https://zulip.com/team/), and there are many ways to
  contribute even without writing a single line of code.

## Support Zulip financially

You can sponsor Zulip through the [GitHub sponsors
program](https://github.com/sponsors/zulip) (preferred), on
[Patreon](https://patreon.com/zulip), or on [Open
Collective](https://opencollective.com/zulip).

## Help others find Zulip

* [**Link to Zulip**](/help/linking-to-zulip-website) from your organization's
  website. In addition to providing information for anyone browsing your
  website, this helps people find Zulip in Google and other search engines.

* [**List your organization**](/help/communities-directory) in the [Zulip
  communities directory](https://zulip.com/communities/). Browsing open
  communities helps folks see how others are using Zulip, and learn best
  practices.

* **Star** Zulip on GitHub. There are four main repositories:
  [server/web](https://github.com/zulip/zulip),
  [mobile](https://github.com/zulip/zulip-mobile),
  [desktop](https://github.com/zulip/zulip-desktop), and
  [Python API](https://github.com/zulip/python-zulip-api).

* **Review** Zulip on product comparison websites, such as
  [G2](https://www.g2.com/products/zulip/reviews/start) and [Software
  Advice](https://reviews.softwareadvice.com/new/316022). Organizations rely on
  review sites more and more when choosing software for their team, and sharing
  your experience with Zulip (good or bad) helps them evaluate whether Zulip
  might work for their needs.

* **Mention** Zulip on social media, or like and retweet [Zulip's
  tweets](https://twitter.com/zulip).

* **Share** your Zulip story on your blog, or get it posted [on the Zulip
  website](https://zulip.com/use-cases/#customer-stories) (contact
  [support@zulip.com](mailto:support@zulip.com) to learn more).

* **Tell** your friends and colleagues about your Zulip experience.

## Help improve Zulip

* **Report issues**, including both [feature
  requests](https://zulip.readthedocs.io/en/latest/contributing/suggesting-features.html)
  and [bug
  reports](https://zulip.readthedocs.io/en/latest/contributing/reporting-bugs.html).
  Many improvements to the Zulip app start with a user's suggestion.

* [**Give
  feedback**](https://zulip.readthedocs.io/en/stable/contributing/contributing.html#user-feedback)
  if you are evaluating or using Zulip.

* [**Translate**](https://zulip.readthedocs.io/en/stable/translating/translating.html)
  Zulip into your language. Zulip has been translated into over 25 languages by
  an amazing group of volunteers, and you can help expand, improve, and
  maintain the translation for your language, or start working on a language
  that hasn't been covered yet.

* [**Contribute
  code**](https://zulip.readthedocs.io/en/stable/contributing/contributing.html)
  to the Zulip open-source project. To make it easy for contributors from a
  variety of backgrounds to get started, we have invested into making Zulip’s
  code uniquely readable, well tested, and easy to modify.

## Related articles

* [Zulip project values](https://zulip.com/values/)
* [Linking to Zulip](/help/linking-to-zulip-website)
* [Zulip communities directory](/help/communities-directory)
* [Contact Zulip](/help/contact-support)
