# Using Zulip for a class

Welcome to Zulip! This pages offers some tips for [using Zulip for a
class](https://zulip.com/for/education/).  If this is your first time using Zulip, we
recommend checking out [Getting started with
Zulip](/help/getting-started-with-zulip) to get oriented.

Zulip works great as the communication hub for your class, providing a
single place for:

* [Posting lecture notes and announcements](#posting-lecture-notes-and-announcements)
* [Answering students’ questions](#answering-students-questions)
* Collecting feedback from students
* [Coordination among teaching staff](#coordination-among-teaching-staff)
* [Virtual office hours](#virtual-office-hours)

## Posting lecture notes and announcements

!!! tip ""
    [Subscribe to email notifications](/help/channel-notifications) for
    channels such as **#announcements** to make sure you never miss an important message.

Many classes use a dedicated channel to post general announcements, for example:

* **\#announcements** > **office hours**: My office hours this week
will be rescheduled from `Mon, Oct 11 2021, 1:00 PM` to `Thu, Oct 14 2021, 3:30 PM`.


Share lecture notes and reading materials with [drag-and-drop file
uploads](/help/share-and-upload-files), for example:

* **\#Unit 3: Sorting algorithms** > **lecture notes**: Here are the notes
from today’s lecture. [lecture notes 10/2.pdf]() You can view a recording of the lecture [here]().

### Formatting tips

* You can [post a time](/help/format-your-message-using-markdown#global-times)
  that everyone will see in their own time zone.
* Share URLs as [named links](/help/format-your-message-using-markdown#links).

## Answering students’ questions

In Zulip, channels determine who receives a message. Topics are
light-weight subjects for individual conversations. You can more about
[channels](introduction-to-channels) and [topics](/help/introduction-to-topics).

Zulip works best when each conversation has its own topic. When you
have a question to ask, simply start a new topic! For example, one
might see the following topics in a channel where a lecture and the
corresponding assignment are being discussed:

* problem 2a clarification
* question about slide 7
* code not compiling
* LaTeX diagram help

Zulip will show auto-complete suggestions for existing topics as you
type, which helps surface relevant previous conversations. You can
also use the search bar to check whether a question has already
been addressed.

You can [mention](/help/mention-a-user-or-group) the person who asked
a question to make sure they see timely answers.

### Resolving topics

When a question has been answered, you can [mark a topic as
resolved](/help/resolve-a-topic). This makes it easy for course
staff to see which conversations still require their attention.

## Coordination among teaching staff

Use private channels to coordinate among course staff, for example:

* **\#staff** > **homework 2 exercise 3b**: How many points should I
  take off for this? The assignment says clearly to use Python 3 syntax.

    ```
    print result
    ```

## Virtual office hours

Zulip works great for virtual office hours! With a dedicated thread
for each question, it's easy to have several discussions at once.

* Course staff can respond to multiple questions in parallel, making
  efficient use of their time.
* Students can participate in real time, or learn by reading the
  conversations afterwards.

## Related articles

* [Getting started with Zulip](/help/getting-started-with-zulip)
* [Setting up your organization](/help/getting-your-organization-started-with-zulip)
* [Message formatting](/help/format-your-message-using-markdown)
