# Draft messages

Zulip automatically saves the content of your message as a draft when you close
the compose box, ensuring that you never lose your work. When you start
composing, the most recently edited draft for the conversation you are composing
to automatically appears in the compose box. Drafts are saved for 30 days.

!!! warn ""

    **Note**: Drafts are local to your client, and are not synced to
    other devices and browsers.

## Save a draft

### Save a draft and stop composing

{start_tabs}

{tab|desktop-web}

{!start-composing.md!}

1. Type at least 3 characters of text into the compose box.

1. Close the compose box. For example, you can click the
   <i class="fa fa-remove"></i> icon in the top right corner of the compose
   box, or click on an empty area of the app to close the compose box and save
   your message as a draft.

!!! keyboard_tip ""

    You can also use <kbd>Esc</kbd> to close the compose box and save your
    message as a draft.

{end_tabs}

### Save a draft and start a new message

{start_tabs}

{tab|desktop-web}

{!start-composing.md!}

1. Click on the **ellipsis** (<i class="zulip-icon zulip-icon-more-vertical"></i>)
   in the bottom right corner of the compose box, next to the **Send**
   (<i class="zulip-icon zulip-icon-send"></i>) button.

1. Select **Save draft and start a new message**.

{end_tabs}

## Restore a draft

To make it easier to find the draft you are looking for, drafts for the
conversation you are composing to are shown at the top of the drafts list in the
web and desktop apps. If you have saved drafts for the current conversation, the
counter next to the **Drafts** button in the compose box shows how many there are.

{start_tabs}

{tab|via-left-sidebar}

{!go-to-draft-messages.md!}

1. Click the **pencil** (<i class="fa fa-pencil"></i>) icon on the draft you
   want to restore.

!!! keyboard_tip ""

    You can also use <kbd>D</kbd> to bring up your list of saved drafts, and
    <kbd>Enter</kbd> within the drafts view to restore the selected draft.

{tab|via-compose-box-buttons}

{!start-composing.md!}

1. Click the **Drafts** button on the right side of the compose box.

1. Click the **pencil** (<i class="fa fa-pencil"></i>) icon on the draft you
   want to restore.

!!! keyboard_tip ""

    You can also use <kbd>D</kbd> to bring up your list of saved drafts, and
    <kbd>Enter</kbd> within the drafts view to restore the selected draft.

{end_tabs}

## Delete drafts

### Delete a draft

{start_tabs}

{tab|via-left-sidebar}

{!go-to-draft-messages.md!}

1. Click the **trash** (<i class="fa fa-trash-o"></i>) icon on the draft you
   want to delete.

!!! keyboard_tip ""

    You can also use <kbd>D</kbd> to bring up your list of saved drafts, and
    <kbd>Backspace</kbd> within the drafts view to delete the selected draft.

{tab|via-compose-box-buttons}

{!start-composing.md!}

1. Click the **Drafts** button on the right side of the compose box.

1. Click the **trash** (<i class="fa fa-trash-o"></i>) icon on the draft you
   want to delete.

!!! keyboard_tip ""

    You can also use <kbd>D</kbd> to bring up your list of saved drafts, and
    <kbd>Backspace</kbd> within the drafts view to delete the selected draft.

{end_tabs}

### Delete multiple drafts

{start_tabs}

{tab|via-left-sidebar}

{!go-to-draft-messages.md!}

1. Click **Select all drafts** in the upper right corner of
   the drafts view, or select the drafts you want to delete
   by toggling the checkboxes on the right.

1. Click the **trash** (<i class="fa fa-trash-o"></i>) icon in the
   upper right corner of the drafts view to delete all selected drafts.

!!! keyboard_tip ""

    You can also use <kbd>D</kbd> to bring up your list of saved drafts.

{tab|via-compose-box-buttons}

{!start-composing.md!}

1. Click the **Drafts** button on the right side of the compose box.

1. Click **Select all drafts** in the upper right corner of
   the drafts view, or select the drafts you want to delete
   by toggling the checkboxes on the right.

1. Click the **trash** (<i class="fa fa-trash-o"></i>) icon in the
   upper right corner of the drafts view to delete all selected drafts.

!!! keyboard_tip ""

    You can also use <kbd>D</kbd> to bring up your list of saved drafts.

{end_tabs}

## Related articles

* [Schedule a message](/help/schedule-a-message)
* [Preview messages before sending](/help/preview-your-message-before-sending)
* [Verify a message was sent](/help/verify-your-message-was-successfully-sent)
* [Edit a message](/help/edit-a-message)
* [Delete a message](/help/delete-a-message)
