# View images and videos

Zulip shows previews of attached images and videos, unless previews are
[disabled](/help/allow-image-link-previews) in your organization. You
can click on a preview to view an image in more detail, or to play a
video. Zulip also makes it convenient to browse all images and videos
attached to messages in your current view.

## Use the image viewer

{start_tabs}

{tab|desktop-web}

1. Click an image preview to open the **image viewer**.

1. You can interact with the image.

    * Zoom in and out of the image

    * Click and drag the image

    * **Reset zoom** so that the image is recentered and back to its original size

    * **Open** the image in a new browser tab

    * **Download** the image

1. Click anywhere outside the image to close the image viewer once you are done.

!!! tip ""

    You can click on the file name to download an image rather than viewing it
    in the Zulip app.

!!! keyboard_tip ""

    Use <kbd>V</kbd> to **open** the image viewer. Use <kbd>Shift</kbd> +
    <kbd>Z</kbd> and <kbd>Z</kbd> to zoom in and out of the image. Use
    <kbd>V</kbd> or <kbd>Esc</kbd> to **close** the image viewer.

{tab|mobile}

1. Tap an image preview or file name to open the **image viewer**.

1. You can interact with the image.

    * Zoom in and out of the image

    * Pan the image if you are zoomed in

    * Tap the **ellipsis** (<i class="zulip-icon zulip-icon-more-vertical-spread"></i>)
      in the bottom right corner of the app to download the image, share it to
      other apps, or share a link to the image

1. Tap the **X** in the upper right corner of the app to close the image viewer
   once you are done.

{end_tabs}

## Use the video player

{start_tabs}

{tab|desktop-web}

1. Click a video thumbnail to open the **video player**.

1. You can interact with the video.

    * **Play** the video

    * Adjust the **volume**

    * Watch in **full screen** mode

    * **Open** the video in a new browser tab

    * **Download** the video if it was uploaded to Zulip

    * Adjust **playback speed**

    * Turn on **picture-in-picture**

1. Click anywhere outside the video to close the video player once you are done.

!!! tip ""

    You can click on the file name to open the video in a new browser tab
    rather than viewing it in the Zulip app.

!!! keyboard_tip ""

    Use <kbd>V</kbd> to **open** the video player.
    Use <kbd class="arrow-key">↑</kbd> and <kbd class="arrow-key">↓</kbd>
    to increase or decrease the volume.
    Use <kbd>V</kbd> or <kbd>Esc</kbd> to **close** the video player.

{tab|mobile}

1. Tap a video thumbnail, link, or file name to open the video in your device's
   default browser.

1. You can switch back to the Zulip app once you are done.

{end_tabs}

## Browse images and videos

In the Zulip desktop or web app, you can browse the images and videos in
the current view. For example, if you're in a channel view, you'll be able
to browse through all the images and videos in that channel. If you do a
[search](/help/search-for-messages), the **viewer** will display all the
images and videos in messages matching that search.

{start_tabs}

{tab|desktop-web}

1. Click an image preview or video thumbnail to open the viewer.

1. Browse by using the left and right arrow buttons at the bottom of the viewer.

1. Click any image or video to display it.

!!! keyboard_tip ""

    Use <kbd>V</kbd> to **open** the viewer. Use
    <kbd class="arrow-key">←</kbd> and <kbd class="arrow-key">→</kbd>
    to scroll through the collection of images and videos.

{end_tabs}

## Related articles

* [Manage your uploaded files](/help/manage-your-uploaded-files)
* [Share and upload files](/help/share-and-upload-files)
* [Image, video and website previews](/help/allow-image-link-previews)
