# Zulip Cloud billing

This page answers some frequently asked questions about [Zulip Cloud plans and
pricing](https://zulip.com/plans/). If you have any other questions, please
don't hesitate to reach out at [sales@zulip.com](mailto:sales@zulip.com).

## Upgrade to a Zulip Cloud Standard or Plus plan

{start_tabs}

{tab|by-card}

{relative|gear|plans}

1. On the page listing Zulip Cloud plans, click the button at the bottom
   of the plan you would like to purchase.

{!plan-upgrade-steps.md!}

{tab|by-invoice}

{!pay-by-invoice-warning.md!}

{relative|gear|plans}

1. On the page listing Zulip Cloud plans, click the button at the bottom
   of the plan you would like to purchase.

{!pay-by-invoice-steps.md!}

{end_tabs}

## Manage billing

{!manage-billing-intro.md!}

{start_tabs}

{tab|desktop-web}

{relative|gear|billing}

{end_tabs}

## Cancel paid plan

If you cancel your plan, your organization will be downgraded to **Zulip Cloud
Free** at the end of the current billing period.

{start_tabs}

{tab|desktop-web}

{relative|gear|billing}

1. At the bottom of the page, click **Cancel plan**.

1. Click **Downgrade** to confirm.

{end_tabs}

## Free and discounted Zulip Cloud Standard

Zulip sponsors free plans for over 1000 worthy organizations. The following
types of organizations are generally eligible for a free **Zulip Cloud Standard** plan.

- Open-source projects, including projects with a small paid team.
- Research in an academic setting, such as research groups, cross-institutional
  collaborations, etc.
- Academic conferences and other non-profit events.
- Non-profits with no paid staff.
- Most communities that need features beyond the Free plan in order to use Zulip.

The following types of organizations are generally eligible for significant
discounts on **Zulip Cloud Standard**.

- Education organizations are eligible for [education
  pricing](https://zulip.com/for/education/#feature-pricing).

- Discounts are available for organizations based in the **developing world**.

- Non-profits and other organizations where many users are **not paid staff**
  are generally eligible for a discount.

If there are any circumstances that make regular pricing unaffordable for your
organization, contact [sales@zulip.com](mailto:sales@zulip.com) to discuss your
situation.

### Education pricing

Educators using Zulip with students are eligible for discounted [education
pricing](https://zulip.com/for/education/#feature-pricing). Other educational
uses (e.g., by teaching staff or university IT) may qualify for a non-profit
discount instead.

!!! tip ""
    Organizations operated by individual educators (for example, a professor
    teaching one or more classes) usually find that the [Zulip Cloud Free
    plan](https://zulip.com/plans/#cloud) suits their needs.


Non-profit educational pricing applies to online purchases with no additional
legal agreements, for use at registered non-profit institutions (e.g., colleges
and universities).

To arrange discounted pricing for your organization, please [apply for
sponosorship](#apply-for-sponsorship). Contact
[sales@zulip.com](mailto:sales@zulip.com) with any questions.


### Apply for sponsorship

Submit a sponsorship request to apply for a free or discounted **Zulip Cloud
Standard** plan. If you do not have a Zulip organization yet, contact
[sales@zulip.com](mailto:sales@zulip.com) to inquire about sponsorship
eligibility.

{start_tabs}

{tab|request-sponsorship}

1. Click on the **gear** (<i class="zulip-icon zulip-icon-gear"></i>) icon in
   the upper right corner of the web or desktop app.

1. Click the **Request sponsorship** link at the top of the gear menu.

1. Fill out the requested information, and click **Submit**.

!!! tip ""

     If you don't see the **Request sponsorship** link in the gear menu,
     update your [organization type](/help/organization-type) to one of
     the eligible types of organizations [listed
     above](#free-and-discounted-zulip-cloud-standard) that best fits
     your organization.

{tab|request-education-pricing}

1. Click on the **gear** (<i class="zulip-icon zulip-icon-gear"></i>) icon in
   the upper right corner of the web or desktop app.

1. Click the **Request education pricing** link at the top of the gear menu.

1. Fill out the requested information, and click **Submit**.

!!! tip ""

     If you don't see the **Request education pricing** link in the gear menu,
     update your [organization type](/help/organization-type) to either
     **Education (non-profit)** or **Education (for-profit)**.

{end_tabs}

## Differences between Zulip Cloud plans

### How does having 10,000 messages of search history on Zulip Cloud Free work?

Only the most recent 10,000 messages can be viewed and searched on the Zulip
Cloud Free plan. Older messages are still stored and will become available
again if the organization is upgraded to **Zulip Cloud Standard**.

### Will you switch to limiting Zulip Cloud Free history to messages sent in the last 90 days (like Slack has)?

**No.** As discussed in [this blog
post](https://blog.zulip.com/2022/08/26/why-slacks-free-plan-change-is-causing-an-exodus/),
a time-based limit to message history is simply a bad model for a collaboration
tool.

## Payment methods

### What are my payment options?

{!payment-options.md!}

### International SWIFT transfers

{!international-wire-transfers.md!}

### How does automatic license management work?

{!automatic-billing.md!}

### How does manual license management work?

{!manual-billing-intro.md!}

#### Manually update number of licenses

{start_tabs}

{tab|desktop-web}

{relative|gear|billing}

{!manual-add-license-instructions.md!}

{end_tabs}

## Temporary users and guests

### How will I be charged for temporary users (e.g., limited-time clients)?

Users [can be deactivated](/help/deactivate-or-reactivate-a-user) any time.
Deactivating a user frees up their license for reuse.

### How are guest accounts billed? Is there special pricing?

For an organization with N other users, 5*N [guest users](/help/guest-users)
are included at no extra charge. After that, you will be charged at 1/5 of
your regular per-user pricing for each additional guest.

## Related articles

* [Trying out Zulip](/help/trying-out-zulip)
* [Zulip Cloud or self-hosting?](/help/zulip-cloud-or-self-hosting)
* [Self-hosted billing](/help/self-hosted-billing)
* [Migrating from other chat tools](/help/migrating-from-other-chat-tools)
* [Contact support](/help/contact-support)
