## Asciidoctor: An active open-source community building software to share knowledge

Started in 2012, the [Asciidoctor](https://asciidoctor.org) community develops
an [open-source](https://github.com/asciidoctor) text processor for parsing
AsciiDoc content, enriching it, and converting it to formats such as HTML 5,
DocBook, PDF, and many others.

For years, the project struggled to find a way to bring the community together
in one place. Thanks to recommendations from leaders at other open-source
communities, the Asciidoctor project leads decided to give Zulip a try to see if
it could solve those challenges. “Moving to Zulip transformed our dialogue,
making it organized, inclusive, and thoughtful in a way it never was before,”
says project lead [Dan Allen](https://github.com/mojavelinux). “We finally had a
home base. Zulip has been a game changer for our community.”


> “Zulip has been a game changer for our community.”
>
> — Project lead Dan Allen


## A decade-long search for a communication platform to bring the community together

“In the early days, we started out only communicating using the GitHub issue
tracker,” Dan Allen recalls, “but we could see that it wasn’t going to scale. It
doesn’t provide a channel for general dialogue.” The project tried IRC, but it
was unapproachable for newcomers and lacked modern chat and moderation features.
Asciidoctor set up a discussion list, but that wasn’t a good fit either.
Contacting hundreds of people over email to ask a simple question always felt
inappropriate, and the lack of real-time interaction ended up making
conversations take longer.

Looking for a web-based chat solution, Asciidoctor tapped into Gitter in 2014.
“Gitter certainly looks modern and approachable. However, we quickly learned
that the single, running thread of the channel was both chaotic and stressful,”
Dan says. And the platform had mostly stagnated.

Many users in the community pleaded for threads, but Gitter’s threading feature
(finally added in 2020), only made the situation more problematic for the
community. “Threads buried the replies. You had to either navigate to threads
using notifications, or scroll back multiple pages to find the little ‘see
replies’ link and rediscover the thread. It was just so tedious,” Dan recalls.


> “The conversations in Gitter were becoming more about Gitter and its
> limitations and less about the project itself.”
>
> — Project lead Dan Allen

While Gitter allows users to create new rooms, what the project really needed
was a single community space with “socially distanced” conversations going on.
They needed a new model. And that’s exactly what they found in Zulip.


## Asciidoctor moves to Zulip: “All the anxiety and stress was gone”

With the community continuing to grow, Dan and fellow maintainers decided it was
time to seek out a better solution. Drawing on advice from leaders of other
open-source communities, the project decided to give Zulip a try in early 2021.

[Zulip’s channels and topics model](/why-zulip/) immediately clicked. “Channels
partition the community without making it feel divided. When someone has a
question, they can find the most relevant channel and either make a new topic or
contribute to an existing one.” This paradigm was a game-changer. “Literally the
day we moved to Zulip, all the anxiety and stress of keeping up with the
discourse was gone,” Dan says.

With Zulip, Dan has developed a comfortable workflow for catching up on
conversations after being away. “When I start my day, I open up the [Recent
topics](/help/recent-conversations) page and work through the topics that have
activity on-by-one,” Dan describes. More casual community participants can [skim
the topic list](/help/reading-strategies) to find interesting discussions, and
mark topics they don’t care about as read with a single click.


## Powerful moderation tools help keep conversations on track

Zulip’s topic model helps discussions stay focused. “Zulip starts the
conversation out on the right foot by giving it its own space as a topic,” Dan
explains. “As a result, conversations don’t have to be branched from an
arbitrary spot, and the discussion is much more likely to stay focused and
succinct.”

> “Zulip starts the conversation out on the right foot by giving it its own
> space as a topic.”
>
> — Project lead Dan Allen

If a topic starts in the wrong place or veers off course, Zulip’s [moderation
tools](/help/moderating-open-organizations) make it easy to fix. Community
moderators can keep the dialogue organized by reclassifying topics and posts
without disrupting the ongoing conversation. “If someone accidentally posts to
the wrong channel or topic, Zulip allows me to [move those messages
around](/help/move-content-to-another-channel) so they land in the right spot,”
Dan says. “Moving messages also sends a subtle hint to the person posting about
where to post the next time. And I can use [topic
references](/help/link-to-a-message-or-conversation#link-to-a-channel-or-topic-within-zulip)
to link to the new topic location, or to a related topic. That’s incredibly
powerful,” Dan says.

The ability to [mark topics as resolved](/help/resolve-a-topic) helps moderators
see at a glance which topics require their attention. “Many topics reach a
logical conclusion when the initial question has been answered, and the initial
poster will typically express that they’re satisfied. At that point, one of us
marks the topic as resolved,” Dan explains. “When I’m looking for topics that
need my attention, I can focus on the ones that aren’t yet resolved and try to
help get them to that state.” Later on, community members can use resolved
topics [as a reference source](#zulip-makes-information-easy-to-find).


## Zulip enables organized, inclusive and thoughtful discussion

After a successful launch of the Asciidoctor community on Zulip, Asciidoctor’s
sibling project [Antora](https://antora.org) adopted it as well. For both
projects, using Zulip has been night and day compared to other platforms. “I can
manage hundreds of participants across two communities extremely efficiently,
and I don’t feel stressed,” says Dan. “I used it for my company chat as well.
Zulip is calm and organized. I can immediately see what people are asking
and jump to respond when I need to.”

> “I can manage hundreds of participants across two communities extremely
> efficiently.”
>
> — Project lead Dan Allen

The sense of space created by Zulip’s topic model has made the community more
inclusive. “Using Zulip gives space to a much broader range of voices.
We’re seeing people participating who never participated before,” Dan says.
“People who are less extroverted, who don’t speak English natively, or just
can’t type as quickly now all have a chance to be part of the dialogue. Zulip
offers a more manageable pace.”

> “We’re seeing people participating who never participated before.”
>
> — Project lead Dan Allen

Even the tone of conversation has shifted, becoming more respectful and
thoughtful. “People are more relaxed. They can think and take their time to
reply. Topics give people space. People don’t feel like they are trying to talk
over someone else. That means you can have more constructive dialogue because
the volume level is lower,” says Dan. At the same time, Zulip enables
lightweight interactions. “Often times, I participate just [using
emoji](/help/emoji-reactions). I must use the 👍 and 🎉 reactions dozens of
times a day,” Dan says.

Channels have also helped the community get to know one another better. “When we
created the instance, we set up a #social channel. We seeded it with the topic
‘introduce yourself’, and new members took full advantage of it,” Dan says. The
social channel has brought a more personal touch to the community. “In real life,
no one just walks in and starts asking questions out of the blue,” Dan points
out. “In the social channel, we’ve talked about non-technical topics like TV
series, screen setups, and holiday wishes just to get to know the people behind
the screen name and enrich each other’s lives in other ways. What we learned?
Everyone enjoys a lot of British TV. ;)”


## Zulip makes information easy to find

As a community grows, its conversation history becomes a trove of reference
information. However, this history provides value only if the information is
findable. “Once a conversation went out of view in Gitter, it was essentially
lost,” Dan says. “The search was global across the whole Gitter instance, and it
only returned excerpts with no sense of context. It was often faster to just
scroll through the history in an attempt to try to find where the conversation
happened than it was to search.”

In contrast, Zulip offers a [faceted search](/help/search-for-messages) that
lets you find past discussions with pinpoint accuracy. “You can narrow the
search to a channel or topic (with autocomplete!),” Dan points out. The results
are presented with topic headings, making it easier to see whether the message
is relevant. “You can click the topic to see the message in context,” Dan says.
“It’s not only a great way to search, but it’s a great way to catch up on
messages too. You can also search for all messages you sent, which turns out to
be a great navigation tool and a memory saver!”


## “Zulip is the heart of our community”

Dan is passionate about supporting Zulip’s development. “If we don’t sponsor the
open source projects we love, we’ll have no one else to blame if we live in a
world of proprietary software,” Dan says. “We truly feel heard by Zulip
developers when we provide feedback. We also love that Zulip is [truly open
source](https://blog.zulip.com/2021/04/28/why-zulip-is-on-github-sponsors/), not
open core like some alternatives. And we very much appreciate Zulip supporting
open source by hosting our Zulip instances.”

“Zulip is the heart of our community, and nearly everyone who participates
absolutely loves it,” Dan says. “It really does provide [everything we
need](/features/) to manage the discourse, including topic-based threads,
mentions, faceted search, moderation controls, polls, and emoji.” Speaking on
behalf of the Asciidoctor and Antora projects, Dan wholeheartedly recommends
that other communities give it a try. “Many communities have been strained to
the limits during the pandemic,” says Dan. “Zulip brings health back to these
communities.”

---

Check out our guide on using Zulip for [open source](/for/open-source/), and
learn how Zulip [helps communities scale](/for/communities/)!
