Founded in 2019 by a seasoned team of engineering and sales leaders, Atolio is a
small startup with big ambitions to radically improve the way people deal with
information at work. They have deep expertise in what it takes to [empower teams
to collaborate effectively](/why-zulip/), and have thought hard about how to
enable effective collaboration for their own team.

> “The first-class threads in Zulip are absolutely critical to how we work.  As
> a fully distributed company, we needed a modern way to support the different
> ways people work, while ensuring that everyone can find the current and
> historical topics that are important to them.  So many people on Hacker News
> talk about using Zulip - I'm so glad we joined them!”
>
> — David Lanstein, co-founder and CEO of [Atolio](https://www.atolio.com/)


## Taking the opportunity to pick the best collaboration tools

Atolio’s founders set out to build a fully distributed company from the get-go,
and they knew how important it would be to choose the right set of collaboration
tools. “We had all used Slack, Jira and Confluence before, but we didn’t want to
default to those options,” says Atolio’s co-founder and CTO Gareth Watts. “We
wanted to take the opportunity to pick the best tools for our future team.”

As past users of Slack’s team chat, Atolio’s founders were well aware of its
downsides. "Slack is an extremely noisy environment. It’s very difficult to keep
up with what your colleagues are doing, and it’s hard to separate chitchat from
what’s important,” says Atolio’s CTO Gareth Watts. “Information in Slack’s
threads ends up being even more hidden than other messages.”

Thus the search was on to find a team chat tool that would truly serve Atolio’s
needs. “We didn’t want Slack,” Gareth says. “We wanted a tool designed for
asynchronous distributed communication, and Zulip seemed to fit the bill.”

> "Slack is an extremely noisy environment. It’s very difficult to keep up with
> what your colleagues are doing.”
>
> — Gareth Watts, co-founder and CTO of [Atolio](https://www.atolio.com/)

## Trying out Zulip’s open-source team chat

Beyond Zulip’s [topic-based threading model](/why-zulip/), Atolio’s team felt
confident that they could [count on Zulip in the coming years](/values/) as they
built out their company. “We liked that Zulip is an open-source tool with a
[huge community](/team/) around it,” Atolio’s CTO Gareth Watts explains. “We are
using Zulip Cloud, but if we want, we can export our data and
[self-host](/self-hosting/) our own Zulip server. So we know Zulip will always
be there for us.”

Having decided to test out Zulip, Atolio’s founders realized that they should go
all-in on a trial period. “We decided to turn off all other chat tools and try
Zulip for a full month,” Gareth says. This way, the team could really see how
Zulip would fit into the company’s communication patterns and workflows after an
initial adjustment period. “After that, we could discuss if it wasn’t working
out,” says Gareth. “But as it turned out, we never looked back.”

> “We decided to turn off all other chat tools and try Zulip for a full month…
> We never looked back.”
>
> — Gareth Watts, co-founder and CTO of [Atolio](https://www.atolio.com/)

## “Zulip is at the core of our business”

Since February 2020, Zulip has been the primary tool for internal communication
at Atolio. “Zulip is at the core of our business,” Atolio’s CTO Gareth Watts
explains. The team has always been able to rely on this crucial piece of company
infrastructure. “The Zulip Cloud hosting has been bulletproof — we haven’t had
any down time,” says Gareth.

Zulip’s organized team chat has enabled Atolio to create the open communication
culture the founders wanted. “Zulip lets us have conversations in public, not
behind closed doors,” Gareth explains. “In Slack, two thirds of communication is
not in public just to avoid noise. In Zulip, you can talk about what you want —
you just give everything its own topic.”

> “In Zulip, it’s super easy to find things 24 hours later if you weren’t online
> when a discussion happened.”
>
> — Gareth Watts, co-founder and CTO of [Atolio](https://www.atolio.com/)

Atolio’s distributed team also uses Zulip to build personal connections. With
each conversation getting its own space in a dedicated topic, team members can
share pictures of their cats or GIPHY memes without disrupting serious work
discussions. And if a topic ever goes off on a tangent, it’s easy to split it in
two and continue from there.

When new team members join the company, the onboarding process welcomes them to
Zulip and the company’s communication culture. An internal Wiki introduces
Zulip’s [topic-based threading](/help/introduction-to-topics), [search
tools](/help/search-for-messages), and some handy [keyboard
shortcuts](/help/keyboard-shortcuts), with pointers to [Zulip’s help
center](/help/) for more information. Gareth hasn’t seen much difference between
onboarding to Zulip compared to other team chat tools: “If someone hasn’t used
Slack before, they need onboarding too.”

> “Zulip lets us have conversations in public, not behind closed doors.”
>
> — Gareth Watts, co-founder and CTO of [Atolio](https://www.atolio.com/)

## Easy to integrate

To make Zulip a central hub for updates about what’s happening, Atolio has
integrated Zulip with its engineering tools. In a #tickets channel, a topic is
created automatically for each ticket, so there is a dedicated space to discuss
the issue at hand. There are topics in other Zulip channels for automated
deployment announcements, and for bot posts when pull requests are opened or
merged.

Atolio has also [connected Zulip](https://www.atolio.com/connectors/) to their
own unified search product. “Writing against the [Zulip APIs](/api/) has not
been hard,” Gareth says. “And since it’s open-source, we can always [read the
source code](https://github.com/zulip/zulip#readme) if we find the docs
confusing.”

---

Check out our guide on [using Zulip for business](/for/business/). You can also
learn how Zulip is being used at the InsurTech startup
[Semsee](/case-studies/semsee/), the [iDrift AS](/case-studies/idrift/) company,
the [End Point Dev](/case-studies/end-point/) software consultancy, and the [GUT
contact](/case-studies/gut-contact/) support agency.
