## Organizing the flow of information

Founded in 1995, [End Point Dev](https://www.endpointdev.com/about/) is a
full-service software consultancy, with a diverse set of customers: from
startups, to giants like Google, NASA, Oracle, and Morgan Stanley. The company
employs a team of 65 or so software developers, data organizers, and security
experts distributed all around the globe. Each project brings together talented
individuals with the right mixture of skills, wherever they might be located.

For the past six years, End Point has been using Zulip to stay connected as a
team. “Other apps like Slack would struggle with organizing the flow of
information in a complex organization like ours,” says End Point CTO [Jon
Jensen](https://www.endpointdev.com/team/jon-jensen/). “Zulip’s UI makes it easy
to access all the information you need, without being too cluttered.”


> “Zulip’s UI makes it easy to access all the info you need.”
>
> — [Jon Jensen](https://www.endpointdev.com/team/jon-jensen/), CTO of End Point

## Legacy software challenges

In 2005, looking to improve on email and phone communication, the company set up
an IRC chat server. Many team members loved IRC’s realtime chat experience. As
the company evolved, however, IRC’s limited feature set (for example, there were
no file uploads), became a growing concern.

By 2017, while most of the company was still on IRC, one division had moved to
Flowdock, and another team that had joined in an acquisition was using Slack.
The company’s collaboration tools were no longer helping everyone stay
connected. “Having multiple chat systems was bad for our culture,” says End
Point’s CTO [Jon Jensen](https://www.endpointdev.com/team/jon-jensen/). “Some
people were always cut out of the conversation.”

## Choosing Zulip: A modern feature set with a snappy UI

It was time to find a team chat solution that would bring the company back
together. Unfortunately, none of the tools already in use would do the job.
“Slack’s interface was too slow and clunky,” [Jon
Jensen](https://www.endpointdev.com/team/jon-jensen/) explains, “And the more
channels you’re in, the harder it is to use,” which was a show-stopper for a
consulting company with hundreds of ongoing projects.


> “Slack’s interface was too slow and clunky, and the more channels you’re in,
> the harder it is to use.”
>
> — [Jon Jensen](https://www.endpointdev.com/team/jon-jensen/), CTO of End Point

Inclined to go with a self-hosted solution, Jon and some of his co-workers
explored all the leading open-source team chat products. They found that while
Mattermost and Rocket.Chat were similar to Slack (but felt less polished), Zulip
stood out. “Zulip had all the modern features we were looking for, like
reliable, flexible notifications. At the same time, the [extensive keyboard
shortcuts](/help/keyboard-shortcuts) and the ‘Combined feed’
view offered a UI that the IRC fans loved.”

When End Point moved to Zulip, it was an immediate improvement over the
hodge-podge of tools previously in use. “Choosing topics in Zulip felt like a
hurdle at first,” Jon recalls, “but the team got used to it pretty quickly.” Not
entering a topic is always an option, and Zulip’s topics help users read their
messages more efficiently. “It’s nice to be able to [mute](/help/mute-a-topic)
busy topics,” Jon says.

## “Zulip is our virtual office”

For the past six years, the Zulip chat has been a virtual office for End Point’s
distributed team, a place to show up and be present at work. Discussing projects
in Zulip channels keeps everyone informed.

“Zulip is my lifeline,” says [Joanne
Tipton](https://www.endpointdev.com/team/joanne-tipton/), a senior team manager
at End Point. “I’m on it all day. I need to have an idea of all the things that
are going on, so the [desktop notifications](/help/desktop-notifications) are
invaluable.” There are 130 channels in the organization, and managers are
subscribed to most of them. Joanne takes advantage of per-channel flexibility for
notifications, turning on notification sounds just for low-traffic channels where
every message is important.

> “Zulip is my lifeline.”
>
> — [Joanne Tipton](https://www.endpointdev.com/team/joanne-tipton/), Senior Team Manager at End Point

[Alejandro Ramon](https://www.endpointdev.com/team/alejandro-ramon/), who leads
the Immersive & Geospatial division, joined End Point the day before the move to
Zulip. Zulip has always been a core tool for his work at End  Point, and he has
built his workflows on Zulip’s [integrations](/integrations/). “With the
[Jenkins CI integration](/integrations/doc/jenkins), I can see when a job has
finished building and is ready to deploy,” Alejandro says. “I use this 100s of
times per week.”


> “I use Zulip’s Jenkins CI integration 100s of times per week.”
>
> — [Alejandro Ramon](https://www.endpointdev.com/team/alejandro-ramon/),
> Director of Immersive & Geospatial division at End Point

Zulip also enables real-time system monitoring, with error alerts sent into a
dedicated channel for each system. Alejandro relies on Zulip’s clear record of
what’s been happening with each installation, which combines automated alerts
with discussion by the team. “I use [search](/help/search-for-messages) quite a
bit,” Alejandro says. “Being able to filter by user and search term, and look at
a date range, is very helpful.”

Zulip is conveniently accessible no matter where Alejandro is working from. “The
[mobile apps](/apps/) work well when I need to connect from a customer site,”
Alejandro explains.

## Taking the pain out of team chat

End Point’s client companies use a wide variety of chat tools to communicate
with their collaborators at EndDev, from modern team chat tools like Slack and
Microsoft Teams, to tools designed primarily for 1:1 communication like Google
Chat and Skype. End Point’s CTO [Jon
Jensen](https://www.endpointdev.com/team/jon-jensen/) has experienced them all.

“It is amazing that companies would use Teams in its current state,” Jon says, a
bit exasperated. “The UI is slow and inconsistent, and you have to do so much
clicking to get anywhere. Compared to Zulip, it’s missing key features like the
‘Combined feed’ view and topics.”

> “It is amazing that companies would use Teams in its current state. The UI is
> slow and inconsistent, and compared to Zulip, it’s missing key features.”
>
> — [Jon Jensen](https://www.endpointdev.com/team/jon-jensen/), CTO of End Point

In Jon’s view, any communication tool imposes some cost on the team. “When
you’re choosing a team chat tool, you’re deciding how much pain are you
requiring your staff to undergo,” Jon explains. “And if your remote tools are
painful to use, you marginalize remote staff,” as conversations move from chat
to offices and hallways. Thankfully, this is not a problem at End Point, Jon
says. “Zulip removes much of the pain that makes people not want to use team
chat apps. We love it."

>  “Zulip removes much of the pain that makes people not want to use team chat
>  apps. We love it.”
>
> — [Jon Jensen](https://www.endpointdev.com/team/jon-jensen/), CTO of End Point

---

Check out our guide on [using Zulip for business](/for/business/). You can also
learn how Zulip is being used at the [iDrift AS](/case-studies/idrift/) company,
the [GUT contact](/case-studies/gut-contact/) support agency, and the startups
[Semsee](/case-studies/semsee/) and [Atolio](/case-studies/atolio/).
