For over 20 years, GUT contact has been offering premium customer support,
outbound sales and other German-language services. The company achieves top
performance by putting employees in a productive and motivating environment.
Company leadership makes mindful choices about the tools employees use to get
their work done, and has successfully scaled the team to over 1000 agents.

Agents at GUT contact use Zulip every day to communicate with their team leads.
“Most of our agents are in their 60s or 70s, so the software must be as simple
as possible. That’s why we love Zulip,” says [Erik
Dittert](https://gutcontact.de/unternehmen/team/erik-dittert/), who’s been
leading GUT contact’s IT team for the past 20 years.

> “The software must be as simple as possible. That’s why we love Zulip.”
>
> — Erik Dittert, [Head of
> IT](https://gutcontact.de/unternehmen/team/erik-dittert/) at [GUT
> contact](https://gutcontact.de/)


## “Our agents don’t need email accounts”

GUT contact relies on team chat for written communication within the company.
“Our agents don’t need email accounts,” says Erik Dittert, GUT Contact’s Head of
IT. “If someone has an email, they’ll get spam.” Instead, under Erik’s
leadership, GUT contact has been self-hosting open-source team chat applications
for years, upgrading as technology has evolved.

The company started with IRC, used an XMPP chat client for a while, and in 2019
moved to Rocket.Chat. “Rocket.Chat was a little bit better than our XMPP
server,” Erik says. However, when Erik learned about Zulip, he was excited to
check it out. “I installed Zulip, and the IT team played with the app. We loved
it. The UI was just cleaner, easier,” Erik says.

Zulip’s topic-based threading model was transformative. With other chat apps,
“the first person has a question about something, the next person has a question
about something else. You answer the first person, and the second person is
confused,” Erik explains. This doesn’t happen with Zulip’s topics.

> “Topic-based communication is a big big big feature we love in Zulip.”
>
> — Erik Dittert, [Head of
> IT](https://gutcontact.de/unternehmen/team/erik-dittert/) at [GUT
> contact](https://gutcontact.de/)


## Smooth transition to Zulip

Erik showed Zulip to his boss and others at the company, and in October 2022,
GUT contact made the switch.

“Zulip was quite easy to set up, and worked instantly. 1000 people — no
problem,” Erik recalls. “I hooked up the Zulip server to LDAP, and our agents
loved not having to remember a separate username and password.” Erik considered
importing data from Rocket.Chat into Zulip, but in the end it was decided that
the messy conversation history was not worth preserving.

Erik put training videos on the company’s intranet to explain the switching
process, and to give an overview of key new features. Employees were encouraged
to play around with Zulip, create channels, and chat with each other. After a
month of running Zulip in parallel with Rocket.Chat, the old system was turned
off.

> “Zulip was quite easy to set up, and worked instantly. 1000 people — no
> problem.”
>
> — Erik Dittert, [Head of
> IT](https://gutcontact.de/unternehmen/team/erik-dittert/) at [GUT
> contact](https://gutcontact.de/)


## Easy for anyone to use

GUT contact offers employees the flexibility to work from one of 10 offices
across 3 countries, or from their home office. This makes Zulip a critical
communication tool across all job functions. There is a channel for each
department (IT, human resources, etc.), as well as a dedicated channel for each
customer, where team leaders post daily updates.

For agents, many of whom are not fully comfortable with modern software, Zulip
being easy to use is invaluable. "We checked out Microsoft Teams and Mattermost,
and most of our users didn’t like these programs, because they didn’t know how
to work with them,” Erik says. “In Zulip, agents love the “Combined feed” view,”
which combines direct messages and channel messages into a single feed. “Unlike
other chat apps, you don’t have to click on each channel separately to see
unreads,” Erik explains.

## Functionality for the most technical users

Members of the IT team use Zulip to collaborate from around the world. “We share
code all the time, and the formatting and syntax highlighting is great,” Erik
says. When they need to jump on a call, “The Jitsi integration is perfect. We
don’t have to deal with emailing a calendar invite.”

Outside of office hours, Erik uses the mobile app to check on his message inbox.
It’s easy to skim the list of topics to check if anything requires timely
attention. “I love the clean mobile app and the push notifications,” Erik says.
“The app is extremely fast — you click, and messages show up instantly.”

Erik meets up regularly with other technologists to “have a beer and talk about
cool software.” In this 50-person group, “Zulip is quite a big theme right now,”
Erik says.

>  “I love Zulip. I use it every day, every night.”
>
> — Erik Dittert, [Head of
> IT](https://gutcontact.de/unternehmen/team/erik-dittert/) at [GUT
> contact](https://gutcontact.de/)

---

Check out our guide on [using Zulip for business](/for/business/). You can also
learn how Zulip is being used at the [iDrift AS](/case-studies/idrift/) company,
the [End Point Dev](/case-studies/end-point/) software consultancy, and the
startups [Semsee](/case-studies/semsee/) and [Atolio](/case-studies/atolio/).
