## A distributed team

For the past 20 years, iDrift AS has been offering infrastructure and security
support for small businesses. iDrift AS is a distributed organization, operating
from six offices across Norway. As such, this 30-person company has always
depended on team chat to coordinate and support each other’s efforts.

iDrift AS co-founder and owner Gaute Lund had long been frustrated with the
limitations of the company’s collaboration tools. “When I learned about Zulip it
was an absolute revelation,” says Gaute Lund. “Zulip’s threading model makes it
so much easier to manage my team. As a leader, in just a few minutes I can get
an overview over what's going on and see where my attention is needed.”


## Async communication is a challenge

From its founding, iDrift AS relied on IRC for internal communication, but the
lack of a modern user interface proved to be a barrier for participation for
management and non-technical members of the team. iDrift AS therefore moved from
IRC to Slack in October 2016.

“In terms of functionality, Slack is just souped-up IRC — there is no conceptual
difference,” says iDrift AS owner Gaute Lund. “It doesn’t add anything
significant other than the UI.”

While Slack worked reasonably well for real-time communication, the busy Slack
channels at iDrift AS were not effective for asynchronous discussions. “It was
almost impossible to catch up on a conversation, or get an overview of what you
missed while on vacation,” Gaute Lund says.

> “Slack is just souped-up IRC — there is no conceptual difference.”
>
> — Gaute Lund, co-founder and owner of iDrift AS


## Easy transition to Zulip

When a team member recommended Zulip, Gaute Lund understood the potential of
[Zulip’s threading model](/why-zulip/) to dramatically improve
async collaboration at iDrift AS. The company evaluated Zulip in the summer of
2020, and decided to make the move.

The team took easily to Zulip’s topic-based threading paradigm. “Once people
start using Zulip, it quickly becomes obvious why it’s better,” says Gaute Lund.

The transition also went smoothly from a technical perspective. “It was not a
lot of work to move everything over from Slack to Zulip,” says Gaute Lund. “The
export/import tool worked really well to ensure that we had logs of all the
prior conversations.”

Chat integrations for operational systems and alerts are a crucial part of the
workflow at iDrift AS. Zulip offers a [Slack-compatible
interface](/integrations/doc/slack_incoming), so many integrations could be
simply moved over. “For a handful of integrations where Zulip didn’t meet our
needs, it was easy to [create our own
integration](/api/integrations-overview#write-your-own-integration) or improve
the existing one. It wasn’t a problem,” Gaute Lund says.

iDrift AS decided to self-host its own Zulip server. Because Zulip is
[100% open source](https://github.com/zulip/zulip), this option offers
the same functionality as a [Zulip Cloud Standard](/plans/)
subscription. “Zulip is very stable, and easy to run and to upgrade,”
says Senior IT Consultant Tor Hveem.

> “Once people start using Zulip, it quickly becomes obvious why it’s better.”
>
> — Gaute Lund, co-founder and owner of iDrift AS


## Zulip helps leaders scale

The move to Zulip transformed Gaute Lund’s day-to-day experience as a leader.
“Using Zulip significantly increases the size of the team for which a manager
can meaningfully know what’s going on,” says Gaute Lund. “There are 25 people
for whom I have a very good grip on their work, whereas previously it was no
more than a handful”.


> “Using Zulip significantly increases the size of the team for which a manager
> can meaningfully know what’s going on.”
>
> — Gaute Lund, co-founder and owner of iDrift AS

As a Microsoft shop, iDrift AS uses Microsoft Teams for file sharing, scheduling
and video calls. Would they use it for team chat? “For technical people, the
chat experience in Teams is abhorrent,” says Gaute. “It’s almost impossible to
get an overview of what’s happening. Only a small number of messages fit on the
screen, and the discussions hidden inside threads make it even harder to see
what’s going on.”

In contrast, Zulip’s topic-based threading lets Gaute review conversations in
batches, without being constantly interrupted by chat messages. Every few hours,
Gaute looks through the list of recent Zulip topics to find discussions that may
require his attention, and offers feedback as needed. Catching up is fast:
“Updating myself on an incident might take a few seconds,” Gaute Lund says.


## Efficient team communication

With Zulip, the team can discuss everything from customer issues to major design
decisions. “Zulip lets people focus on conversations where they can contribute,
whether or not they happen to be online when the conversation starts,” says
Gaute Lund.

The Zulip chat also serves as a knowledge base for the history of the
organization. “We have a very stable customer base, and Zulip search makes it
easy to review past interactions,” Gaute Lund says.

> “Zulip lets people focus on conversations where they can contribute.”
>
> — Gaute Lund, co-founder and owner of iDrift AS

---

Check out our guide on [using Zulip for business](/for/business/). You can also
learn how Zulip is being used at the [End Point Dev](/case-studies/end-point/)
software consultancy, the [GUT contact](/case-studies/gut-contact/) support
agency, and the startups [Semsee](/case-studies/semsee/) and
[Atolio](/case-studies/atolio/).
