[The Recurse Center](https://www.recurse.com/about) (RC for short) offers
educational retreats for anyone who wants to get dramatically better at
programming.  Since its founding in 2011, [over 2000
participants](https://www.recurse.com/10-years) have attended the program,
either in person in New York City or (since the start of the Covid-19 pandemic)
remotely from anywhere in the world. Participants range from experienced
professional programmers to new programmers transitioning into the industry. The
retreats are free for everyone, and RC is funded entirely through its
[integrated recruiting agency](https://www.recurse.com/hire).

[A major highlight](https://www.recurse.com/why) of RC’s program is its active
online community of current participants and alumni. “The core of the Recurse
Center is the community, and the core of our online community is Zulip,”
[writes](https://www.recurse.com/blog/112-how-rc-uses-zulip) Recurse Center
[co-founder and CEO](https://www.recurse.com/team) Nick Bergson-Shilcock.
“Switching to Zulip has turned out to be one of the best decisions we’ve made,
and it’s impossible to imagine RC today without it.”


> “The core of the Recurse Center is the community, and the core of our online
> community is Zulip… Switching to Zulip has turned out to be one of the best
> decisions we’ve made, and it’s impossible to imagine RC today without it.”
>
> — [Nick Bergson-Shilcock](https://github.com/nicholasbs), Recurse Center
> [co-founder and CEO](https://www.recurse.com/team)


## Choosing Zulip in 2013: “One of the best decisions we’ve made”

The Recurse Center was an early adopter of Zulip. They began to use the product
in January 2013, when it was still in private beta. Even then, Zulip’s
thoughtful design made it stand out. “We wanted a private chat system that was
persistent, easily searchable, and which supported syntax highlighting for code
snippets,“ says Recurse Center co-founder and CEO Nick Bergson-Shilcock. “Zulip
gave us all the benefits above, along with a slew of others we hadn’t expected.”

When the startup building Zulip was [acquired by Dropbox in early
2014](https://zulip.com/history/), Zulip product development was put on hold for
a year and a half. Because of Zulip’s advantages over the alternatives, Recurse
Center continued using Zulip all through that time: “We strongly prefer Zulip to
other options for several reasons – its message threading being a key one,”
[wrote](https://www.recurse.com/blog/90-zulip-supporting-oss-at-the-recurse-center)
RC CEO Nick Bergson-Shilcock in 2015.

From the early days, the RC community has been passionate about Zulip. When
Dropbox generously decided to [release Zulip as open source
software](https://blogs.dropbox.com/tech/2015/09/open-sourcing-zulip-a-dropbox-hack-week-project/)
in 2015, Recurse Center alumni [flew out to San
Francisco](https://www.recurse.com/blog/90-zulip-supporting-oss-at-the-recurse-center)
for a week to help make it happen. Since then, Zulip has built the most active
open-source development community of any team chat software, with [75
people](https://zulip.com/team/) who’ve contributed 100+ commits.

> “It’s not an exaggeration to say Zulip has made RC a stronger community.”
>
> — [Nick Bergson-Shilcock](https://github.com/nicholasbs), Recurse Center
> [co-founder and CEO](https://www.recurse.com/team)


## Zulip becomes the backbone of a worldwide community

For years, the Zulip chat been the backbone of the Recurse Center community.
“Zulip is an integral part of the Recurse Center experience,” says Rachel
Petacat, [Head of Retreat](https://www.recurse.com/team) at Recurse Center, and
RC’s Director of Operations from 2014 to 2021.

Zulip serves as a collaboration hub for the current participants and alumni.
“Participants use Zulip to ask and answer questions, get code review, and
coordinate pairing sessions, reading groups, informal seminars, and countless
other forms of collaboration. Zulip is even more essential for our alumni, who
are in over 100 cities around the world but remain heavily involved thanks to
Zulip,” [writes](https://www.recurse.com/blog/112-how-rc-uses-zulip) RC CEO Nick
Bergson-Shilcock.

> [In the first ten years](https://www.recurse.com/10-years) since the Recurse
> Center was founded, the community sent **2.52 million** Zulip messages.

[Zulip’s threading model](https://zulip.com/why-zulip/) makes it easy to have
focused technical discussions. It also perfectly accommodates participants at
different levels of engagement. Current RC members can immerse themselves in the
ongoing discussions, occasionally muting topics they don’t want to follow. RC
leaders monitor the community asynchronously, reviewing the ongoing
conversations a few times a day and jumping in as needed. Finally, alumni can
drop by on occasion to skim [recent conversations](/help/recent-conversations),
catch up on their friends’ update threads, or search the discussion history for
a topic of interest.

“Our community is 10 years old and spans continents,” RC’s Head of Retreat
Rachel Petacat says. “Zulip provides the continuity that lets us maintain our
culture over time.”


## A welcoming environment for all community members

When new participants join the Recurse Center, Zulip becomes their port of entry
into the community. “With Zulip’s threading, new folks can get the full context
for a conversation, which makes the community feel welcoming,” Head of Retreat
Rachel Petacat says.


> “Zulip is more friendly to new users than Discord or Slack.”
>
> — Rachel Petacat, Recurse Center [Head of Retreat](https://www.recurse.com/team)

Threading also gives each conversation its own space, which means that community
members never have to feel like they are interrupting when they speak up.
“Threading makes it easy for anyone to jump in,” Rachel explains. ”Folks don’t
feel like they’re stepping onto someone’s conversation.”

Over the years, the Recurse Center has used Zulip’s customization features and
powerful, well-documented APIs to set up a space that really feels like a home
for the community. “We use so many custom emoji,” says Rachel Petacat.

A whole crew of bots is on hand to help out, from Chatbot for quick chat intros,
to [RSVPBot](https://github.com/wtfcarlos/RSVPBot#readme) for creating and
managing calendar events, to
[Blaggeregator](https://github.com/recursecenter/blaggregator#readme), which
aggregates blog posts for the RC community.


## “I can’t imagine being able to operate Recurse Center without Zulip”

Rachel Petacat is a long-time member of RC’s leadership team. Her job requires
keeping up with the ~45 members in the current batch, making sure they have what
they need to get the most out of their RC experience.

To juggle everything she needs to get done, Rachel takes full advantage of the
flexibility between synchronous and asynchronous discussions that Zulip offers.
Realtime chat on Zulip is perfect for coordinating with other members of the
leadership team. “Zulip is one of the first tabs I open at the start of the work
day,” Rachel says. “I can check what’s happening, and plan my day. Other
organizers and I tag each other on Zulip if we need any help.”

Rachel uses Zulip to follow the ongoing conversations, and help out as needed.
Zulip’s threading model makes it easy to review discussion threads every few
hours, and respond in context. “I read the discussions on Zulip once in the
morning and again in the afternoon, chiming in where I need to,” says Rachel.
With Zulip, Rachel is able to manage the community without her focus being
interrupted by the need to jump in before the moment has passed. “I can’t
imagine being able to operate the Recurse Center without Zulip,” Rachel says.


## An alum experience: Staying connected since 2015

One of the benefits of participating in RC is the opportunity to stay connected
with the community. “You'll be able to participate in the RC community online
forever,” the RC website [explains](https://www.recurse.com/why). “Almost 30% of
the RC community is regularly active [on
Zulip](https://www.recurse.com/blog/112-how-rc-uses-zulip),” an incredible
statistic for a 6-12 week program with many alumni who attended years ago. Many
alums drop in on Zulip to chat, pair-program, and host events.

John Hergenroeder first attended RC back in 2015. In the Recurse Center, John (a
software engineer by profession) found the inclusive and welcoming programming
community he was looking for.

Even with everyone sitting in the same room, Zulip served as a social hub for
John’s RC cohort. “People had different schedules, so we used Zulip to leave
questions, work artifacts, demos — anything you thought was interesting,” John
says. This let participants engage with the content asynchronously, and created
a lasting record for the community. “We even used a Zulip topic to coordinate
for lunch, to let people have their uninterrupted focus time,” John says.

Since 2015, John has stayed connected with the RC alumni community on Zulip. “We
have a channel for alumni check-ins, where each alum uses a dedicated topic to
post updates,” John explains. Some alums drop by weekly, while others might come
around once a year.  “You can leave a note, and it’s OK if your friend reads it
a few months later,” John says. “Compare that with Slack, where if someone
doesn’t see a message in some channel on that day, they’ll *never* see it.”

Without dedicating a lot of time, John is able to stay involved in the community
on Zulip, and share his expertise where relevant. “I scan [recent
topics](/help/recent-conversations) for places where I could help, and rely on
email notifications for private messages,” John explains. The experience of
keeping up on Zulip is in sharp contrast with Slack, which John uses at work:
“It’s so hard to keep up with the Slack firehose.”

> “Zulip allows people who are engaging with the community at different paces to connect.”
>
> — John Hergenroeder, Recurse Center alum


## Zulip’s open-source ethos

Zulip is developed as open-source software, with an active and growing
community; over 1100 people have contributed code to the project. As a long-time
Zulip user, John Hergenroeder appreciates the many thoughtfully designed
[features](https://zulip.com/features/) unique to Zulip.
“[Choosing](https://zulip.com/help/mention-a-user-or-group#silently-mention-a-user)
whether or not a mention notifies people is really handy,” John says. “[Global
times](https://zulip.com/help/format-your-message-using-markdown#global-times)
are great for organizing events, and
[spoilers](https://zulip.com/help/format-your-message-using-markdown#spoilers)
were perfect for chatting about the Advent of Code puzzles.”

And if Zulip is missing some feature? “We can file an issue, or even go and make
it happen,” says John. Over the years, John has filed [11
issues](https://github.com/zulip/zulip/issues?q=is%3Aissue+author%3Ajdherg+is%3Aclosed)
in the Zulip issue tracker that have been resolved, and dozens of Recursers have
contributed code to Zulip. It’s a radically different experience from trying to
give feedback to a corporation building a closed-source product. When he
encounters issues with Slack, John has his strategy: “When I come across a Slack
bug, I try to find someone I know who works there, because I have no idea if
anyone will pay attention if I go through support.”


## Going virtual: “For a while, Zulip *was* RC”

Prior to 2020, the Recurse Center offered an immersive in-person retreat
experience in the heart of New York City. This paradigm was shattered when the
Covid-19 pandemic hit New York in March 2020, and the Recurse Center made the
difficult decision to [move all operations
online](https://www.recurse.com/blog/152-RC-is-online-only-until-at-least-May).

Over time, the Recurse Center built out a custom virtual world (integrated with
Zulip) for online participants.  But in the early days of the pandemic, it was
Zulip that replaced the physical space where RC participants had spent time
together and helped each other out. “At the time, all we had was Zulip, email,
our website, Zoom, and a rarely used forum,” recalls RC’s Head of Retreat Rachel
Petacat.  “For a while, Zulip *was* RC.”


## An invaluable knowledge base

Edith, who works as a technical writer, participated in virtual RC in 2020. Two
years later, she still uses Zulip every day to stay connected.

Zulip’s combination of powerful search and topic-based threading makes prior
discussions both findable and useful.  “It’s easier to build context with Zulip
than any other tool,” Edith says. “With other messaging services, information
tends to get lost. In Zulip, I often look something up from a while ago —
anything from discussion of niche programming topics, to whether anyone has
commented on a book I’m thinking about reading.”

“You really feel that you’re joining a group of 2000 people who’ve been doing
this for 10 years,” says Rachel Petacat. “You can find someone who trod the same
path 6 years ago!”

---

Check out our guides on using Zulip for [education](/for/education/) and
[events](/for/events/), and learn how Zulip [helps communities
grow](/for/communities/)!
