## Rust: A popular programming language built by 1000s of contributors

[Rust](https://www.rust-lang.org/) is a popular modern programming language,
designed for performance, reliability and productivity, and used by hundreds of
companies around the world. Organized into teams and working groups, the Rust
project is led by [over 100 team members](https://www.rust-lang.org/governance)
who oversee the work of [more than 6000
contributors](https://thanks.rust-lang.org/).


## Rust moves to Zulip, one team at a time

Each Rust team decides independently how to organize itself and what
communication tools to use. Every major Rust team has chosen Zulip as their chat
platform, including the
[Compiler](https://www.rust-lang.org/governance/teams/compiler),
[Language](https://www.rust-lang.org/governance/teams/lang),
[Library](https://www.rust-lang.org/governance/teams/library) and
[Infrastructure](https://www.rust-lang.org/governance/teams/infra) teams. Some
Rust teams have migrated between collaboration tools two or even three times in
search of an effective solution. No team has moved away from Zulip after trying
it.

“Zulip lets us move faster, connect with each other better, and have interactive
technical discussions that are organized, recorded, and welcoming to other
people,” says [Rust Language
team](https://www.rust-lang.org/governance/teams/lang) co-lead [Josh
Triplett](https://joshtriplett.org/).


> “Zulip lets us have focused conversations at scale.”
>
> — [Rust compiler team](https://www.rust-lang.org/governance/teams/compiler) co-lead [Felix
> Klock](https://github.com/pnkfelix)


## The Language team moves from Discord to Zulip: “It’s better in all the ways I care about”

Let’s take a closer look at the story of the Rust Language team, which works on
designing and helping to implement new language features. The team started out
by using Gitter, but moved to Discord in 2018 in search of a more stable
solution.

Some community members advocated for trying out Zulip, but the team leadership
was reluctant to make another change. “Everyone in our community who was
familiar with Zulip seemed thrilled with it,” says [Language
team](https://www.rust-lang.org/governance/teams/lang) co-lead [Josh
Triplett](https://joshtriplett.org/), “but moving our team seemed like too much
of a pain.”

Eventually, Josh had to sign up for Zulip in order to get in touch with another
Rust team. “After a day of using Zulip, I became an advocate myself,” he says.
“Zulip is wildly simpler than most other tools I’ve worked with.” The team made
the move in November 2019 and has never looked back.

“I’m personally ecstatically happy with Zulip,” says Josh, who also uses the
Zulip instances for the [Bytecode Alliance](https://bytecodealliance.org/),
[Rust for Linux](https://github.com/Rust-for-Linux), and
[http-rs](https://github.com/http-rs/tide) Zulip communities. “It’s better in
all the ways I care about and a joy to use.”


> “Zulip is wildly simpler than most other tools I’ve worked with.”
>
> — [Rust Language team](https://www.rust-lang.org/governance/teams/lang) co-lead
> [Josh Triplett](https://joshtriplett.org/)


## Zulip enables organized, searchable conversations

Zulip’s threading model provides a two-layer organizational hierarchy. It offers
the advantages of a forum or a mailing list, reimagined in the context of a
modern chat tool.

In contrast with other chat tools, Zulip makes it pleasant to have **multiple
conversations** going on at once, with each conversation being easy to follow.
“Slack and Discord both suffer when trying to collaborate with others at scale —
you end up with conversations happening across each other,” says [David
Wood](https://davidtw.co/), member of the [Rust compiler
team](https://www.rust-lang.org/governance/teams/compiler). “In Zulip, I can
instantly see the context for each message.”

Afterwards, Zulip’s thread-based organization creates a **clear record** of
past discussions, documenting the decision-making process. “Zulip creates a
transparent record of what we do,” says Josh. It’s **easy to link** to Zulip
threads from other tools in order to provide background context. “We link to
Zulip threads all the time on GitHub, Twitter, email, Discourse, and from other
Zulip messages,” [Josh Triplett](https://joshtriplett.org/) says.


> “Slack and Discord feel opaque. Zulip feels like an open room.”
>
> — [Rust Language team](https://www.rust-lang.org/governance/teams/lang) co-lead
> [Josh Triplett](https://joshtriplett.org/)

Because information on Zulip is **well-organized**, one can easily find and
review earlier conversations, even if months have passed. The organization’s
**rich history** continues to provide value indefinitely.  “I can find and
re-read old conversations,” says [Rust Language
team](https://www.rust-lang.org/governance/teams/lang) co-lead [Niko
Matsakis](https://github.com/nikomatsakis). “If I send someone a link to a
discussion, they can jump right in; this would be impossible in other chat tools
I’ve used.”

Unlike other chat tools, a discussion on Zulip can even be revived after weeks
or months have passed if new information or ideas come to light, with no loss of
**surrounding context**.

Catching up works great, whether you were away for hours, days, or even weeks.
“When I come back after a break, I don’t feel overwhelmed: I can skim topics
looking for the ones that seem important, and scroll briefly through the rest,”
says [Rust Language team](https://www.rust-lang.org/governance/teams/lang)
co-lead [Niko Matsakis](https://github.com/nikomatsakis).


> “When I come back after a break, I don’t feel overwhelmed.”
>
> — [Rust Language team](https://www.rust-lang.org/governance/teams/lang)
> co-lead [Niko Matsakis](https://github.com/nikomatsakis)


## Zulip makes the Rust community more agile

In addition to being well-organized, Zulip interactions are
**conversational**, enabling **faster decision-making**. GitHub issues about
controversial Rust language decisions can devolve into incomprehensible comment
threads with [several](https://github.com/rust-lang/rust/issues/57640)
[hundred](https://github.com/rust-lang/rust/issues/34511)
[messages](https://github.com/rust-lang/rust/issues/28237).  “Some decisions
that were blocked for months on GitHub were resolved within 24 hours by starting
the right conversation on Zulip,” says [Rust Language
team](https://www.rust-lang.org/governance/teams/lang) co-lead [Josh
Triplett](https://joshtriplett.org/).


> “Some decisions that were blocked for months on GitHub were resolved within 24
> hours on Zulip.”
>
> — [Rust Language team](https://www.rust-lang.org/governance/teams/lang) co-lead
> [Josh Triplett](https://joshtriplett.org/)

With the features and feel of a **modern chat tool**, Zulip makes it easy to
have quick, light-weight, friendly conversations to get work done. “Zulip
strikes just the right balance between ephemeral and permanent,” [Josh
Triplett](https://joshtriplett.org/) says. The [mobile
applications](/apps/) make it easy to participate wherever you
are. “The Android app is extremely functional,” says Josh. “It’s easy to set
notification preferences, and the default level of notifications is just right.”

Adopting Zulip has been transformational for how the Rust community makes
progress. “Rust development would not be moving at the pace that it has been
without Zulip,” says [Rust Language
team](https://www.rust-lang.org/governance/teams/lang) co-lead [Josh
Triplett](https://joshtriplett.org/). “Without Zulip, the Rust community would
be more stuck, more slow-moving, less agile, and a little less human.”


> “Rust development would not be moving at the pace that it has been without
> Zulip.”
>
> — [Rust Language team](https://www.rust-lang.org/governance/teams/lang) co-lead
> [Josh Triplett](https://joshtriplett.org/)

---

Check out our guide on using Zulip for [open source](/for/open-source/), and
learn how Zulip [helps communities scale](/for/communities/)!
