[Semsee](https://semsee.com/) is a technology startup in the commercial
insurance space, building intelligent software that digitizes slow manual
processes. Originally based out of an office in New York, Semsee moved to a
remote-work model during the pandemic, and now has several satellite teams
across the US.

Semsee adopted Zulip early on in its journey. “We didn’t plan to be remote,”
says James van Lommel, [Director of
Engineering](https://www.linkedin.com/in/james-v-91a65219/) at Semsee. “But now
that we are remote, it’s good to have a communication tool that really backs
that up.”


> “Now that we are remote, it’s good to have a communication tool that really
> backs that up.”
>
> — James van Lommel, Director of Engineering at [Semsee](https://semsee.com/)


## Looking for something better than Slack

James van Lommel joined Semsee in 2018 to lead the engineering team. At the
time, the company was using Slack. James knew his choice of communication
platform would have broad implications: “Communication helps feed the type of
culture you have at a company,” James says.

James had used Slack extensively in his prior work experience. “Seeing how Slack
gets used, especially as a company grows larger, I knew I wanted something
better,” he recalls. “If you are not using Slack *all the time*, you can’t keep
up with what’s happening.” James wanted a chat tool that would create breathing
room for focused work, in-person conversations, and different work schedules.

> “Seeing how Slack gets used, especially as a company grows larger, I knew I
> wanted something better.”
>
> — James van Lommel, Director of Engineering at [Semsee](https://semsee.com/)

In addition, as a security expert, James was interested in a self-hosted
solution. “There is so much sensitive data that goes into a chat tool,” he says.
“When we self-host, the messages don’t live on anyone else’s cloud.”

When James discovered Zulip, the topic-based threading model piqued his
interest. “I didn’t want Mattermost or another self-hosted Slack clone,” he
says. James quickly set up a Zulip server — he found that the instructions for
self-hosting were easy to follow, and worked without a hitch. After trying Zulip
for a few days with some coworkers, James was convinced that Zulip was the right
choice for Semsee. “We need our employees to be able to come to the right place,
and have a conversation about one thing,” he says. “Zulip solves that pain
point.”


## An efficient way to organize communication

These days, Zulip is at the core of company communication at Semsee. Email is
rarely used for internal communications. For jumping on a call, Zulip’s native
call integration is an easy starting point. System monitoring and software
development processes are integrated with Zulip via the API. For example, a
custom integration sends logging data from Semsee’s product into Zulip, with a
channel and topic configured based on the deployed environment.

New employees adapt easily to Zulip’s organized conversations. By reading
ongoing discussions, they quickly get an intuition for when to start a new
topic, and what kinds of topic names work well. “Once they get used to Zulip,
they are just rolling with it, and I don’t hear any complaints,” says James.
With conversations organized by topic, “people don’t have to scroll through and
cherry-pick out the messages they need to read,” James says.

Semsee invites customers to join the company Zulip chat as guests. “Our
customers just see one channel with one or two topics, so it’s very easy for
them,” James explains. On the flip side, when Semsee employees are invited to
join customers’ Slack chats, they miss Zulip. “I don’t like going back to Slack
now. It’s just not as efficient a way to organize communication,” says James. “A
few users from an extensive Slack background have told me: ‘Zulip is just
better.’"


> “I don’t like going back to Slack now. It’s just not as efficient a way to
> organize communication.”
>
> — James van Lommel, Director of Engineering at [Semsee](https://semsee.com/)

---

Check out our guide on [using Zulip for business](/for/business/). You can also
learn how Zulip is being used at the [Atolio](/case-studies/atolio/) startup,
the [iDrift AS](/case-studies/idrift/) company, the [End Point
Dev](/case-studies/end-point/) software consultancy, and the [GUT
contact](/case-studies/gut-contact/) support agency.
