## Making the best of a tough year

[University of California San Diego
(UCSD)](https://ucsd.edu/about/index.html) is recognized as one of the
top universities worldwide. The UCSD math department offers
prestigious graduate and undergraduate programs, with course topics
ranging from foundational material to cutting-edge research.

In response to the COVID-19 pandemic, UCSD instruction moved online early
in 2020. As instructors scrambled to figure out online education,
Kiran Kedlaya, Professor of Mathematics at UCSD, gave himself a bigger
challenge: “Seeing the unique opportunity, I decided to open my
classes up to the world,” Kiran says.


## Communication is key

Kiran knew that an effective chat platform would be key for
communicating with students. He had prior experience with Slack,
Discord and Zulip.  “I chose Zulip for several reasons, especially the
threaded model (which I find sorely lacking in other chat apps), and
the TeX integration.”

From Spring 2020 through Spring 2021, the [Zulip
Standard](/for/education/#feature-pricing) plan was free for all educators,
as we did our part to help make the transition to online education a
little easier. Having set up Zulip Cloud for his three graduate-level
courses, Kiran felt confident in the communication platform, and was
ready to make his classes open to all.


## Teaching students across six continents

Students worldwide jumped on the opportunity to take a course with
Kiran. “Of the 350 students in my classes, no more than 15% were local
to UCSD,” Kiran says. A Zulip poll showed participants from as far as
the Middle East, Southeast Asia and Oceania.

“Zulip became a central hub for asynchronous Q&A and posting Zoom
links for lectures, whiteboard PDFs, and announcements,” Kiran says.

With students logging in at all hours of the day, Zulip’s topic model
was key to making sure everyone could find the materials they needed
and participate in the discussions. “Zulip’s topics, and the ability
to change the topic of someone else's message, has made it much easier
for me to keep things coherent,” says Kiran.


## Zulip has what you need

Beyond topics, Zulip’s rich functionality smoothed out made many
aspects of remote communication. Here is what Kiran has to say about
the benefits of just a few of Zulip’s features:


- **Discussing math**: “The
  [**TeX**](/help/format-your-message-using-markdown#latex)
  made it super easy to discuss material from the course using
  proper mathematical notation, and was one of the reasons I chose
  Zulip in the first place.”
- **Quick pulse-checks**: “[**Emoji
  reactions**](/help/emoji-reactions) were a nice way
  to collect RSVPs for office hours or acknowledge typo corrections
  for my lecture notes.”
- **Hiding answers**:
  “[**Spoilers**](/help/format-your-message-using-markdown#spoilers)
  are a great way to answer questions about homework without depriving
  students of a chance to keep thinking about the problem on their
  own.”
- **Scheduling**: “With [**global
  times**](/help/format-your-message-using-markdown#global-times),
  I could announce office hours or outside lectures without having to
  worry about confusion for students in different time zones.”


## Education beyond coursework

What happens once classes return to campus? “I intend to continue to
use Zulip as the main communication platform for my in-person classes
this coming year,” Kiran says.

Zulip is also helping Kiran organize events for students, and create
communities for education and research. “I used Zulip as the
communication hub for a 200-person undergraduate conference that was
held virtually for the first time,” Kiran says. “I’ve also started a
Zulip for the number theory research group at UCSD, where graduate
students and postdocs can connect to discuss reading courses, social
events, conferences of interest, etc.”

---

Learn more about [Zulip for Education](/for/education/), and how
Zulip is being used at the [Technical University of Munich](/case-studies/tum/).
You can also check out our guides on using Zulip for [conferences](/for/events/)
and [research](/for/research/)!
