The primary communication forum for the Zulip community is the Zulip
server hosted at [chat.zulip.org](https://chat.zulip.org/):

- **Users** and **administrators** of Zulip organizations stop by to
  ask questions, offer feedback, and participate in product design
  discussions.
- **Contributors to the project**, including the **core Zulip
  development team**, discuss ongoing and future projects, brainstorm
  ideas, and generally help each other out.

Everyone is welcome to [sign up](https://chat.zulip.org/) and
participate — we love hearing from our users! Public channels in the
community receive thousands of messages a week. We recommend signing
up using the special invite links for
[users](https://chat.zulip.org/join/t5crtoe62bpcxyisiyglmtvb/),
[self-hosters](https://chat.zulip.org/join/wnhv3jzm6afa4raenedanfno/)
and
[contributors](https://chat.zulip.org/join/npzwak7vpmaknrhxthna3c7p/)
to get a curated list of initial channel subscriptions.

To get help in real time, you will have the best luck finding core
developers during daylight hours in North America (roughly between
15:00 UTC and 1:00 UTC), but the sun never sets on the Zulip
community. Most questions get a reply within minutes to a few hours.

You can also [read conversations](https://chat.zulip.org/) in the community
without creating an account. If you are evaluating using Zulip for your
organization, check out these [tips](/try-zulip/) for exploring the product in
action in the development community.

<br/>
# Community norms

Zulip is a friendly and welcoming community, and we love meeting new
people, hearing about what brought them to Zulip, and getting their
feedback.

## Getting started

- Send test messages to [#test
  here](https://chat.zulip.org/#narrow/channel/7-test-here) or as a PM
  to yourself to avoid disturbing others.
- Start a [new topic](/help/introduction-to-topics) unless you’re replying
  to an existing conversation. If you see a new user talking about
  something unrelated on an existing topic, [move the messages to an
  appropriate new topic](/help/move-content-to-another-topic).
- If you’re not sure where to start, introduce yourself and your
  interests in [#new
  members](https://chat.zulip.org/#narrow/channel/95-new-members),
  using your name as the topic to create a dedicated space.
- Follow the community [code of
  conduct](https://zulip.readthedocs.io/en/latest/code-of-conduct.html).

## Communication style

- Converse informally; there’s no need to use titles like “Sir” or “Madam”.
- Use [gender-neutral
  language](https://en.wikipedia.org/wiki/Gender-neutral_language). For
  example, avoid using a pronoun like “her” or “his” in sentences like
  “Every developer should clean [their] keyboard at least once a
  week.”

## Getting help
- When asking for help, provide the details needed for others to help
  you. For example, include the **full traceback** in a [code
  block](/help/code-blocks) (not a screenshot), a link to the code or
  a draft PR you’re having trouble debugging, etc.
- Ask questions on channels rather than DMing core contributors. You’ll
  get answers faster since other people can help, and it makes it
  possible for others to benefit from the discussion.
- Don’t ask the same question in multiple places. Moderators read
  every public channel, and make sure every question gets a reply.
- Use @-mentions sparingly. Unlike IRC or Slack, Zulip’s topics make
  it easy to see what you’re replying to, so you don’t need to mention
  your conversation partner to make sure they will see or understand
  your reply. Core contributors will often @-mention someone who asked
  a question hours earlier to make sure they see the reply, but there
  is generally no need to @-mention a core contributor unless you need
  their timely attention.

<br/>
# Where do I send my message?

This section describes popular public channels on chat.zulip.org. Kick
off the discussion by starting a [new topic](/help/introduction-to-topics)
in the appropriate channel! Don’t stress too much about picking the
right place if you’re not sure; anyone in the community can edit a
topic name, and [moderators](/help/roles-and-permissions) can [move a
topic to a different channel](/help/move-content-to-another-channel).

## Channels for everyone

- [#feedback](https://chat.zulip.org/#narrow/channel/137-feedback) is
  for posting feedback on Zulip, including feature requests, suggestions for
  improvements to the UI or existing features, or anything else! We also
  appreciate hearing about how Zulip is used in your organization.
- [#integrations](https://chat.zulip.org/#narrow/channel/127-integrations)
  is for bug reports or questions about integrations.
- [#issues](https://chat.zulip.org/#narrow/channel/9-issues) is for reporting
  bugs (or possible bugs) in the Zulip web app or server implementation.
- [#mobile](https://chat.zulip.org/#narrow/channel/48-mobile),
  [#desktop](https://chat.zulip.org/#narrow/channel/16-desktop), and
  [#zulip-terminal](https://chat.zulip.org/#narrow/channel/206-zulip-terminal)
  are the best places to post bug reports or questions about Zulip's apps. Note
  that [#desktop](https://chat.zulip.org/#narrow/channel/16-desktop) should only
  be used for issues specific to the desktop app, which shares most of its UI
  and implementation with the web app.
- Everyone is welcome to introduce themselves in [#new
  members](https://chat.zulip.org/#narrow/channel/95-new-members). Posting
  here with your name as the topic is a great option if you’re
  uncertain where to start a conversation.
- [#test here](https://chat.zulip.org/#narrow/channel/7-test-here) is
  for sending test messages without inconveniencing other users :). We
  recommend muting this channel when not using it.

## Channels for Zulip users and administrators

- [#user questions](https://chat.zulip.org/#narrow/channel/138-user-questions) is
  for questions about how to configure your Zulip organization, and accomplish
  your goals with Zulip. You can also refer to the [Zulip help center](/help)
  for detailed documentation.
- [#production help](https://chat.zulip.org/#narrow/channel/31-production-help) is
  for all questions related to [self-hosting
  Zulip](/self-hosting/).
- [#zulip
  cloud](https://chat.zulip.org/#narrow/channel/387-zulip-cloud) is for
  all conversations about the [Zulip Cloud](https://zulip.com/plans/)
  service.

## Channels for code contributors

- [#development
  help](https://chat.zulip.org/#narrow/channel/49-development-help) is
  for asking for help with any Zulip server/web app development work
  (use the app channels #mobile-dev-help, #desktop, or #zulip-terminal for help
  working on one of the apps).
- [#provision
  help](https://chat.zulip.org/#narrow/channel/21-provision-help) is
  for help specifically on setting up the server/web app development
  environment. [#tools](https://chat.zulip.org/#narrow/channel/18-tools)
  is other conversations about the server/web app developer tooling.
- [#git help](https://chat.zulip.org/#narrow/channel/44-git-help) is
  for help with using Git.
- [#code review](https://chat.zulip.org/#narrow/channel/91-code-review)
  is for getting feedback on your work. We encourage all developers to
  comment on work posted here, even if you’re new to the Zulip
  project; reviewing other PRs is a great way to develop experience,
  and even just manually testing a proposed new feature and posting
  feedback is super helpful. Note that GitHub is our primary system
  for managing code reviews.
- [#backend](https://chat.zulip.org/#narrow/channel/3-backend),
  [#frontend](https://chat.zulip.org/#narrow/channel/6-frontend),
  [#documentation](https://chat.zulip.org/#narrow/channel/19-documentation),
  and app-specific channels
  ([#mobile-team](https://chat.zulip.org/#narrow/channel/243-mobile-team), etc.)
  are the right place for general conversations about work in those
  areas (including design discussions, questions, updates on a
  project, or anything else).
- [#automated
  testing](https://chat.zulip.org/#narrow/channel/43-automated-testing)
  is primarily used for automated notifications about [CI
  failures](https://zulip.readthedocs.io/en/latest/testing/continuous-integration.html),
  but is also a good place to discuss projects to improve Zulip’s
  automated testing infrastructure.
- [#api design](https://chat.zulip.org/#narrow/channel/378-api-design)
  is a low-traffic channel for discussing and coordinating changes to
  the [Zulip API](https://zulip.com/api/rest), with all stakeholders
  present.

## Channels for translators
- [#translation](https://chat.zulip.org/#narrow/channel/58-translation)
  is for discussing [Zulip’s
  translations](https://zulip.readthedocs.io/en/latest/translating/translating.html).
- Some languages have channels named like
  [#translation/fr](https://chat.zulip.org/#narrow/channel/371-translation.2Ffr)
  and
  [#translation/zh_tw](https://chat.zulip.org/#narrow/channel/377-translation.2Fzh_tw)
  to coordinate translation work for that language.

## Channels for anyone spending time in the community
- [#announce](https://chat.zulip.org/#narrow/channel/1-announce) is our
  low-traffic channel for project announcements (releases, etc.).
- [#checkins](https://chat.zulip.org/#narrow/channel/65-checkins) is
  for progress updates on what you’re working on and its status;
  usually folks post with their name as the topic. Everyone is welcome
  to participate!
- [#design](https://chat.zulip.org/#narrow/channel/101-design) is where
  we discuss UI and feature design and collect feedback on potential
  design changes. We love feedback, so don’t hesitate to speak up!
  Note that
  [#feedback](https://chat.zulip.org/#narrow/channel/137-feedback) is
  usually the best place for end users to start a topic about a
  proposed design change;
  [#design](https://chat.zulip.org/#narrow/channel/101-design) is
  primarily intended for discussing changes the community is actively
  working on.
- [#discussions](https://chat.zulip.org/#narrow/channel/277-discussions)
  is where we do fun community conversations like “Ask Me Anything”
  Q&A sessions with project members.
- [#documentation](https://chat.zulip.org/#narrow/channel/19-documentation)
  is where we discuss improving Zulip’s user, sysadmin, API, and
  developer documentation.
- [#general](https://chat.zulip.org/#narrow/channel/2-general) is for
  all topics of general interest.
- [#learning](https://chat.zulip.org/#narrow/channel/92-learning) is
  for posting great learning resources one comes across.
- [#off topic](https://chat.zulip.org/#narrow/channel/97-off-topic) is
  is for occasional conversations not related to Zulip, usually things
  of general interest to open-source communities.

You can always find the description for the channel you’re reading at
the top of the Zulip app.

<br/>
# Anything else to keep in mind?

## Don’t try to read *everything*

Keeping up with **everything** happening in the Zulip project is both
difficult and rarely a useful goal. To make the best use of your time,
we highly recommend that you unsubscribe from channels that you aren’t
interested in, mute channels that are only of occasional interest, and
make use of [Zulip’s skimming features](/help/reading-strategies),
like Recent conversations, to spend your time on topics that interest
you.

## Searching for past conversations

To look for previous threads about something, we recommend using the
following [search filters](/help/search-for-messages#search-filters):
`streams:public <your keyword(s)>`.

This will search the full history of all public channels for `<your
keyword(s)>`, including messages sent before you joined and messages
on public channels you’re not subscribed to.

## Linking to GitHub issues and pull requests

We've set up [custom linkifiers](/help/add-a-custom-linkifier)
so that it's easy to link to issues and pull requests in Zulip
project repositories when composing a message or starting a
[new topic](/help/introduction-to-topics). Here are examples for linking
to issue 1234 in the main Zulip project repositories:

- [Server and web app][server-web-repository]: `#1234`
- [Flutter mobile client][flutter-repository]: `#F1234`
- [Terminal client][terminal-repository]: `#T1234`
- [Desktop client][desktop-repository]: `#D1234`
- [React Native mobile client][mobile-repository]: `#M1234`

## New features are tested here

We [continuously test out new features or ideas][release-lifecycle] on
chat.zulip.org before rolling them out to Zulip Cloud or including
them in a Zulip Server release (or deciding not to!). Please report in
[#issues](https://chat.zulip.org/#narrow/channel/9-issues) anything you
notice that seems broken! It’s likely you’ve found a bug in an upcoming
feature.

[release-lifecycle]: https://zulip.readthedocs.io/en/latest/overview/release-lifecycle.html
[server-web-repository]: https://github.com/zulip/zulip
[flutter-repository]: https://github.com/zulip/zulip-flutter
[mobile-repository]: https://github.com/zulip/zulip-mobile
[terminal-repository]: https://github.com/zulip/zulip-terminal
[desktop-repository]: https://github.com/zulip/zulip-desktop
