> “The core of the Recurse Center is the community, and the core of our online
> community is Zulip… Switching to Zulip has turned out to be one of the best
> decisions we’ve made, and it’s impossible to imagine RC today without it. No
> other tool has a user experience that scales to a community of our size.”
>
> — Nick Bergson-Shilcock, founder and CEO, [Recurse
> Center](https://www.recurse.com/); check out [the story of how the Recurse
> Center uses Zulip](/case-studies/recurse-center/)

## Zulip: Designed with communities in mind

Zulip is designed to help thoughtful people work on difficult problems
together, whether they work from a shared office or from all over the
world. Zulip offers an ideal platform for communities of all types,
including open-source projects, research collaborations, volunteer
organizations, and other groups of people who share a common pursuit.

The Zulip core developers have decades of combined experience leading
and growing open source communities, and we use Zulip to fashion the
day-to-day experience of being a part of our project. No other chat
product comes close to Zulip in facilitating contributor engagement and
inclusion, and making efficient use of everyone’s time.

&nbsp;

> “When we made the switch to [@zulip](https://twitter.com/zulip) a few months ago for chat, never in my wildest dreams did I imagine it was going to become the beating heart of the community, and so quickly. It&#39;s a game changer. 🧑‍💻🗨️👩‍💻”

> — Dan Allen (@mojavelinux), [June 29, 2021](https://twitter.com/mojavelinux/status/1409702273400201217)
&nbsp;

## Challenges with other communication tools

Problems with the Slack/Discord/IRC model, discussed
in detail [here](/why-zulip/), are even more important for open communities:


- Members of open communities may be scattered all over the world and
  in every time zone. Traditional communication tools like email
  lists, forums, and issue trackers work well in this context, because
  you can communicate effectively asynchronously. A Slack community is
  a bad experience if you’re rarely online at the same time as most
  other members, making it harder to be inclusive of all participants.
- Many members of open communities have other fulltime obligations and
  can only spend a few hours a week on the community. Because Slack is
  very hard to skim, these part-time community members cannot
  efficiently use their time participating in an active Slack. So
  either they don’t participate in the Slack, or they do, and their
  other contributions to the community’s efforts suffer.


>  “Zulip helped the FHIR community grow from a tiny group of dreamers to 500 active users sending 6000 messages per month, all driving the creation of better healthcare standards. Zulip’s topic-based threading helps us manage simultaneous discussions with clarity, ensuring the right people can pay attention to the right messages. This makes our large-group discussion far more manageable than what we’ve experienced with Skype and Slack.”

> — Grahame Grieve, founder, FHIR health care standards body


- Many of us are busy people, who really wish we had more time to do
  focus work. Because active participation in Slack fundamentally
  requires constant interruptions, leaders of communities that use
  Slack end up making unpleasant choices between participating in the
  Slack community (limiting their ability to do focus work) or
  ignoring the Slack community (leaving it effectively without their
  input and potentially unmoderated).
- Writing to a busy Slack channel often means interrupting another
  existing conversation. This makes it harder for newer and shyer
  members to jump into the community. Often this disproportionately
  affects groups that are already underrepresented.
- The lack of organization in Slack message history (and its 90 day
  message history limit!) mean that users asking for help cannot
  effectively do self-service support. This results in the community
  answering a lot of duplicate questions.

The overall effect is that Slack is a poor communication tool for
communities that want to have an inclusive, global, community and that
many busy individuals can happily participate in.

&nbsp;

> "We just moved the Lichess team (~100 persons) to <a href="https://twitter.com/zulip">@zulip</a>, and I&#39;m loving it. The topics in particular make it vastly superior to slack &amp; discord, when it comes to dealing with many conversations. Zulip is also open-source!"

> — <a href="https://twitter.com/ornicar">Thibault D (@ornicar)</a>

&nbsp;

## Solution: Zulip’s topic-based threading

Zulip’s topic-based threading model solves the problems described above:

- Community members in any time zone can send messages and expect to
  get a reply and have an effective (potentially asynchronous)
  conversation with the rest of the community.
- Zulip’s topic-based threading helps include part-time community
  members in two major ways. First, they can easily browse what
  conversations happened while they were away from the community, and
  prioritize which conversations to read now, skip, or read later
  (e.g., on the weekend). Second, Zulip makes it easy for them to have
  public conversations with participation from other community members
  (potentially split over hours, days, or weeks as needed), allowing
  them to fully participate in the work of the community.
- Community leaders can effectively participate in a Zulip community
  without being continuously online. Using Zulip’s [keyboard
  shortcuts](/help/keyboard-shortcuts), it’s
  extremely efficient to inspect every potentially relevant thread and
  reply wherever one’s feedback is useful, and replying hours after a
  question was asked is still a good experience for community
  members. As a result, leaders can do multi-hour sessions of focus
  work while still being available to their community.
- Topics make it easier to provide a safe, welcoming, online
  community. Asking a question never has to feel like an interruption
  of an ongoing conversation or like one's sticking one's neck out.


>  “Wikimedia uses Zulip for its participation in open source
>  mentoring programs. Zulip’s threaded discussions help busy
>  organization administrators and mentors stay in close communication
>  with students during all phases of the programs.”

> — Srishti Sethi, Developer Advocate, Wikimedia Foundation

&nbsp;

## Try Zulip today!

You can see Zulip in action in our own [Zulip development
community](/development-community/), or in other open
communities that have [opted in](/help/communities-directory) to be listed in our
[directory](/communities/). We often get feedback from contributors around the
world that they love how responsive Zulip’s project leaders are in public Zulip
conversations. We are able to achieve this despite the project leaders
collectively spending only a few hours a day managing the community and spending
most of their time integrating improvements into Zulip.

Many communities that migrated from
[Slack](/help/import-from-slack),
[Mattermost](/help/import-from-mattermost),
[Rocket.Chat](/help/import-from-rocketchat), or
Gitter to Zulip tell us that Zulip helped them manage
and grow an inclusive, healthy community. We hope Zulip
can help your community succeed too!


>  “I highly recommend Zulip to other communities. We’re coming from
>  Freenode as our only real-time communication so the difference is
>  night and day. Slack is a no-go for many due to not being FLOSS,
>  and I’m concerned about vendor lock-in if they were to stop being
>  so generous. Slack’s threading model is much worse than Zulip’s
>  IMO. The channels/topics flow is an incredibly intuitive way to keep
>  track of everything that is going on.”

> — RJ Ryan, Mixxx Developer
