# Privacy Policy

**Effective date: January 1, 2022.** View [change history][changes-privacy].

[changes-privacy]: https://github.com/zulip/zulip/commits/main/templates/corporate/policies/privacy.md

At Kandra Labs, Inc. (“Zulip”), we take your privacy seriously. Please read this
Privacy Policy to learn how we treat your personal data. **By using or accessing
our Services in any manner, you acknowledge that you accept the practices and
policies outlined below, and you hereby consent that we will collect, use and
share your information as described in this Privacy Policy.**

Remember that your use of Zulip's Services is at all times subject to our [Terms
of Service](/policies/terms), which incorporates this Privacy Policy.
Any terms we use in this Policy without defining them have the definitions given
to them in the Terms of Service.

You may print a copy of this Privacy Policy by clicking
[here](javascript:window.print()).

## Summary of our Privacy Policy

We know, privacy policies are no fun. Here at Zulip, our goal is to help make
team collaboration and communication easier for you. In the course of providing
our Services, we will collect certain information about you, which is necessary
for us to best achieve that goal. Our intent is to only collect the information
we need to provide our Services to you. We will only share your data with third
parties to help make our Services a reality. We will not sell your personal
information to third parties.

## Privacy Policy Table of Contents

* [What this Privacy Policy Covers](#what-this-privacy-policy-covers)
* [Personal Data](#personal-data)
    - [Categories of Personal Data We Collect](#categories-of-personal-data-we-collect)
    - [Categories of Sources of Personal Data](#categories-of-sources-of-personal-data)
    - [Our Commercial or Business Purposes for Collecting Personal Data](#our-commercial-or-business-purposes-for-collecting-personal-data)
* [How We Share Your Personal Data](#how-we-share-your-personal-data)
* [Tracking Tools and Opt-Out](#tracking-tools-and-opt-out)
* [Data Security and Retention](#data-security-and-retention)
* [Personal Data of Children](#personal-data-of-children)
* [California Resident Rights](#california-resident-rights-under-ccpa)
* [Other State Law Privacy Rights](#other-state-law-privacy-rights)
* [European Union Data Subject Rights](#european-union-data-subject-rights)
* [Changes to this Privacy Policy](#changes-to-this-privacy-policy)
* [Contact Information](#contact-information)

## What this Privacy Policy Covers

This Privacy Policy covers how we treat Personal Data that we gather when you
access or use our Services. “Personal Data” means any information that
identifies or relates to a particular individual and also includes information
referred to as “personally identifiable information” or “personal information”
under applicable data privacy laws, rules or regulations. This Privacy Policy
does not cover the practices of companies we don’t own or control, or people we
don’t manage.

## Personal Data

### Categories of Personal Data We Collect

This chart details the categories of Personal Data that we may collect and may
have collected from or about you over the past 12 months. Please note that many
of these categories of Personal Data will only be collected if you choose to
provide them to us:

| **Category of Personal Data**                                                 | **Examples of Personal Data We Collect**                                                                                                                                                                                                                                                                                                                                                                                   | **Categories of Third Parties With Whom We Share this Personal Data:**                                                                                                                               |
| ----------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| **Profile or Contact Data**                                                   | - Display name<br>- Email address<br>- Phone number<br>- Profile photo                                                                                                                                                                                                                                                                                                                                                     | - Service Providers<br>- Parties You Authorize, Access or Authenticate                                                                                                                               |
| **Payment Data**                                                              | - Payment card type<br>- Payment card number <br>- Billing name, address, phone number, and email                                                                                                                                                                                                                                                                                                                          | - This information is directly processed by our Service Providers (specifically our payment processing partner, currently Stripe, Inc.). We do not process or store your entire payment card number. |
| **Device/IP Data**                                                            | - IP address<br>- Host name<br>- Type of device/operating system/browser used to access the Services                                                                                                                                                                                                                                                                                                                       | - Service Providers<br>- Analytics Partners                                                                                                                                                          |
| **Web Analytics**                                                             | - Web page interactions<br>- Referring webpage/source through which you accessed the Services<br>- Statistics associated with the interaction between device or browser and the Services                                                                                                                                                                                                                                   | - Service Providers<br>- Analytics Partners                                                                                                                                                          |
| **Social Network Data**                                                       | - Email address<br>- User name                                                                                                                                                                                                                                                                                                                                                                                             | - Service Providers                                                                                                                                                                                  |
| **Geolocation Data**                                                          | - IP-address-based coarse location information                                                                                                                                                                                                                                                                                                                                                                             | - Service Providers<br>- Analytics Partners                                                                                                                                                          |
| **Other Identifying Information that You Voluntarily Choose to Provide**      | - Identifying information in emails, letters, Zulip messages or support communications you send us<br>- Zulip messages, uploaded files, channel descriptions, and other content you provide using our Services (e.g., in a Zulip client) <br>- Values of custom profile fields configured by your Zulip Organization, where you might choose to enter your phone number, job title, birthday, or other biographical details. | - Service Providers<br>- Parties You Authorize, Access or Authenticate                                                                                                                               |
| **Other Identifying Information that Another User Chooses to Provide to You** | - Messages or other content that other Zulip users may send you. <br>- Messages or content that any Zulip Organization Administrator of a Zulip community that you may join may provide about you.                                                                                                                                                                                                                         | - Service Providers<br>- Parties You Authorize, Access or Authenticate                                                                                                                               |



### Categories of Sources of Personal Data

We collect Personal Data about you from the following categories of sources:

- **You**
    - When you provide such information directly to us.
        - When you create an account or use our interactive tools and Services.
        - When you voluntarily provide information in free-form text
          boxes through the Services or through responses to surveys
          or questionnaires.
        - When you send us an email or otherwise contact us.
    - When you use the Services and such information is collected automatically.
        - Through Cookies (defined in the “Tracking Tools and Opt-Out”
          section below).
        - If you download a Zulip application such as our mobile and
          desktop apps, or interact with the Services over a network
          using a web browser or other client, we may receive and
          collect information about your device and your network
          connection (e.g., your IP address).
        - If you download a Zulip application such as our mobile and
          desktop apps, or interact with the Services over a network
          using a web browser or other client, we may receive and
          collect information transmitted from your computing device
          for the purpose of providing you the relevant Services, such
          as information regarding when you are logged on and
          available to receive updates or alert notices.
- **Third Parties**
    - Vendors
        - We may use analytics providers to analyze how you interact
          and engage with the Services, or third parties may help us
          provide you with customer support.
        - When you submit Payment Data to our payment processing
          partner Stripe, Inc. (“Stripe”).
    - Social Networks
        - If you provide your social network account credentials to us
          or otherwise sign in to the Services through a third-party
          site or service, some content and/or information in those
          accounts may be transmitted into your account with us.
    - Zulip integrations
        - You or other Zulip users may connect an integration that
          sends data from a third-party service into Zulip.
    - Other Zulip users
        - Other Zulip users may send messages or otherwise upload content containing Personal Data.
        - Other Zulip users, such as Zulip Organization
          Administrators, may import data into the Services via
          Zulip’s API or data import tools.
        - Please note that if you upload Personal Data about any other
          Zulip User, the Rules of Use require that you acknowledge
          and represent that you have authority to provide such
          information on behalf of such user.

### Our Commercial or Business Purposes for Collecting Personal Data

- **Providing, Customizing and Improving the Services**
    - Creating and managing your account or other user profiles.
    - Processing orders or other transactions; billing.
    - Providing you with the products, services, or information you request.
    - Meeting or fulfilling the reason you provided the information to us.
    - Providing support and assistance for the Services.
    - Improving the Services, including testing, research, internal analytics,
      and product development.
    - Personalizing the Services, website content, and communications based on
      your preferences.
    - Doing fraud protection, security, abuse prevention, and debugging.
    - Carrying out other business purposes stated when collecting your Personal
      Data or as otherwise set forth in applicable data privacy laws, such as
      the California Consumer Privacy Act (the “CCPA”).

- **Marketing the Services**
    - Marketing and selling the Services.

- **Corresponding with You**
    - Responding to correspondence that we receive from you, contacting you when
      necessary or requested, and sending you information about Zulip or the
      Services.
    - Sending emails, mobile notifications, and other communications according
      to your preferences or that display content that we think will interest
      you.

- **Meeting Legal Requirements and Enforcing Legal Terms**
    - Fulfilling our legal obligations under applicable law, regulation, court
      order or other legal process, such as preventing, detecting and
      investigating security incidents and potentially illegal or prohibited
      activities.
    - Protecting the rights, property or safety of you, Zulip or another party.
    - Enforcing any agreements with you.
    - Responding to claims that any posting or other content violates
      third-party rights.
    - Resolving disputes.

We will not collect additional categories of Personal Data or use the Personal
Data we collected for materially different, unrelated or incompatible purposes
without providing you notice.

### How We Share Your Personal Data

We disclose your Personal Data to the categories of service providers and other
parties listed in this section. We do not sell Personal Data.

- **Service Providers.** These parties help us provide the Services or perform
  business functions on our behalf. They include:
    - Hosting, technology and communications providers.
    - Analytics providers.
    - Security and fraud prevention consultants.
    - Support and customer service vendors.
    - Payment processors.
        - Our payment processing partner Stripe, Inc. (“Stripe”) collects your
          voluntarily-provided payment card information necessary to process
          your payment.
        - Please see Stripe’s terms of service and privacy policy for
          information on its use and storage of your Personal Data.

- **Parties You Authorize, Access or Authenticate.** These parties could
  include:
    - Other Zulip users. When you send a message to another Zulip user or
      otherwise provide data to Zulip, it may be shared with some or all other
      users in that Zulip Organization. Please note that some Zulip channels [may
      be accessible to the general
      public](/help/channel-permissions), in addition to the
      channel’s current subscribers. For more information, please review our
      [Terms of Service](/policies/terms).
    - Zulip Organization Administrators may export all Zulip data for a Zulip
      Organization for archival/backup purposes, to import the data into a
      self-hosted Zulip server, or for any other purpose consistent with the
      Terms of Service.  Please note that password hashes are not included in
      data exports.
    - Other parties that you may authorize, such as third-party Zulip clients or
      third-party services to which you provide Zulip credentials, such as your
      Zulip API key.

- **Analytics Partners.** These parties provide analytics on web traffic or
  usage of the Services. They include:
    - Companies that track how users found or were referred to the Services.
    - Companies that track how users interact with the Services.

- **Business Partners.** These parties may include:
    - Businesses that provide third-party services that you or your Zulip
      Organization have integrated with our Services.

### Legal Obligations

We may share any Personal Data that we collect with third parties in conjunction
with any of the activities set forth under “Meeting Legal Requirements and
Enforcing Legal Terms” in the “Our Commercial or Business Purposes for
Collecting Personal Data” section above.

### Business Transfers

All of your Personal Data that we collect may be transferred to a third party if
we undergo a merger, acquisition, bankruptcy or other transaction in which that
third party assumes control of our business (in whole or in part). Should one of
these events occur, we will make reasonable efforts to notify you before your
information becomes subject to different privacy and security policies and
practices.

### Data that is Not Personal Data

We may create aggregated, de-identified or anonymized data from the Personal
Data we collect, including by removing information that makes the data
personally identifiable to a particular user. We may use such aggregated,
de-identified or anonymized data and share it with third parties for our lawful
business purposes, including to analyze, build and improve the Services and
promote our business, provided that we will not share such data in a manner that
could identify you.

## Tracking Tools and Opt-Out

The Services use cookies and similar technologies to enable our servers to
recognize your web browser, tell us how and when you visit and use our Services,
analyze trends, learn about our user base and operate and improve our Services.
Cookies are small pieces of data – usually text files – placed on your computer,
tablet, phone or similar device when you use that device to access our Services.
We may also supplement the information we collect from you with information
received from third parties, including third parties that have placed their own
cookies on your device(s). Please note that because of our use of cookies, the
Services do not support the [“Do Not Track” setting](https://allaboutdnt.com/)
available in some browsers. We use the following types of cookies:

- **Essential Cookies.** Essential cookies are required for providing you with
  features or services that you have requested. For example, certain cookies
  enable you to log into secure areas of our Services. Disabling these cookies
  may make certain features and services unavailable.

- **Performance/Analytical Cookies.** Performance/Analytical cookies allow us to
  understand how visitors use our Services. They do this by collecting
  information about the number of visitors to the Services, what pages visitors
  view on our Services and how long visitors are viewing pages on the Services.
  Performance/Analytical cookies also help us measure the performance of our
  advertising campaigns in order to help us improve our campaigns and the
  Services’ content for those who engage with our advertising. For example,
  Google LLC (“Google”) uses cookies in connection with its Google Analytics
  services. Google’s ability to use and share information collected by Google
  Analytics about your visits to the Services is subject to the Google Analytics
  Terms of Service and the Google Privacy Policy. You have the option to opt-out
  of Google’s use of cookies by visiting the Google advertising opt-out page at
  <https://www.google.com/privacy_ads.html> or the Google Analytics Opt-out
  Browser Add-on at <https://tools.google.com/dlpage/gaoptout/>.

You can decide whether or not to accept cookies through your internet browser’s
settings. Most browsers have an option for turning off the cookie feature, which
will prevent your browser from accepting new cookies, as well as (depending on
the sophistication of your browser software) allow you to decide on acceptance
of each new cookie in a variety of ways. You can also delete all cookies that
are already on your device. If you do this, however, you may have to manually
adjust some preferences every time you visit our website and some of the
Services and functionalities may not work.

To explore what cookie settings are available to you, look in the “preferences”
or “options” section of your browser’s menu. To find out more information about
cookies, including information about how to manage and delete cookies, please
visit <http://www.allaboutcookies.org/> or
<https://ico.org.uk/for-the-public/online/cookies/> if you are located in the
European Union.

## Data Security and Retention

We seek to protect your Personal Data from unauthorized access, use and
disclosure using appropriate physical, technical, organizational and
administrative security measures based on the type of Personal Data and how we
are processing that data. You should also help protect your data by
appropriately selecting and protecting your password and/or other sign-on
mechanism; limiting access to your computer or device and browser; and signing
off after you have finished accessing your account. Although we work to protect
the security of your account and other data that we hold in our records, please
be aware that no method of transmitting data over the internet or storing data
is completely secure.

We retain Personal Data about you for as long as you have an open account with
us or as otherwise necessary to provide you with our Services. In some cases we
retain Personal Data for longer, if doing so is necessary to comply with our
legal obligations, resolve disputes or collect fees owed, or is otherwise
permitted or required by applicable law, rule or regulation. We may further
retain information in an anonymous or aggregated form where that information
would not identify you personally.

## Personal Data of Children

As noted in the Terms of Service, we do not knowingly collect or solicit
personally identifiable information from children under thirteen (13) years of
age and children below the [minimum age of consent in their
country](/policies/age-of-consent); if you are a
child under the age of thirteen (13) or below the minimum age of consent in your
country, please do not attempt to register for or otherwise use the Services or
send us any personal information. If we learn we have collected personal
information from a child under thirteen (13) years of age or below the minimum
age of consent in their country, we will delete that information as quickly as
possible. If you believe that a child under the age of thirteen (13) or below
the minimum age of consent in their country may have provided us personal
information, please contact us at [privacy@zulip.com](mailto:privacy@zulip.com).

## California Resident Rights under CCPA

If you are a California resident, you have the rights set forth in this section.
Please see the “Exercising Your Rights” section below for instructions regarding
how to exercise these rights. Please note that we may process Personal Data of
our customers’ end users or employees in connection with our provision of
certain services to our customers. If we are processing your Personal Data as a
service provider, you should contact the entity that collected your Personal
Data in the first instance to address your rights with respect to such data.

If there are any conflicts between this section and any other
provision of this Privacy Policy and you are a California resident,
the portion that is more protective of Personal Data shall control to
the extent of such conflict. If you have any questions about this
section or whether any of the following rights apply to you, please
contact us at [privacy@zulip.com](mailto:privacy@zulip.com).

### Access

You have the right to request certain information about our collection, use, and
disclosure of your Personal Data over the past 12 months. In response, we will
provide you with the following information:

- The categories of Personal Data that we have collected about you.
- The categories of sources from which that Personal Data was collected.
- The business or commercial purpose for collecting, using, or disclosing your
  Personal Data.
- The categories of third parties with whom we have shared your Personal Data,
  along with a reminder that we do not sell Personal Data.
- The specific pieces of Personal Data that we have collected about you.

### Deletion

You have the right to request that we delete the Personal Data that we have
collected about you. Under the CCPA, this right is subject to certain
exceptions: for example, we may need to retain your Personal Data to provide you
with the Services or complete a transaction or other action you have requested.
If your deletion request is subject to one of these exceptions, we may deny your
deletion request. Please note that we will not be able to delete messages or
other content that you have sent to another Zulip user. If you request deletion
of your account, all such messages and content will be associated with a
“Deleted User.” In addition, please note that anyone that you send messages or
other content to (or who may otherwise have access to such messages or content
through a Zulip Organization or channel) may have downloaded or copied such
messages or content. Zulip will not be able to delete such downloaded or copied
messages or content.

### Exercising Your Rights

To exercise the rights described above, you or your Authorized Agent (defined
below) must send us a request that (1) provides sufficient information to allow
us to verify that you are the person about whom we have collected Personal Data,
which may include proof of ownership of the email address associated with your
Zulip account, and (2) describes your request in sufficient detail to allow us
to understand, evaluate and respond to it. Each request that meets both of these
criteria will be considered a “Valid Request.” We may not respond to requests
that do not meet these criteria. We will only use Personal Data provided in a
Valid Request to verify your identity and complete your request. You do not need
an account to submit a Valid Request. We will work to respond to your Valid
Request within 45 days of receipt. We will not charge you a fee for making a
Valid Request unless your Valid Request(s) is excessive, repetitive or
manifestly unfounded. If we determine that your Valid Request warrants a fee, we
will notify you of the fee and explain that decision before completing your
request. You may submit a Valid Request using the following methods:

- Email us at: [privacy@zulip.com](mailto:privacy@zulip.com).
- Complete this form on our website: <https://zulip.com/support>.

You may also authorize an agent (an “Authorized Agent”) to exercise your rights
on your behalf. To do this, you must provide your Authorized Agent with written
permission to exercise your rights on your behalf, and we may require you to
confirm to us that you did so.

### Personal Data Sales Opt-Out and Opt-In

We will not sell your Personal Data, and have not done so over the last 12
months.

### We Will Not Discriminate Against You for Exercising Your Rights Under the CCPA

We will not discriminate against you for exercising your rights under the CCPA.
We will not deny you our goods or services, charge you different prices or
rates, or provide you a lower quality of goods and services if you exercise your
rights under the CCPA.

## Other State Law Privacy Rights

### California Resident Rights

Under California Civil Code Sections 1798.83-1798.84, California residents are
entitled to contact us to prevent disclosure of Personal Data to third parties
for such third parties’ direct marketing purposes In order to submit such a
request, please contact us at [privacy@zulip.com](mailto:privacy@zulip.com).

Zulip does not disclose Personal Data to any third parties for the purpose of
such parties’ direct marketing.  However, please note that your Zulip display
name, email address, avatar, and other profile information may be shared with
other users within any Zulip Organization that you join. You can confirm or
change these settings in your
[profile](/accounts/go/?next=%23settings%2Fprofile), and [account and
privacy](/accounts/go/?next=%23settings%2Faccount-and-privacy) settings.

### Nevada Resident Rights

As noted above, we do not sell Personal Data.

If you are a resident of Nevada, you have the right to opt-out of the
sale of certain Personal Data to third parties who intend to license
or sell that Personal Data. You can exercise this right by contacting
us at [privacy@zulip.com](mailto:privacy@zulip.com) with the subject
line “Nevada Do Not Sell Request” and providing us with your name and
the email address associated with your account.

## European Union Data Subject Rights

### EU Residents

If you are a resident of the European Union (“EU”), United Kingdom,
Lichtenstein, Norway or Iceland, you may have additional rights under the EU
General Data Protection Regulation (the “GDPR”) with respect to your Personal
Data, as outlined below.

For this section, we use the terms “Personal Data” and “processing” as they are
defined in the GDPR, but “Personal Data” generally means information that can be
used to individually identify a person, and “processing” generally covers
actions that can be performed in connection with data such as collection, use,
storage and disclosure. Zulip will be the controller of your Personal Data
processed in connection with the Services.

If there are any conflicts between this section and any other
provision of this Privacy Policy, the provision or portion that is
more protective of Personal Data shall control to the extent of such
conflict. If you have any questions about this section or whether any
of the following applies to you, please contact us at
[privacy@zulip.com](mailto:privacy@zulip.com). Note that we may also
process Personal Data of our customers’ end users or employees in
connection with our provision of certain services to customers, in
which case we are the processor of Personal Data. If we are the
processor of your Personal Data (i.e., not the controller), please
contact the controller party in the first instance to address your
rights with respect to such data.

### Personal Data We Collect

The “Categories of Personal Data We Collect” section above details the Personal
Data that we collect from you.

### Personal Data Use and Processing Grounds

The “Our Commercial or Business Purposes for Collecting Personal Data” section
above explains how we use your Personal Data.

We will only process your Personal Data if we have a lawful basis for doing so.
Lawful bases for processing include consent, contractual necessity and our
“legitimate interests” or the legitimate interest of others, as further
described below.

- **Contractual Necessity**:  We process the following categories of Personal
  Data as a matter of “contractual necessity”, meaning that we need to process
  the data in order to carry out our obligations under the Terms of Service,
  including providing the Services. When we process data due to contractual
  necessity, failure to process such Personal Data will result in your or other
  Zulip users’ inability to use some or all portions of the Services that
  require such data.
    - Profile or Contact Data
    - Payment Data
    - Other Identifying Information You Voluntarily Choose to Provide
    - Other Identifying Information Another User Chooses to Provide to You

- **Legitimate Interest**:  We process the following categories of Personal Data
  when we believe it furthers the legitimate interest of us or third parties:
    - Device/IP Data
    - Web Analytics
    - Geolocation Data
    - Other Identifying Information Another User Chooses to Provide to You
    - We may also de-identify or anonymize Personal Data to further our
      legitimate interests. Examples of these legitimate interests include:
        - Providing, customizing and improving the Services
        - Marketing the Services
        - Corresponding with you
        - Meeting legal requirements and enforcing legal terms
        - Completing corporate transactions

- **Consent**:  In some cases, we process Personal Data based on the consent you
  expressly grant to us at the time we collect such data. When we process
  Personal Data based on your consent, it will be expressly indicated to you at
  the point and time of collection. This information may include:
    - Social Network Data

- **Other Processing Grounds**:  From time to time we may also need to process
  Personal Data to comply with a legal obligation, if it is necessary to protect
  the vital interests of you or other data subjects, or if it is necessary for a
  task carried out in the public interest.

### Sharing Personal Data

The “How We Share Your Personal Data” section above details how we share your
Personal Data with third parties.

### EU and UK Data Subject Rights

You have certain rights with respect to your Personal Data, including
those set forth below. For more information about these rights, or to
submit a request, please email us at
[privacy@zulip.com](mailto:privacy@zulip.com). Please note that in
some circumstances, we may not be able to fully comply with your
request, such as if it is frivolous or extremely impractical, if it
jeopardizes the rights of others, or if it is not required by law, but
in those circumstances, we will still respond to notify you of such a
decision. In some cases, we may also need you to provide us with
additional information, which may include Personal Data, if necessary
to verify your identity and the nature of your request.

- **Access**:  You can request more information about the Personal Data we hold
  about you and request a copy of such Personal Data. You can also access
  certain of your Personal Data by logging on to your account.
- **Rectification**:  If you believe that any Personal Data we are holding about
  you is incorrect or incomplete, you can request that we correct or supplement
  such data. You can also correct some of this information directly by logging
  on to your account in the Zulip web application.
- **Erasure**:  You can request that we erase some or all of your Personal Data
  from our systems.  Please note that we will not be able to delete messages or
  other content that you have sent to another Zulip user. If you request
  deletion of your account, all such messages and content will be associated
  with a “Deleted User.”  In addition, please note that anyone that you send
  messages or other content to (or who may otherwise have access to such
  messages or content through a Zulip Organization or channel), may have
  downloaded or copied such messages or content. Zulip will not be able to
  delete such downloaded or copied messages or content.
- **Withdrawal of Consent**:  If we are processing your Personal Data based on
  your consent (as indicated at the time of collection of such data), you have
  the right to withdraw your consent at any time. Please note, however, that if
  you exercise this right, you may have to then provide express consent on a
  case-by-case basis for the use or disclosure of certain of your Personal Data,
  if such use or disclosure is necessary to enable you to utilize some or all of
  our Services.
- **Portability**:  You can ask for a copy of your Personal Data in a
  machine-readable format. You can also request that we transmit the data to
  another controller where technically feasible.
- **Objection**:  You can contact us to let us know that you object to the
  further use or disclosure of your Personal Data for certain purposes, such as
  for direct marketing purposes.
- **Restriction of Processing**:  You can ask us to restrict further processing
  of your Personal Data.
- **Right to File Complaint**:  You have the right to lodge a complaint about
  Zulip's practices with respect to your Personal Data with the supervisory
  authority of your country or EU Member State. A list of Supervisory
  Authorities is available here:
  <https://edpb.europa.eu/about-edpb/board/members_en>.

### Transfers of Personal Data

The Services are hosted and operated in the United States (“U.S.”) through Zulip
and its service providers, and if you do not reside in the U.S., laws in the
U.S. may differ from the laws where you reside. By using the Services, you
acknowledge that any Personal Data about you, regardless of whether provided by
you or obtained from a third party, is being provided to Zulip in the U.S. and
will be hosted on U.S. servers, and you authorize Zulip to transfer, store and
process your information to and in the U.S., and possibly other countries.

## Changes to this Privacy Policy

We’re constantly trying to improve our Services, so we may need to change this
Privacy Policy from time to time. When we do so, we will alert you to any such
changes by placing a notice on the Zulip website, by sending you an email and/or
by some other means. Please note that if you’ve opted not to receive legal
notice emails from us (or you haven’t provided us with your email address),
those legal notices will still govern your use of the Services, and you are
still responsible for reading and understanding them. We will generally aim to
provide such notice about Privacy Policy changes at least 14 days in advance of
the new Privacy Policy taking effect. If you use the Services after any changes
to the Privacy Policy have come into effect, that means you agree to all of the
changes. Use of information we collect is subject to the Privacy Policy in
effect at the time such information is collected.

## Contact Information

If you have any questions or comments about this Privacy Policy, the ways in
which we collect and use your Personal Data, or your choices and rights
regarding such collection and use, please do not hesitate to contact us at:

- <https://zulip.com/support>
- [privacy@zulip.com](mailto:privacy@zulip.com)
- Kandra Labs, Inc., 450 Townsend Street, San Francisco, CA 94107

If you are located in the European Union or United Kingdom, you may use our
contact information above, or contact our European-based representative:

- European Union Representative: George Barry, 4 St Christopher's Rd, Montenotte, Cork, T23 E9TR, Ireland
- UK Representative: S. Alec Lawton, Graigwen, Plasycoed road, Pontypool Torfaen, NP4 6QH, UK
