# Zulip Rules of Use

**Last updated: December 13, 2021.** View [change history][changes-rules].

[changes-rules]: https://github.com/zulip/zulip/commits/main/templates/corporate/policies/rules.md

Zulip is designed to help thoughtful people work on difficult problems together,
whether they work from a shared office or from all over the world. Zulip offers
an ideal platform for businesses, as well as communities of all types, including
open-source projects, research collaborations, volunteer organizations, and
other groups of people who share a common pursuit.

This document lays out rules of appropriate behavior that apply to all Zulip
organizations. Owners of Zulip organizations are expected to manage their
organizations to help avoid problematic behavior. Open organizations are
additionally encouraged to write a Code of Conduct and link to it from their
[organization profile](/help/create-your-organization-profile), to provide
further guidance on expected behavior in their communities.

If you encounter a Zulip message or behavior by a Zulip user that appears to
violate these rules, please [report it to us](/support/). We aim to be thoughtful
and judicious in handling reported content. Depending on the severity and scope
of the problem, our response may include issuing a warning, removing the
content, deactivating user accounts or organizations, and/or reporting the
behavior to law enforcement. Capitalized terms used below but not defined in
these rules have the meaning set forth in the [Terms of Service](/policies/terms).

## Safety

You may not engage in, promote, organize, incite, induce, encourage, or support
any of the following:

- **Violence, including terrorism, violent extremism, animal cruelty,
  suicide, and self-harm**.
- **Bullying, abuse, or harassment** of any individual or group of people. This
  includes threatening anyone or wishing or hoping that someone experiences
  physical harm.
- **Distribution of content that violates the privacy rights of any other
  person.** This includes personal information about any other person that you
  do not have permission to share (“doxxing”).
- **Hateful content.** You may not attack, threaten, or harass any individual or
  group on the basis of attributes such as their race, ethnicity, national
  origin, caste, religious affiliation, sexual orientation, gender or gender
  identity, age, disability, or disease.
- **Harmful misinformation.** This includes misinformation that has the
  potential to cause imminent physical harm, or that is defamatory. Deceptively
  sharing synthetic or manipulated media is also prohibited.
- **Human trafficking and exploitation, including child sexual exploitation.**
  This includes sharing content or links which depict minors in a pornographic,
  sexually suggestive, or violent manner, and includes illustrated or digitally
  altered pornography that depicts minors. If we become aware of apparent child
  exploitation, we will report it to the National Center for Missing and
  Exploited Children (NCMEC).
- **Sexually explicit content and pornography as well as commercial sexual
  services.**  This includes requesting, offering, or asking for rates for
  sexual or escort services.
- **Fraud and deception**, including financial scams such as fake loans,
  multi-level marketing schemes, get-rich-quick schemes, money-laundering
  schemes, gambling scams, insurance scams, and “money mule” businesses.
- **Distribution of content that violates the intellectual property rights,
  privacy rights, or other rights of anyone else (including Zulip).**
- **Cybercrime, hacking, cracking, or distribution of pirated software or stolen
  accounts.**
- **The sale of banned or dangerous goods** such as weapons, drugs, or other
  illegal substances. Attempting to provide material support or resources (or to
  conceal or disguise the nature, location, source, or ownership of material
  support or resources) to any organization(s) designated by the United States
  government as a foreign terrorist organization pursuant to section 219 of the
  Immigration and Nationality Act or other laws and regulations concerning
  national security, defense or terrorism is strictly prohibited.
- **Any other illegal behavior.** Activities that violate any applicable law,
  including, but not limited to, all intellectual property, data, privacy, and
  export control laws and regulations promulgated by any government agencies,
  including, but not limited to, the U.S. Securities and Exchange Commission,
  and any rules of any national and other securities exchanges, are prohibited.

## Security

- **Do not attempt to compromise the security of other users of the Services,**
  such as attempting to obtain the password or other security information of any
  other user, or to gain access to their account**.**
- **Do not attempt to compromise the security of the Services themselves.** This
  includes violating the security of any computer network or system, cracking
  any passwords or encrypted communications, or compromising, breaking, or
  circumventing any of the technical processes or security measures associated
  with the Services. Do not attempt to test for vulnerabilities in our systems
  or networks without explicit prior consent.
- **Do not exceed or circumvent rate limits,** run automated processes that
  interfere with the proper working of the Services, place an unreasonable load
  on the Services’ infrastructure, or otherwise cause excess or abusive usage.
- **Do not permit any third party to access your account** or the authentication
  credentials you use to access the Services. This includes selling, reselling,
  sublicensing, or time-sharing Zulip accounts.
- **Do not share viruses or malware**, or attempt to hack, phish, or DDoS
  others.
- **Do not automatically create or access accounts** for the Services (a.k.a.
  “scraping”) by means other than our publicly supported interfaces. If you wish
  to embed Zulip as the chat backend for your own product, you must self-host
  your own Zulip server, rather than using Zulip Cloud.

## Spam and deception

- **Do not send spam**, including unsolicited communications, promotions, or
  advertisements.
- **Do not target other accounts with notification spam** by mentioning someone
  or sending them direct messages that they do not want.
- **Do not use other accounts to contact a user who has muted you** or create a
  new account in an organization that has deactivated your account for abusive
  behavior**.** Do not circumvent features we offer to enable users to protect
  themselves from abusive behavior.
- **Do not impersonate someone else** (individuals, groups, organizations, Zulip
  staff or organization administrators, or other users) in a manner that is
  intended to or does mislead, confuse, or deceive anyone, such as “spoofing” or
  “phishing”.
- **Do not submit false reports** of abusive behavior by other users.
- **Do not contact users outside of the Services** using contact information
  obtained from the Services (including email addresses) without their consent.
  Do not create or distribute mailing lists or other collections of contact or
  user profile information for use outside of the Services.

## Third-party clients

Zulip is 100% open-source software, and we welcome third-party clients that work
with Zulip’s API or that allow Zulip users to connect to Zulip as well as other
chat services from a single client. Developers of third-party clients marketed
as working with the Zulip Cloud service are required to follow these additional
rules to protect our users:

- **Third-party clients must comply with global privacy laws**, including GDPR and
  CCPA, in their processing of any user data, including telemetry and
  error-reporting data.
- **Use security best practices** to protect Zulip users who use your client. For
  example, if your client uses the Electron browser framework, you should
  implement the [Electron Security
  guidelines](https://www.electronjs.org/docs/latest/tutorial/security).
  Projects that are early in development and potentially not yet secure must be
  advertised as insecure and not intended for general use.
- **Do not sell data** collected from Zulip users to third parties.
- **Do not sell third-party advertisements** for display within a Zulip client.

If you have any questions about the Zulip Rules of Use or would like to report a
violation, please contact us at [support@zulip.com](mailto:support@zulip.com).
