# Terms of Service

**Effective date: February 7, 2022.** View [change history][changes-terms].

[changes-terms]: https://github.com/zulip/zulip/commits/main/templates/corporate/policies/terms.md

Welcome to Zulip. Please read on to learn the rules and restrictions that govern
your use of our website(s), products, services and applications (the
“Services”). If you have any questions, comments, or concerns regarding these
terms or the Services, please contact us at:

* Email: [support@zulip.com](mailto:support@zulip.com)
* Address: Kandra Labs Inc., 450 Townsend Street, San Francisco, CA 94107

These Terms of Service (the “Terms”) are a binding contract between
you and **KANDRA LABS, INC.** (“Zulip,” “we” and “us”). Your use of
the Services in any way means that you agree to all of these Terms,
and these Terms will remain in effect while you use the
Services. These Terms include the provisions in this document as well
as those in the [Privacy Policy](/policies/privacy), [Rules of
Use](/policies/rules), and, if applicable, [Data Processing
Addendum](/static/images/policies/Zulip-Data-Processing-Addendum.pdf).

**Please read these Terms carefully.** They cover important information about
Services provided to you and any charges, taxes, and fees we bill you. **These
Terms include information about future changes to these Terms, automatic
renewals, limitations of liability, a class action waiver and resolution of
disputes by arbitration instead of in court. PLEASE NOTE THAT YOUR USE OF AND
ACCESS TO OUR SERVICES ARE SUBJECT TO THE FOLLOWING TERMS; IF YOU DO NOT AGREE
TO ALL OF THE FOLLOWING, YOU MAY NOT USE OR ACCESS THE SERVICES IN ANY MANNER.**

**ARBITRATION NOTICE AND CLASS ACTION WAIVER:** EXCEPT FOR CERTAIN TYPES OF
DISPUTES DESCRIBED IN THE ARBITRATION AGREEMENT SECTION BELOW, YOU AGREE THAT
DISPUTES BETWEEN YOU AND US WILL BE RESOLVED BY BINDING, INDIVIDUAL ARBITRATION
AND YOU WAIVE YOUR RIGHT TO PARTICIPATE IN A CLASS ACTION LAWSUIT OR CLASS-WIDE
ARBITRATION.

## Will these Terms ever change?

We are constantly trying to improve our Services, so these Terms may
need to change along with our Services. We reserve the right to change
the Terms at any time, but if we do, we will place a notice on our
site located at [https://zulip.com/policies/terms](/policies/terms),
send you an email, and/or notify you by some other means. We will
generally aim to provide such notice about changes to the Terms at
least 14 days in advance of the new Terms taking effect.

If you don’t agree with the new Terms, you are free to reject them;
unfortunately, that means you will no longer be able to use the Services. If you
use the Services in any way after a change to the Terms is effective, that means
you agree to all of the changes.

Except for changes by us as described here, no other amendment or modification
of these Terms will be effective unless in writing and signed by both you and
us.

## What about my privacy?

Zulip takes the privacy of its users very seriously; see our [Privacy
Policy](/policies/privacy) for details.

### Children’s Online Privacy Protection Act

The Children’s Online Privacy Protection Act (“COPPA”) requires that
online service providers obtain parental consent before they knowingly
collect personally identifiable information online from children who
are under thirteen (13). We do not knowingly collect or solicit
personally identifiable information from children under thirteen (13)
years of age and children below the minimum [minimum age of consent in
their country](/policies/age-of-consent); if you are a child under the
age of thirteen (13) or below the minimum age of consent in your
country, please do not attempt to register for or otherwise use the
Services or send us any personal information. If we learn we have
collected personal information from a child under thirteen (13) years
of age or below the minimum age of consent in their country, we will
delete that information as quickly as possible. If you believe that a
child under the age of thirteen (13) or below the minimum age of
consent in their country may have provided us personal information,
please contact us at [privacy@zulip.com](mailto:privacy@zulip.com).

## What are the basics of using Zulip?

To use some of the Services, you may be required to sign up for an account,
select a password and display name (“Zulip Display Name”), and provide us with
certain information or data, such as your email address. You agree that you are
solely responsible for ensuring that your registration information, including
your email address, is accurate, complete and up to date. You may not select as
your Zulip Display Name a name that you do not have the right to use, or another
person’s name with the intent to impersonate that person. You may not transfer
your account to anyone else without our prior written permission.

Additionally, you may be able to access certain parts or features of the
Services by using your account credentials from third party services (“Third
Party Accounts”), such as those offered by Google and Apple. By using the
Services through a Third Party Account, you permit us to access certain
information from such account for use by the Services. You are ultimately in
control of how much information is accessible to us and may exercise such
control by adjusting your privacy settings on your Third Party Account.

You represent and warrant that you are an individual of legal age to form a
binding contract (or if not, you’ve received your parent’s or guardian’s
permission to use the Services and have gotten your parent or guardian to agree
to these Terms on your behalf). If you’re agreeing to these Terms on behalf of
an organization or entity or creating or administering an organization or group
in use of the Services (each such organization, entity, or group, a “Zulip
Organization”, and each administrator of a Zulip Organization, a “Zulip
Organization Administrator”), you represent and warrant that you are authorized
to agree to these Terms on such Zulip Organization’s behalf and bind them to
these Terms (in which case, the references to “you” and “your” in these Terms,
except for in this sentence, refer to that Zulip Organization).

You will only use the Services for your own internal, personal use, and not on
behalf of or for the benefit of any third party, and only in a manner that
complies with all laws that apply to you. If your use of the Services is
prohibited by applicable laws, then you aren’t authorized to use the Services.
We can’t and won’t be responsible for your using the Services in a way that
breaks the law.

You will not share your Zulip account or password with anyone, and you must
protect the security of your Zulip account, your password, and any other access
tools or credentials. You’re responsible for any activity associated with your
Zulip account.

## What about notifications?

As part of the Services, you may receive communications through the Services,
including notifications that Zulip sends you (for example, via email or SMS).
When signing up for the Services, you will receive a welcome notification and
instructions on how to stop receiving notifications. **By signing up for the
Services and providing us with your wireless number, you confirm that you want
Zulip to send you information regarding your account or transactions with us,
which may include Zulip using automated dialing technology to text you at the
wireless number you provided, and you agree to receive communications from
Zulip, and you represent and warrant that each person you register for the
Services or for whom you provide a wireless phone number has consented to
receive communications from Zulip.** You agree to indemnify and hold Zulip
harmless from and against any and all claims, liabilities, damages (actual and
consequential), losses and expenses (including attorneys’ fees) arising from or
in any way related to any breach of the foregoing on your part.

## What are my rights in the Services?

The materials displayed or performed or available on or through the Services,
including, but not limited to, text, graphics, data, articles, photos, images,
illustrations, User Submissions (as defined below) and so forth (all of the
foregoing, the “Content”) are protected by copyright and/or other intellectual
property laws. You promise to abide by all copyright notices, trademark rules,
information, and restrictions contained in any Content you access through the
Services, and you won’t use, copy, reproduce, modify, translate, publish,
broadcast, transmit, distribute, perform, upload, display, license, sell,
commercialize or otherwise exploit for any purpose any Content not owned by you
in a way that violates someone else’s (including Zulip's) rights.

Subject to these Terms, we grant each user of the Services a worldwide,
non-exclusive, non-sublicensable and non-transferable license to:

- Use (i.e., to download and display locally) Content solely for purposes of
  using the Services.

- Export Content via the official Zulip API and distribute such Content for
  legitimate purposes (e.g., a public archive or mirror which is approved by
  organization owners).

Use, reproduction, modification, distribution or storage of any Content for any
purpose other than using the Services is expressly prohibited without prior
written permission from us.

You understand that Zulip owns the Services. You won’t modify, publish,
transmit, participate in the transfer or sale of, reproduce (except as expressly
provided in this Section), create derivative works based on, or otherwise
exploit any of the Services. You will also not upload to, or transmit from, the
Services any data, file, software, or link that contains or redirects to a
virus, Trojan horse, worm, or other harmful component or a technology that
unlawfully accesses or downloads content or information stored within the
Services. The Services may allow you to copy or download certain Content, but
please remember that even where these functionalities exist, all the
restrictions in this section still apply.

## What about anything I contribute to the Services? Do I have to grant any licenses to Zulip or to other users?

### User Submissions

Anything you post, upload, share, store, or otherwise provide through the
Services is your “User Submission”. Some User Submissions may be viewable by
other users or by anyone on the Internet. You are solely responsible for all
User Submissions you contribute to the Services. You represent that all User
Submissions submitted are not false, deceptive, or misleading, and are in
compliance with all applicable laws, rules and regulations.

### Licenses
Your User Submissions remain yours. These Terms don’t give us any ownership in
your User Submissions, or any rights to them except the limited rights set forth
below.

To provide the Services, we need your permission to do things like storing your
User Submissions and showing them to the people you send messages to, or who
otherwise have permission to see them (for example, any member of your Zulip
Organization for a message you send to a public channel.) Our Services also
provide you with features like sharing and searching. To provide these and other
features, Zulip may access, use, store, copy, process, adapt, distribute,
perform, export, and display your User Submissions. Note that the following
licenses are subject to our [Privacy Policy](/policies/privacy) to the extent
they relate to User Submissions that are also your personally-identifiable
information.

You give us permission to do these things only as reasonably necessary (a) to
deliver the Services; (b) to prevent or address service, security, support,
abuse or technical issues; or (c) as required by law. This license is
non-exclusive, worldwide, perpetual, royalty-free, fully paid, sublicensable and
transferable to use, edit, modify, truncate, aggregate, reproduce, distribute,
prepare derivative works of, display, perform, and otherwise fully exploit the
User Submissions in connection with the Services and extends to our affiliates
and trusted third parties we work with.

Other people may have access to your User Submissions through the Services, and
you also give those people a non-exclusive, worldwide permission to do these
things, only as permitted by the functionality of the Services and these Terms.
For example:

- People you send a Zulip message to may view the message through the Services.
- Your Zulip Organization Administrators may [export the Zulip Organization’s
  data](/help/export-your-organization) for archival or backup purposes, or to
  import the data into a self-hosted Zulip server.
- Messages on a web-public channel may be viewed by anyone on the Internet.

When you delete your Zulip account, we will stop displaying your User
Submissions in association with your account, if applicable. You understand that
User Submissions may still be viewable in association with a “deleted user”
after you delete your Zulip account. You understand and agree that it may not be
possible to completely delete that content from Zulip's records, and that your
User Submissions may remain viewable elsewhere to the extent that they were
copied or stored by other users.

We welcome feedback, but note that by sending any feedback, you grant us an
irrevocable, non-exclusive, royalty-free, perpetual, worldwide license to use,
modify, prepare derivative works from, publish, distribute and sublicense any
such feedback, and we may incorporate into our products and services any
feedback, comments, or suggestions without any obligation or compensation to
you.

## Are there restrictions in how I can use the Services?

You represent, warrant, and agree that you will not provide or contribute
anything, including any Content or User Submission, to the Services, or
otherwise use or interact with the Services, in a manner that is not consistent
with the [Zulip Rules of Use](/policies/rules). A violation of any of the Zulip
Rules of Use is grounds for termination of your right to use or access the
Services.

## What if I see something on the Services that infringes my copyright?

In accordance with the DMCA, we’ve adopted the following policy toward copyright
infringement.  We reserve the right to (1) block access to or remove material
that we believe in good faith to be copyrighted material that has been illegally
copied and distributed by any of our advertisers, affiliates, content providers,
members or users and (2) remove and discontinue service to repeat offenders.

* **Procedure for Reporting Copyright Infringements**.  If you believe that
   material or content residing on or accessible through the Services infringes
   your copyright (or the copyright of someone whom you are authorized to act on
   behalf of), please send a notice of copyright infringement containing the
   following information to Zulip's Designated Agent to Receive Notification of
   Claimed Infringement (our “Designated Agent,” whose contact details are
   listed below):
      * (a) A physical or electronic signature of a person authorized to act on behalf
         of the owner of the copyright that has been allegedly infringed;
      * (b) Identification of works or materials being infringed;
      * (c) Identification of the material that is claimed to be infringing including
         information regarding the location of the infringing materials that the
         copyright owner seeks to have removed, with sufficient detail so that we
         are capable of finding and verifying its existence;
      * (d) Contact information about the notifier including address, telephone number
         and, if available, email address;
      * (e) A statement that the notifier has a good faith belief that the material
         identified in (c) is not authorized by the copyright owner, its agent,
         or the law; and
      * (f) A statement made under penalty of perjury that the information provided is
         accurate and the notifying party is authorized to make the complaint on
         behalf of the copyright owner.
* **Once Proper Bona Fide Infringement Notification is Received by the
   Designated Agent**.  Upon receipt of a proper notice of copyright
   infringement, we reserve the right to:
      * (a) remove or disable access to the infringing material;
      * (b) notify the content provider who is accused of infringement that we have
          removed or disabled access to the applicable material; and
      * (c) terminate such content provider's access to the Services if they are a
          repeat offender.
* **Procedure to Supply a Counter-Notice to the Designated Agent**.  If the
   content provider believes that the material that was removed (or to which
   access was disabled) is not infringing, or the content provider believes that
   it has the right to post and use such material from the copyright owner, the
   content provider may send us a counter-notice containing the following
   information to the Designated Agent:
       * (a) A physical or electronic signature of the content provider;
       * (b) Identification of the material that has been removed or to which access
           has been disabled and the location at which the material appeared before
           it was removed or disabled;
       * (c) A statement under penalty of perjury that the content provider has a
           good faith belief that the material was removed or disabled as a result
           of mistake or misidentification of the material; and
       * (d) Content provider's name, address, telephone number, and, if available,
           email address, and a statement that the content provider consents to the
           jurisdiction of the Federal Court for the judicial district in which the
           content provider’s address is located, or, if the content provider's
           address is located outside the United States, for any judicial district
           in which Company is located, and that the content provider will accept
           service of process from the person who provided notification of the
           alleged infringement or an agent of such person.

If a counter-notice is received by the Designated Agent, Company may, in its
discretion, send a copy of the counter-notice to the original complaining party
informing that person that Company may replace the removed material or cease
disabling it in 10 business days. Unless the copyright owner files an action
seeking a court order against the content provider accused of committing
infringement, the removed material may be replaced or access to it restored 10
business days or more after receipt of the counter-notice, at Company's
discretion.

Please contact Zulip's Designated Agent at the following address:

Kandra Labs, Inc.<br/>
Attn: DMCA Designated Agent<br/>
450 Townsend Street<br/>
San Francisco, CA 94107

## Who is responsible for what I see and do on the Services?

Any information or Content publicly posted or privately transmitted through the
Services is the sole responsibility of the person from whom such Content
originated, and you access all such information and Content at your own risk,
and we aren’t liable for any errors or omissions in that information or Content
or for any damages or loss you might suffer in connection with it. We cannot
control and have no duty to take any action regarding how you may interpret and
use the Content or what actions you may take as a result of having been exposed
to the Content, and you hereby release us from all liability for you having
acquired or not acquired Content through the Services. We can’t guarantee the
identity of any users with whom you interact in using the Services and are not
responsible for which users gain access to the Services.

You are responsible for all Content you contribute, in any manner, to the
Services, and you represent and warrant you have all rights necessary to do so,
in the manner in which you contribute it.

The Services may contain links or connections to third-party websites or
services that are not owned or controlled by Zulip. When you access third-party
websites or use third-party services, you accept that there are risks in doing
so, and that Zulip is not responsible for such risks.

Zulip has no control over, and assumes no responsibility for, the content,
accuracy, privacy policies, or practices of or opinions expressed in any
third-party websites or by any third party that you interact with through the
Services. In addition, Zulip will not and cannot monitor, verify, censor or edit
the content of any third-party site or service. We encourage you to be aware
when you leave the Services and to read the terms and conditions and privacy
policy of each third-party website or service that you visit or utilize. By
using the Services, you release and hold us harmless from any and all liability
arising from your use of any third-party website or service.

Your interactions with Zulip Organizations and/or individuals found on or
through the Services, including payment and delivery of goods or services, and
any other terms, conditions, warranties or representations associated with such
dealings, are solely between you and such organizations and/or individuals. You
should make whatever investigation you feel necessary or appropriate before
proceeding with any online or offline transaction with any of these third
parties. You agree that Zulip shall not be responsible or liable for any loss or
damage of any sort incurred as the result of any such dealings.

If there is a dispute between participants on this site or Services, or between
users and any third party, you agree that Zulip is under no obligation to become
involved. In the event that you have a dispute with one or more other users, you
release Zulip, its directors, officers, employees, agents, and successors from
claims, demands, and damages of every kind or nature, known or unknown,
suspected or unsuspected, disclosed or undisclosed, arising out of or in any way
related to such disputes and/or our Services. You shall and hereby do waive
California Civil Code Section 1542 or any similar law of any jurisdiction, which
says in substance: “A general release does not extend to claims that the
creditor or releasing party does not know or suspect to exist in his or her
favor at the time of executing the release and that, if known by him or her,
would have materially affected his or her settlement with the debtor or released
party.”

## Will Zulip ever change the Services?

We’re always trying to improve our Services, so they may change over time. We
may suspend or discontinue any part of the Services, or we may introduce new
features or impose limits on certain features or restrict access to parts or all
of the Services. We reserve the right to remove any Content from the Services at
any time, for any reason (including, but not limited to, if someone alleges you
contributed that Content in violation of these Terms), in our sole discretion,
and without notice.

## Do the Services cost anything?

The Services may be free or we may charge a fee for using the Services. If you
are using a free version of the Services, we will notify you before any Services
you are then using begin carrying a fee, and if you wish to continue using such
Services, you must pay all applicable fees for such Services. Note that if you
elect to receive text messages through the Services, data and message rates may
apply. Any and all such charges, fees or costs are your sole responsibility. You
should consult with your wireless carrier to determine what rates, charges, fees
or costs may apply to your use of the Services.

* (a) **Paid Services**. Certain of our Services may be subject to payments now or
   in the future (the “Paid Services”). Please see our Paid Services page:
   <https://zulip.com/plans/> for a description of the current Paid Services.
   Please note that any payment terms presented to you in the process of using
   or signing up for a Paid Service are deemed part of these Terms.
* (b) **Billing**. We use a third-party payment processor (the “Payment Processor”)
   to bill you through a payment account linked to your account on the Services
   (your “Billing Account”) for use of the Paid Services. The processing of
   payments will be subject to the terms, conditions and privacy policies of the
   Payment Processor in addition to these Terms. Currently, we use Stripe, Inc.
   as our Payment Processor. You can access Stripe’s Terms of Service at
   <https://stripe.com/us/checkout/legal> and their Privacy Policy at
   <https://stripe.com/us/privacy>. We are not responsible for any error by, or
   other acts or omissions of, the Payment Processor. By choosing to use Paid
   Services, you agree to pay us, through the Payment Processor, all charges at
   the prices then in effect for any use of such Paid Services in accordance
   with the applicable payment terms, and you authorize us, through the Payment
   Processor, to charge your chosen payment provider (your “Payment Method”).
   You agree to make payment using that selected Payment Method. We reserve the
   right to correct any errors or mistakes that the Payment Processor makes even
   if it has already requested or received payment.
* (c) **Payment Method**. The terms of your payment will be based on your Payment
   Method and may be determined by agreements between you and the financial
   institution, credit card issuer or other provider of your chosen Payment
   Method. If we, through the Payment Processor, do not receive payment from
   you, you agree to pay all amounts due on your Billing Account upon demand.
* (d) **Recurring Billing**. Some of the Paid Services may consist of an initial
   period, for which there is a one-time charge, followed by recurring period
   charges as agreed to by you. By choosing a recurring payment plan, you
   acknowledge that such Services have an initial and recurring payment feature
   and you accept responsibility for all recurring charges prior to
   cancellation. WE MAY SUBMIT PERIODIC CHARGES (E.G., MONTHLY) WITHOUT FURTHER
   AUTHORIZATION FROM YOU, UNTIL YOU PROVIDE PRIOR NOTICE (RECEIPT OF WHICH IS
   CONFIRMED BY US) THAT YOU HAVE TERMINATED THIS AUTHORIZATION OR WISH TO
   CHANGE YOUR PAYMENT METHOD. SUCH NOTICE WILL NOT AFFECT CHARGES SUBMITTED
   BEFORE WE REASONABLY COULD ACT. TO TERMINATE YOUR AUTHORIZATION OR CHANGE
   YOUR PAYMENT METHOD, GO TO YOUR [BILLING SETTINGS](/billing/).
* (e) **Current Information Required**. YOU MUST PROVIDE CURRENT, COMPLETE AND
   ACCURATE INFORMATION FOR YOUR BILLING ACCOUNT. YOU MUST PROMPTLY UPDATE ALL
   INFORMATION TO KEEP YOUR BILLING ACCOUNT CURRENT, COMPLETE AND ACCURATE (SUCH
   AS A CHANGE IN BILLING ADDRESS, CREDIT CARD NUMBER, OR CREDIT CARD EXPIRATION
   DATE), AND YOU MUST PROMPTLY NOTIFY US OR OUR PAYMENT PROCESSOR IF YOUR
   PAYMENT METHOD IS CANCELED (E.G., FOR LOSS OR THEFT) OR IF YOU BECOME AWARE
   OF A POTENTIAL BREACH OF SECURITY, SUCH AS THE UNAUTHORIZED DISCLOSURE OR USE
   OF YOUR USER NAME OR PASSWORD. CHANGES TO SUCH INFORMATION CAN BE MADE IN
   YOUR [BILLING SETTINGS](/billing/). IF YOU FAIL TO PROVIDE ANY OF THE
   FOREGOING INFORMATION, YOU AGREE THAT WE MAY CONTINUE CHARGING YOU FOR ANY
   USE OF PAID SERVICES UNDER YOUR BILLING ACCOUNT UNLESS YOU HAVE TERMINATED
   YOUR PAID SERVICES AS SET FORTH ABOVE.
* (f) **Change in Amount Authorized**. If the amount to be charged to your Billing
   Account varies from the amount you preauthorized (other than due to the
   imposition or change in the amount of sales taxes), you have the right to
   receive, and we shall provide, notice of the amount to be charged and the
   date of the charge before the scheduled date of the transaction. Any
   agreement you have with your payment provider will govern your use of your
   Payment Method. You agree that we may accumulate charges incurred and submit
   them as one or more aggregate charges during or at the end of each billing
   cycle.
* (g) **Auto-Renewal for Paid Services**. Unless you opt out of auto-renewal, which
   can be done through your [billing settings](/billing/), any Paid Services you
   have signed up for will be automatically extended for successive renewal
   periods of the same duration as the subscription term originally selected, at
   the then-current non-promotional rate. To change or resign your Paid Services
   at any time, go to your [billing settings](/billing/).  If you terminate a
   Paid Service, you may use your subscription until the end of your
   then-current term, and your subscription will not be renewed after your
   then-current term expires. However, you will not be eligible for a prorated
   refund of any portion of the subscription fee paid for the then-current
   subscription period. IF YOU DO NOT WANT TO CONTINUE TO BE CHARGED ON A
   RECURRING BASIS, YOU MUST CANCEL THE APPLICABLE PAID SERVICE THROUGH YOUR
   [BILLING SETTINGS](/billing/) OR TERMINATE YOUR ZULIP ACCOUNT BEFORE THE END
   OF THE RECURRING TERM. PAID SERVICES CANNOT BE TERMINATED BEFORE THE END OF
   THE PERIOD FOR WHICH YOU HAVE ALREADY PAID, AND EXCEPT AS EXPRESSLY PROVIDED
   IN THESE TERMS, ZULIP WILL NOT REFUND ANY FEES THAT YOU HAVE ALREADY PAID.
* (h) **Reaffirmation of Authorization**. Your non-termination or continued use of
   a Paid Service reaffirms that we are authorized to charge your Payment Method
   for that Paid Service. We may submit those charges for payment and you will
   be responsible for such charges. This does not waive our right to seek
   payment directly from you. Your charges may be payable in advance, in
   arrears, per usage, or as otherwise described when you initially selected to
   use the Paid Service.
* (i) **Free Trials and Other Promotions**. Any free trial or other promotion that
   provides access to a Paid Service may only be used within the specified time
   of the trial. You must stop using a Paid Service before the end of the trial
   period in order to avoid being charged for that Paid Service. If you cancel
   prior to the end of the trial period and are inadvertently charged for a Paid
   Service, please contact us at [support@zulip.com](mailto:support@zulip.com).

## What if I want to stop using the Services?

You’re free to stop using the Services at any time by contacting us at
[support@zulip.com](mailto:support@zulip.com); please refer to our [Privacy
Policy](/policies/privacy), as well as the licenses above, to understand how we
treat information you provide to us after you have stopped using our Services.

Zulip is also free to terminate (or suspend access to) your use of the Services
or your account for any reason at our sole discretion, including your breach of
these Terms. Zulip has the sole right to decide whether you are in violation of
any of the restrictions set forth in these Terms.

Account termination may result in destruction of any Content associated with
your account, so keep that in mind before you decide to terminate your account.
We will try to provide advance notice to you prior to our terminating your
account so that you are able to retrieve any important User Submissions you may
have stored in your account (to the extent allowed by law and these Terms), but
we may not do so if we determine it would be impractical, illegal, not in the
interest of someone’s safety or security, or otherwise harmful to the rights or
property of Zulip or third parties.

If you have deleted your account by mistake, contact us immediately at
[support@zulip.com](mailto:support@zulip.com) – we will try to help, but
unfortunately, we can’t promise that we can recover or restore anything.

Provisions that, by their nature, should survive termination of these Terms
shall survive termination. By way of example, all of the following will survive
termination: any obligation you have to pay us or indemnify us, any limitations
on our liability, any terms regarding ownership or intellectual property rights,
and terms regarding disputes between us, including without limitation the
arbitration agreement.

## What about Mobile Applications?

You acknowledge and agree that the availability of our mobile application is
dependent on the third party stores from which you download the application,
e.g., the App Store from Apple or the Play Store from Google (each an “App
Store”). Each App Store may have its own terms and conditions to which you must
agree before downloading mobile applications from such store, including the
specific terms relating to Apple App Store set forth below. You agree to comply
with, and your license to use our application is conditioned upon your
compliance with, such App Store terms and conditions. To the extent such other
terms and conditions from such App Store are less restrictive than, or otherwise
conflict with, the terms and conditions of these Terms of Service, the more
restrictive or conflicting terms and conditions in these Terms of Service apply.

### I use the Zulip App available via the Apple App Store – should I know anything about that?

These Terms apply to your use of all the Services, including our iOS
applications (the “Application”) available via the Apple, Inc. (“Apple”) App
Store, but the following additional terms also apply to the Application:

* (a) Both you and Zulip acknowledge that the Terms are concluded between you and
   Zulip only, and not with Apple, and that Apple is not responsible for the
   Application or the Content;
* (b) The Application is licensed to you on a limited, non-exclusive,
   non-transferrable, non-sublicensable basis, solely to be used in connection
   with the Services for your private, internal, personal use, subject to all
   the terms and conditions of these Terms as they are applicable to the
   Services;
* (c) You will only use the Application in connection with an Apple device that you
   own or control;
* (d) You acknowledge and agree that Apple has no obligation whatsoever to furnish
   any maintenance and support services with respect to the Application;
* (e) In the event of any failure of the Application to conform to any applicable
   warranty, including those implied by law, you may notify Apple of such
   failure; upon notification, Apple’s sole warranty obligation to you will be
   to refund to you the purchase price, if any, of the Application;
* (f) You acknowledge and agree that Zulip, and not Apple, is responsible for
   addressing any claims you or any third party may have in relation to the
   Application;
* (g) You acknowledge and agree that, in the event of any third-party claim that
   the Application or your possession and use of the Application infringes that
   third party’s intellectual property rights, Zulip, and not Apple, will be
   responsible for the investigation, defense, settlement and discharge of any
   such infringement claim;
* (h) You represent and warrant that you are not located in a country subject to a
   U.S. Government embargo, or that has been designated by the U.S. Government
   as a “terrorist supporting” country, and that you are not listed on any U.S.
   Government list of prohibited or restricted parties;
* (i) Both you and Zulip acknowledge and agree that, in your use of the
   Application, you will comply with any applicable third-party terms of
   agreement which may affect or be affected by such use; and
* (j) Both you and Zulip acknowledge and agree that Apple and Apple’s subsidiaries
    are third-party beneficiaries of these Terms, and that upon your acceptance
    of these Terms, Apple will have the right (and will be deemed to have
    accepted the right) to enforce these Terms against you as the third-party
    beneficiary hereof.

## What else do I need to know?

*Warranty Disclaimer.* Zulip and its licensors, suppliers, partners, parent,
subsidiaries or affiliated entities, and each of their respective officers,
directors, members, employees, consultants, contract employees, representatives
and agents, and each of their respective successors and assigns (Zulip and all
such parties together, the “Zulip Parties”) make no representations or
warranties concerning the Services, including without limitation regarding any
Content contained in or accessed through the Services, and the Zulip Parties
will not be responsible or liable for the accuracy, copyright compliance,
legality, or decency of material contained in or accessed through the Services
or any claims, actions, suits, procedures, costs, expenses, damages or
liabilities arising out of use of, or in any way related to your participation
in, the Services. The Zulip Parties make no representations or warranties
regarding suggestions or recommendations of services or products offered or
purchased through or in connection with the Services. THE SERVICES AND CONTENT
ARE PROVIDED BY ZULIP (AND ITS LICENSORS AND SUPPLIERS) ON AN “AS-IS” BASIS,
WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING, WITHOUT
LIMITATION, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE, NON-INFRINGEMENT, OR THAT USE OF THE SERVICES WILL BE UNINTERRUPTED OR
ERROR-FREE. SOME STATES DO NOT ALLOW LIMITATIONS ON HOW LONG AN IMPLIED WARRANTY
LASTS, SO THE ABOVE LIMITATIONS MAY NOT APPLY TO YOU.

*Limitation of Liability*. TO THE FULLEST EXTENT ALLOWED BY APPLICABLE LAW,
UNDER NO CIRCUMSTANCES AND UNDER NO LEGAL THEORY (INCLUDING, WITHOUT LIMITATION,
TORT, CONTRACT, STRICT LIABILITY, OR OTHERWISE) SHALL ANY OF THE ZULIP PARTIES
BE LIABLE TO YOU OR TO ANY OTHER PERSON FOR (A) ANY INDIRECT, SPECIAL,
INCIDENTAL, PUNITIVE OR CONSEQUENTIAL DAMAGES OF ANY KIND, INCLUDING DAMAGES FOR
LOST PROFITS, BUSINESS INTERRUPTION, LOSS OF DATA, LOSS OF GOODWILL, WORK
STOPPAGE, ACCURACY OF RESULTS, OR COMPUTER FAILURE OR MALFUNCTION, (B) ANY
SUBSTITUTE GOODS, SERVICES OR TECHNOLOGY, (C) ANY AMOUNT, IN THE AGGREGATE, IN
EXCESS OF THE GREATER OF (I) ONE-HUNDRED ($100) DOLLARS OR (II) THE AMOUNTS PAID
AND/OR PAYABLE BY YOU TO ZULIP IN CONNECTION WITH THE SERVICES IN THE TWELVE
(12) MONTH PERIOD PRECEDING THIS APPLICABLE CLAIM OR (D) ANY MATTER BEYOND OUR
REASONABLE CONTROL. SOME STATES DO NOT ALLOW THE EXCLUSION OR LIMITATION OF
INCIDENTAL OR CONSEQUENTIAL OR CERTAIN OTHER DAMAGES, SO THE ABOVE LIMITATION
AND EXCLUSIONS MAY NOT APPLY TO YOU.

*Indemnity*. To the fullest extent allowed by applicable law, you agree to
indemnify and hold the Zulip Parties harmless from and against any and all
claims, liabilities, damages (actual and consequential), losses and expenses
(including attorneys’ fees) arising from or in any way related to any claims
relating to (a) your use of the Services (including any actions taken by a third
party using your account), and (b) your violation of these Terms.

*Assignment*. You may not assign, delegate or transfer these Terms or your
rights or obligations hereunder, or your Services account, in any way (by
operation of law or otherwise) without Zulip's prior written consent. We may
transfer, assign, or delegate these Terms and our rights and obligations without
consent.

*Choice of Law*. These Terms are governed by and will be construed under the
Federal Arbitration Act, applicable federal law, and the laws of the State of
California, without regard to the conflicts of laws provisions thereof.

*Arbitration Agreement.* Please read the following ARBITRATION AGREEMENT
carefully because it requires you to arbitrate certain disputes and claims with
Zulip and limits the manner in which you can seek relief from Zulip. Both you
and Zulip acknowledge and agree that for the purposes of any dispute arising out
of or relating to the subject matter of these Terms, Zulip's officers,
directors, employees and independent contractors (“Personnel”) are third-party
beneficiaries of these Terms, and that upon your acceptance of these Terms,
Personnel will have the right (and will be deemed to have accepted the right) to
enforce these Terms against you as the third-party beneficiary hereof.

* (a) *Arbitration Rules; Applicability of Arbitration Agreement*. The parties
  shall use their best efforts to settle any dispute, claim, question, or
  disagreement arising out of or relating to the subject matter of these Terms
  directly through good-faith negotiations, which shall be a precondition to
  either party initiating arbitration. If such negotiations do not resolve the
  dispute, it shall be finally settled by binding arbitration in San Francisco
  County, California. The arbitration will proceed in the English language, in
  accordance with the JAMS Streamlined Arbitration Rules and Procedures (the
  “Rules”) then in effect, by one commercial arbitrator with substantial
  experience in resolving intellectual property and commercial contract
  disputes. The arbitrator shall be selected from the appropriate list of JAMS
  arbitrators in accordance with such Rules. Judgment upon the award rendered by
  such arbitrator may be entered in any court of competent jurisdiction.

* (b) *Costs of Arbitration*. The Rules will govern payment of all arbitration
  fees. Zulip will pay all arbitration fees for claims less than seventy-five
  thousand ($75,000) dollars. Zulip will not seek its attorneys’ fees and costs
  in arbitration unless the arbitrator determines that your claim is frivolous.

* (c) *Small Claims Court; Infringement*. Either you or Zulip may assert claims,
  if they qualify, in small claims court in San Francisco County, California or
  any United States county where you live or work. Furthermore, notwithstanding
  the foregoing obligation to arbitrate disputes, each party shall have the
  right to pursue injunctive or other equitable relief at any time, from any
  court of competent jurisdiction, to prevent the actual or threatened
  infringement, misappropriation or violation of a party's copyrights,
  trademarks, trade secrets, patents or other intellectual property rights.

* (d) *Waiver of Jury Trial*. YOU AND ZULIP WAIVE ANY CONSTITUTIONAL AND
  STATUTORY RIGHTS TO GO TO COURT AND HAVE A TRIAL IN FRONT OF A JUDGE OR JURY.
  You and Zulip are instead choosing to have claims and disputes resolved by
  arbitration. Arbitration procedures are typically more limited, more
  efficient, and less costly than rules applicable in court and are subject to
  very limited review by a court. In any litigation between you and Zulip over
  whether to vacate or enforce an arbitration award, YOU AND ZULIP WAIVE ALL
  RIGHTS TO A JURY TRIAL, and elect instead to have the dispute be resolved by a
  judge.

* (e) *Waiver of Class or Consolidated Actions*. ALL CLAIMS AND DISPUTES WITHIN
  THE SCOPE OF THIS ARBITRATION AGREEMENT MUST BE ARBITRATED OR LITIGATED ON AN
  INDIVIDUAL BASIS AND NOT ON A CLASS BASIS. CLAIMS OF MORE THAN ONE CUSTOMER OR
  USER CANNOT BE ARBITRATED OR LITIGATED JOINTLY OR CONSOLIDATED WITH THOSE OF
  ANY OTHER CUSTOMER OR USER. If however, this waiver of class or consolidated
  actions is deemed invalid or unenforceable, neither you nor Zulip is entitled
  to arbitration; instead all claims and disputes will be resolved in a court as
  set forth in (g) below.

* (f) *Opt-out*. You have the right to opt out of the provisions of this
  Arbitration Agreement by sending written notice of your decision to opt out to
  the following address: 450 Townsend Street, San Francisco, CA 94107 postmarked
  within thirty (30) days of first accepting these Terms. You must include (i)
  your name and residence address, (ii) the email address and/or telephone
  number associated with your account, and (iii) a clear statement that you want
  to opt out of these Terms’ arbitration agreement.

* (g) *Exclusive Venue*. If you send the opt-out notice in (f), and/or in any
  circumstances where the foregoing arbitration agreement permits either you or
  Zulip to litigate any dispute arising out of or relating to the subject matter
  of these Terms in court, then the foregoing arbitration agreement will not
  apply to either party, and both you and Zulip agree that any judicial
  proceeding (other than small claims actions) will be brought in the state or
  federal courts located in, respectively, San Francisco County, California, or
  the federal district in which that county falls.

* (h) *Severability*. If the prohibition against class actions and other claims
  brought on behalf of third parties contained above is found to be
  unenforceable, then all of the preceding language in this Arbitration
  Agreement section will be null and void. This arbitration agreement will
  survive the termination of your relationship with Zulip.

*Miscellaneous*. You will be responsible for paying, withholding, filing, and
reporting all taxes, duties, and other governmental assessments associated with
your activity in connection with the Services, provided that Zulip may, in its
sole discretion, do any of the foregoing on your behalf or for itself as it sees
fit. The failure of either you or us to exercise, in any way, any right herein
shall not be deemed a waiver of any further rights hereunder. If any provision
of these Terms are found to be unenforceable or invalid, that provision will be
limited or eliminated, to the minimum extent necessary, so that these Terms
shall otherwise remain in full force and effect and enforceable. You and Zulip
agree that these Terms are the complete and exclusive statement of the mutual
understanding between you and Zulip, and that these Terms supersede and cancel
all previous written and oral agreements, communications and other
understandings relating to the subject matter of these Terms. You hereby
acknowledge and agree that neither these Terms nor your use of the Services
makes you an employee, agent, partner, or joint venture of Zulip, and you do not
have any authority of any kind to bind Zulip in any respect whatsoever.

Except as expressly set forth in the sections above regarding the Apple
Application and the arbitration agreement, you and Zulip agree there are no
third-party beneficiaries intended under these Terms.
