## Building software that will always be there for our users

When choosing software that will be core to how one’s organization operates,
such as a team chat platform, there is an important question: “Will this product
still exist and be responsibly maintained in a few years?”

We have designed our company, community, and technology with the explicit goal
of Zulip being actively developed for many years to come.

This theme cuts across many of the decisions described below. It is also
reflected in our [history](/history/): Zulip's [earliest
customers](/case-studies/recurse-center/) have enjoyed uninterrupted service
since 2013.

## Keeping Zulip 100% open source

Many modern “open-source” companies use a version of their product with some
basic functionality intentionally removed as a demo for their non-open-source
paid product. In contrast, we are committed to keeping Zulip [100% open
source](https://github.com/zulip/zulip#readme).

When you [self-host Zulip](/self-hosting/), you get all the
[features](/features/) of our cloud offering. We work hard to [make it
easy](https://zulip.readthedocs.io/en/latest/production/install.html) to set up
and run a self-hosted Zulip installation without paying us a dime, which is why
thousands of organizations do so.

## Investing in community and mentorship

Zulip is developed by a [vibrant open-source community](/team/), and we are
fully committed to helping bring up the next generation of open-source
contributors from a wide range of backgrounds.

We have invested into making Zulip’s code uniquely readable, well tested, and
easy to modify. Beyond that, we have written an extraordinary 150K words of
documentation on [how to contribute to
Zulip](https://zulip.readthedocs.io/en/latest/overview/contributing.html), with
topics ranging from [practical Git
tips](https://zulip.readthedocs.io/en/latest/git/index.html) to [essays on
important architectural
decisions](https://zulip.readthedocs.io/en/latest/subsystems/events-system.html).

We also welcome and support contributors via [formal internship
programs](https://zulip.readthedocs.io/en/latest/outreach/overview.html), with
over 100 participants since 2016. Because of the thousands of hours our more
senior contributors (including alumni of these programs!) have dedicated to
mentorship, many of these participants have told us that they learned more
contributing to Zulip than in their 4-year formal computer science education.

## Building a sustainable business aligned with our values

Guiding the Zulip community in developing a world-class organized team chat
product with apps for every major desktop and mobile platform requires
leadership from a talented, dedicated team. We believe that the only sustainable
model is for our core team to be compensated fairly for their time. We have thus
**founded a company (Kandra Labs) to steward and financially support Zulip’s
development**.

We are **growing our business sustainably**, without venture capital funding.
VCs are incentivized to push companies to gamble for explosive growth. Often,
the result is that a company with a useful product burns rapidly through its
resources and goes out of business. We have built Zulip as a sustainable
business (also supported by [SBIR grants](https://seedfund.nsf.gov/) from the US
National Science Foundation), and are being thoughtful about our pace of
spending.

Funding our company without venture capital also allows us to **live by our
values**, without investor pressure to compromise them when doing so might be
“good business” or “what everyone does”.

Finally, **we’re building software that is easy to maintain,** so it does
not require a large team to keep the lights on. We have consistently emphasized
high standards for codebase readability, code review, commit discipline,
debuggability, automated testing, tooling, documentation, and all the other
subtle details that together determine whether software is easy to understand,
operate, and modify.


## Supporting other worthy organizations

An important part of Zulip’s mission is ensuring that worthy organizations, from
[programming-language developers](/case-studies/rust/) to [research
communities](/case-studies/lean/), are able to use Zulip whether or not they
have funding.

We sponsor [Zulip Cloud Standard](/plans/) hosting for [open-source
projects](/for/open-source/), [research groups](/for/research/),
[education](/for/education/), [non-profits](/for/communities/) and other
[communities](/for/communities/). This program has grown exponentially since its
inception; today we are proud to fully sponsor Zulip hosting for hundreds of
organizations.
