Fetch tweets from Twitter in Zulip! This is great for seeing and
discussing who is talking about you, friends, competitors, or
important topics in real time.

1.  {!create-channel.md!}

1.  {!create-an-incoming-webhook.md!}

    The API keys for "Incoming webhook" bots are limited to only
    sending messages via webhooks. Thus, this bot type lessens
    the security risks associated with exposing the bot's API
    key to third-party services.

1.  Download your new bot's `zuliprc` configuration file.

1.  {!download-python-bindings.md!}

1.  The Twitter bot should be set up on a trusted machine, because your API
    key is visible to local users through the command line or config
    file.

1.  Next, install **version 1.0 or later** of the `python-twitter`
    library. If your operating system distribution doesn’t package a new
    enough version, you can install the library from source from
    [the GitHub repository](https://github.com/bear/python-twitter).

1.  Next, set up Twitter authentication. This bot uses OAuth to
    authenticate with Twitter, and in order to obtain a consumer key &
    secret, you must register a new application under your Twitter
    account:

1.  Log in to <https://apps.twitter.com/>.

1.  Click on `Create New App` and fill out the form.

1.  Click on the application you created and click **create my access
    token**. Fill in the requested values.

1.  Create a `~/.zulip_twitterrc` with the following contents:

    ```
    [twitter]
    consumer_key =
    consumer_secret =
    access_token_key =
    access_token_secret =
    ```

1.  Place your bot's `zuliprc` in a directory of your choice (for the next step,
    `~/zuliprc` is used).

1.  Test the script by running it manually:

        /usr/local/share/zulip/integrations/twitter/twitter-bot --search="@nprnews,quantum
        physics" --config-file=~/zuliprc

        /usr/local/share/zulip/integrations/twitter/twitter-bot --twitter-name="<@your-
        twitter-handle>" --config-file=~/zuliprc

    Note: `twitter-bot` may install to a different location on
    your operating system distribution.

1.  Configure a crontab entry for this script. A sample crontab entry
    that will process tweets every minute is:

    ```
    * * * * * /usr/local/share/zulip/integrations/twitter/twitter-bot --search="@nprnews,
    quantum physics" --config-file=~/zuliprc
    ```

1.  When someone tweets a message containing one of your search terms,
    get a Zulip on your specified stream, with the search term as
    the topic.

{!congrats.md!}

![Twitter bot message](/static/images/integrations/twitter/001.png)

Note that the Twitter search bot integration **just sends links to
tweets**; the pretty inline previews of tweets are generated by the
Twitter card rendering integration configured in
`/etc/zulip/settings.py` on the Zulip server.
