# One click app release automation

This directory contains scripts for automating the release of Zulip one click apps.

## DigitalOcean 1-Click Application

`prepare_digital_ocean_one_click_app_release.py` creates the image of DigitalOcean 1-Click
app from the latest Zulip release (fetched from https://download.zulip.com/server/). It will
also create a test droplet from the image and send the image and droplet
details to a pre-configured Zulip stream. Anyone, whose key is added to the
Zulip DigitalOcean team can SSH into the droplet for testing.

### Running as GitHub action

`.github/workflows/update-oneclick-apps.yml` is configured to invoke
`prepare_digital_ocean_one_click_app_release.py` as a GitHub action during each Zulip
server release.

You also need to set the following secrets in your GitHub repository to make the action
work correctly. These secrets are passed as environment variables to the GitHub action.

- `ONE_CLICK_ACTION_DIGITALOCEAN_API_KEY` - DigitalOcean API key used for creating droplets, snapshots etc.
- `ONE_CLICK_ACTION_ZULIP_BOT_API_KEY` - The API key of the Zulip bot used for sending messages.
- `ONE_CLICK_ACTION_ZULIP_BOT_EMAIL` - The email of the Zulip bot.

Also pass the following as environment variables in `.github/workflows/update-oneclick-apps.yml`.

- `PYTHON_DIGITALOCEAN_REQUEST_TIMEOUT_SEC` - This configures the maximum number of seconds
  to wait before the requests made by `python-digitalocean` time out. If not configured, it's
  common for the requests to take 20+ minutes before getting timed out.

### Verifying the one click app image

- The action will send the image name and test droplet details to the stream configured in the
  above steps.
- SSH into the test droplet by following the instructions in the message. In order to do this,
  you need to add your SSH key to the team.
- After logging into the test droplet, exit the installer and run the following script.

  https://raw.githubusercontent.com/digitalocean/marketplace-partners/master/scripts/99-img-check.sh

  This script checks whether the image created is valid. It is also run by the DigitalOcean team
  before they approve the image submission in the one click app marketplace.

- If there are no errors (you can ignore most of the warnings), exit the SSH connection and
  reconnect.
- Populate the details asked by the installer and verify that the installer completes successfully.
  One error is expected:
  ```
  User root has a populated authorized_keys file in /root/.ssh/authorized_keys
  ```
  The key in that file will be the SSH key you've authenticated with.
  If there are other errors see the section below.
- Use the link generated by the installer to create a new Zulip organization. Do some basic
  testing like sending a bunch of messages and reloading the webpage.
- If there are no issues, submit the image in the
  [DigitalOcean vendor portal](https://marketplace.digitalocean.com/vendorportal). You need to be
  added to the vendor portal team for doing this. Ask Tim to add you if required. During the submission,
  make sure to update the blog post URL if it's a major release.
- Keep checking the vendor portal for change in status of the submission. DigitalOcean does nominally send
  emails when there are updates on the submission, but we have found the emails to not always arrive.
- If there are any issues with submission, rebuild the image by manually invoking the script and
  resubmit. The issues we have seen mostly in the past are caused by the dependencies getting outdated
  by the time the DigitalOcean team run the checks. In that case you have to just rebuild the image
  by invoking the script.
- Delete the test droplet `oneclickapp-{release_version}-test` after you have completed testing
  by going to the [DigitalOcean Zulip team account](https://cloud.digitalocean.com/droplets?i=0242e0).
  If there are other existing test droplets with the same name format but with with older release versions
  feel free to delete them as well. These droplets are also tagged with the `github-action` and `temporary`
  tags.

**Errors**

If there are any errors while setting up the one click app installer, you have three options

- Include the fix in the Fabric script that setups the installer.
  [01-initial-setup](https://raw.githubusercontent.com/zulip/marketplace-partners/master/marketplace_docs/templates/Fabric/scripts/01-initial-setup)
  file should be a good place to include the fix. See
  [zulip/marketplace-partners#4](https://github.com/zulip/marketplace-partners/pull/4/files) for an
  example fix.
- Wait for the next release to fix the error.
