"use strict";

const {strict: assert} = require("assert");

const {zrequire} = require("./lib/namespace");
const {run_test} = require("./lib/test");
const blueslip = require("./lib/zblueslip");

const {LazySet} = zrequire("lazy_set");

/*
    We mostly test LazySet indirectly.  This code
    may be short-lived, anyway, once we change
    how we download subscribers in page_params.
*/

run_test("map", () => {
    const ls = new LazySet([1, 2]);

    assert.deepEqual(
        ls.map((n) => n * 3),
        [3, 6],
    );
});

run_test("size", () => {
    const ls = new LazySet([1, 2]);
    assert.deepEqual(ls.size, 2);

    ls._make_set();
    assert.deepEqual(ls.size, 2);
});

run_test("conversions", () => {
    blueslip.expect("error", "not a number", 2);
    const ls = new LazySet([1, 2]);
    ls.add("3");
    assert.ok(ls.has("3"));
});
