# Generated by Django 1.11.4 on 2017-08-30 00:26
from django.db import migrations
from django.db.backends.base.schema import BaseDatabaseSchemaEditor
from django.db.migrations.state import StateApps

from zerver.lib.fix_unreads import fix


def fix_unreads(apps: StateApps, schema_editor: BaseDatabaseSchemaEditor) -> None:
    UserProfile = apps.get_model("zerver", "UserProfile")
    user_profiles = list(UserProfile.objects.filter(is_bot=False))
    for user_profile in user_profiles:
        fix(user_profile)


class Migration(migrations.Migration):
    dependencies = [
        ("zerver", "0103_remove_userprofile_muted_topics"),
    ]

    operations = [
        migrations.RunPython(fix_unreads, elidable=True),
    ]
