# Generated by Django 3.2.4 on 2021-07-06 20:34

from django.db import migrations, models
from django.db.backends.base.schema import BaseDatabaseSchemaEditor
from django.db.migrations.state import StateApps


def reset_realm_org_type(apps: StateApps, schema_editor: BaseDatabaseSchemaEditor) -> None:
    UNSPECIFIED = 0
    Realm = apps.get_model("zerver", "Realm")
    Realm.objects.all().update(org_type=UNSPECIFIED)


class Migration(migrations.Migration):
    dependencies = [
        ("zerver", "0332_realmuserdefault"),
    ]

    operations = [
        migrations.AlterField(
            model_name="realm",
            name="org_type",
            field=models.PositiveSmallIntegerField(
                choices=[
                    (0, "Unspecified"),
                    (10, "Business"),
                    (20, "Open-source project"),
                    (30, "Education (non-profit)"),
                    (35, "Education (for-profit)"),
                    (40, "Research"),
                    (50, "Event or conference"),
                    (60, "Non-profit (registered)"),
                    (70, "Government"),
                    (80, "Political group"),
                    (90, "Community"),
                    (100, "Personal"),
                    (1000, "Other"),
                ],
                default=0,
            ),
        ),
        migrations.RunPython(
            reset_realm_org_type, reverse_code=migrations.RunPython.noop, elidable=True
        ),
    ]
