# Generated by Django 4.0.7 on 2022-09-21 15:01

from django.db import migrations
from django.db.backends.base.schema import BaseDatabaseSchemaEditor
from django.db.migrations.state import StateApps

AWAY = 1


# Set presence_enabled to False for all users with a UserStatus.status of AWAY.
def set_presence_enabled_false_if_user_status_away(
    apps: StateApps, schema_editor: BaseDatabaseSchemaEditor
) -> None:
    UserProfile = apps.get_model("zerver", "UserProfile")
    UserProfile.objects.filter(userstatus__status=AWAY).update(presence_enabled=False)


# Set UserStatus.status to AWAY for all users with presence_enabled False.
def set_userstatus_away_if_presence_enabled_false(
    apps: StateApps, schema_editor: BaseDatabaseSchemaEditor
) -> None:
    UserStatus = apps.get_model("zerver", "UserStatus")
    UserStatus.objects.filter(user_profile__presence_enabled=False).update(status=AWAY)


class Migration(migrations.Migration):
    dependencies = [
        ("zerver", "0412_customprofilefield_display_in_profile_summary"),
    ]

    operations = [
        migrations.RunPython(
            set_presence_enabled_false_if_user_status_away,
            reverse_code=set_userstatus_away_if_presence_enabled_false,
            elidable=True,
        ),
    ]
