# Generated by Django 3.2.8 on 2021-10-27 14:25

from django.db import migrations
from django.db.backends.base.schema import BaseDatabaseSchemaEditor
from django.db.migrations.state import StateApps


def migrate_to_user_level_email_address_visibility_setting(
    apps: StateApps, schema_editor: BaseDatabaseSchemaEditor
) -> None:
    Realm = apps.get_model("zerver", "Realm")
    RealmUserDefault = apps.get_model("zerver", "RealmUserDefault")
    UserProfile = apps.get_model("zerver", "UserProfile")
    realms = Realm.objects.all()
    for realm in realms:
        # For bots, the database-level default
        # `EMAIL_ADDRESS_VISIBILITY_EVERYONE` is correct.
        UserProfile.objects.filter(realm=realm, is_bot=False).update(
            email_address_visibility=realm.email_address_visibility
        )
        RealmUserDefault.objects.filter(realm=realm).update(
            email_address_visibility=realm.email_address_visibility
        )


class Migration(migrations.Migration):
    dependencies = [
        ("zerver", "0426_add_email_address_visibility_setting"),
    ]

    operations = [
        migrations.RunPython(
            migrate_to_user_level_email_address_visibility_setting,
            reverse_code=migrations.RunPython.noop,
            elidable=True,
        ),
    ]
