# Generated by Django 4.1.6 on 2023-02-11 05:16

import django.db.models.functions.text
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("zerver", "0428_remove_realm_email_address_visibility"),
    ]

    operations = [
        migrations.AlterUniqueTogether(
            name="usertopic",
            unique_together=set(),
        ),
        # Before adding the constraint, remove any pre-existing duplicates from the table
        migrations.RunSQL(
            """
        DELETE FROM zerver_usertopic WHERE id NOT IN (SELECT max(id) FROM zerver_usertopic GROUP BY (user_profile_id, stream_id, upper(topic_name::text)));
        """
        ),
        migrations.AddConstraint(
            model_name="usertopic",
            constraint=models.UniqueConstraint(
                models.F("user_profile"),
                models.F("stream"),
                django.db.models.functions.text.Lower("topic_name"),
                name="usertopic_case_insensitive_topic_uniq",
            ),
        ),
    ]
