# Generated by Django 4.2.2 on 2023-07-11 14:04

from django.db import migrations, models
from django.db.backends.base.schema import BaseDatabaseSchemaEditor
from django.db.migrations.state import StateApps


def set_default_code_block_language_to_empty_string(
    apps: StateApps, schema_editor: BaseDatabaseSchemaEditor
) -> None:
    Realm = apps.get_model("zerver", "Realm")
    Realm.objects.filter(default_code_block_language=None).update(default_code_block_language="")


class Migration(migrations.Migration):
    dependencies = [
        ("zerver", "0460_backfill_realmauditlog_extradata_to_json_field"),
    ]

    operations = [
        # Change default value from None to empty string for new realms
        migrations.AlterField(
            model_name="realm",
            name="default_code_block_language",
            field=models.TextField(null=True, default=""),
        ),
        # Update existing realms with None to have empty string
        migrations.RunPython(
            set_default_code_block_language_to_empty_string,
            reverse_code=migrations.RunPython.noop,
            elidable=True,
        ),
        # Remove null=True for this realm field
        migrations.AlterField(
            model_name="realm",
            name="default_code_block_language",
            field=models.TextField(default=""),
        ),
    ]
