# Generated by Django 4.2.5 on 2023-09-21 14:00

from django.db import migrations
from django.db.backends.base.schema import BaseDatabaseSchemaEditor
from django.db.migrations.state import StateApps
from django.db.models import OuterRef


def set_default_value_for_can_access_all_users_group(
    apps: StateApps, schema_editor: BaseDatabaseSchemaEditor
) -> None:
    Realm = apps.get_model("zerver", "Realm")
    UserGroup = apps.get_model("zerver", "UserGroup")

    EVERYONE_GROUP_NAME = "role:everyone"

    Realm.objects.filter(can_access_all_users_group=None).update(
        can_access_all_users_group=UserGroup.objects.filter(
            name=EVERYONE_GROUP_NAME, realm=OuterRef("id"), is_system_group=True
        ).values("pk")
    )


class Migration(migrations.Migration):
    dependencies = [
        ("zerver", "0487_realm_can_access_all_users_group"),
    ]

    operations = [
        migrations.RunPython(
            set_default_value_for_can_access_all_users_group,
            elidable=True,
            reverse_code=migrations.RunPython.noop,
        ),
    ]
