# Generated by Django 4.2.10 on 2024-03-11 04:43

from django.db import connection, migrations
from django.db.backends.base.schema import BaseDatabaseSchemaEditor
from django.db.migrations.state import StateApps
from django.db.models import Q
from django.utils.timezone import now as timezone_now
from psycopg2.sql import SQL


def mark_introduce_zulip_view_modals_as_read(
    apps: StateApps, schema_editor: BaseDatabaseSchemaEditor
) -> None:
    with connection.cursor() as cursor:
        cursor.execute(
            SQL(
                "SELECT MAX(id) FROM zerver_userprofile WHERE is_bot = False AND is_mirror_dummy = False;"
            )
        )
        (max_id,) = cursor.fetchone()

    if max_id is None:
        return

    BATCH_SIZE = 10000
    lower_id_bound = 0
    timestamp_value = timezone_now()
    while lower_id_bound < max_id:
        upper_id_bound = min(lower_id_bound + BATCH_SIZE, max_id)
        with connection.cursor() as cursor:
            query = SQL("""
                INSERT INTO zerver_onboardingstep (user_id, onboarding_step, timestamp)
                SELECT id, step, %(timestamp_value)s
                FROM zerver_userprofile
                CROSS JOIN UNNEST(%(step_names)s) step
                WHERE is_bot = False
                AND is_mirror_dummy = False
                AND id > %(lower_id_bound)s AND id <= %(upper_id_bound)s;
                """)
            cursor.execute(
                query,
                {
                    "timestamp_value": timestamp_value,
                    "step_names": ["intro_inbox_view_modal", "intro_recent_view_modal"],
                    "lower_id_bound": lower_id_bound,
                    "upper_id_bound": upper_id_bound,
                },
            )

        print(f"Processed {upper_id_bound} / {max_id}")
        lower_id_bound += BATCH_SIZE


def mark_introduce_zulip_view_modals_as_unread(
    apps: StateApps, schema_editor: BaseDatabaseSchemaEditor
) -> None:
    OnboardingStep = apps.get_model("zerver", "OnboardingStep")

    OnboardingStep.objects.filter(
        Q(onboarding_step="intro_inbox_view_modal") | Q(onboarding_step="intro_recent_view_modal")
    ).delete()


class Migration(migrations.Migration):
    atomic = False
    dependencies = [
        ("zerver", "0500_realm_zulip_update_announcements_stream"),
    ]

    operations = [
        migrations.RunPython(
            mark_introduce_zulip_view_modals_as_read,
            reverse_code=mark_introduce_zulip_view_modals_as_unread,
        ),
    ]
