# Generated by Django 4.2.11 on 2024-04-05 06:09

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models
from django.db.backends.base.schema import BaseDatabaseSchemaEditor
from django.db.migrations.state import StateApps


def backfill_creator_id_from_realm_audit_log(
    apps: StateApps, schema_editor: BaseDatabaseSchemaEditor
) -> None:
    RealmAuditLog = apps.get_model("zerver", "RealmAuditLog")
    RealmAuditLog.STREAM_CREATED = 601
    Stream = apps.get_model("zerver", "Stream")

    stream_updates = []
    for audit_log_entry in RealmAuditLog.objects.select_related("modified_stream").filter(
        event_type=RealmAuditLog.STREAM_CREATED,
        acting_user_id__isnull=False,
    ):
        assert audit_log_entry.modified_stream is not None
        stream = audit_log_entry.modified_stream
        stream.creator_id = audit_log_entry.acting_user_id
        stream_updates.append(stream)

    Stream.objects.bulk_update(stream_updates, ["creator_id"], batch_size=1000)


class Migration(migrations.Migration):
    atomic = False

    dependencies = [
        ("zerver", "0510_add_realmauditlog_realm_event_type_index"),
    ]

    operations = [
        migrations.AddField(
            model_name="stream",
            name="creator",
            field=models.ForeignKey(
                null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL
            ),
        ),
        migrations.RunPython(
            backfill_creator_id_from_realm_audit_log,
            reverse_code=migrations.RunPython.noop,
            elidable=True,
        ),
    ]
