# Generated by Django 4.2.12 on 2024-04-19 03:44

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("zerver", "0511_stream_creator"),
    ]

    operations = [
        migrations.CreateModel(
            name="NamedUserGroup",
            fields=[
                (
                    "usergroup_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        related_name="named_user_group",
                        serialize=False,
                        to="zerver.usergroup",
                    ),
                ),
                ("named_group_name", models.CharField(db_column="name", max_length=100)),
                ("named_group_description", models.TextField(db_column="description", default="")),
                (
                    "named_group_is_system_group",
                    models.BooleanField(db_column="is_system_group", default=False),
                ),
                (
                    "named_group_can_mention_group",
                    models.ForeignKey(
                        db_column="can_mention_group_id",
                        on_delete=django.db.models.deletion.RESTRICT,
                        to="zerver.usergroup",
                    ),
                ),
                (
                    "realm_for_sharding",
                    models.ForeignKey(
                        db_column="realm_id",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="zerver.realm",
                    ),
                ),
            ],
            options={
                "unique_together": {("realm_for_sharding", "named_group_name")},
            },
            bases=("zerver.usergroup",),
        ),
    ]
