# Generated by Django 5.0.6 on 2024-07-17 15:10


from django.db import migrations
from django.db.backends.base.schema import BaseDatabaseSchemaEditor
from django.db.migrations.state import StateApps


def set_default_values_for_information_density_settings(
    apps: StateApps, schema_editor: BaseDatabaseSchemaEditor
) -> None:
    """Set defaults for information density settings to their intended values."""
    RealmUserDefault = apps.get_model("zerver", "RealmUserDefault")
    UserProfile = apps.get_model("zerver", "UserProfile")

    WEB_FONT_SIZE_PX_DEFAULT = 16
    WEB_LINE_HEIGHT_PERCENT_DEFAULT = 140

    RealmUserDefault.objects.update(
        dense_mode=False,
        web_font_size_px=WEB_FONT_SIZE_PX_DEFAULT,
        web_line_height_percent=WEB_LINE_HEIGHT_PERCENT_DEFAULT,
    )
    UserProfile.objects.update(
        dense_mode=False,
        web_font_size_px=WEB_FONT_SIZE_PX_DEFAULT,
        web_line_height_percent=WEB_LINE_HEIGHT_PERCENT_DEFAULT,
    )


class Migration(migrations.Migration):
    atomic = False

    dependencies = [
        ("zerver", "0556_alter_realmuserdefault_dense_mode_and_more"),
    ]

    operations = [
        migrations.RunPython(
            set_default_values_for_information_density_settings,
            elidable=True,
            reverse_code=migrations.RunPython.noop,
        ),
    ]
