<!--
Thank you for contributing to NVIDIA Warp!

See the contribution guide: https://nvidia.github.io/warp/modules/contribution_guide.html

Please fill the relevant sections.

Checkboxes can also be marked after you submit the PR.
-->

## Category
<!--
Please check all applicable options from the list below (use [x] in Markdown)
-->

- [ ] New feature
- [ ] Bugfix
- [ ] Breaking change
- [ ] Refactoring
- [ ] Documentation
- [ ] Other (please explain)

## Description
<!--
Please add a description of what this PR aims to accomplish. 
Existing issues may be reference using a special keyword, e.g. Closes #10
Include any limitations or non-handled areas in the changes.
-->

## Before your PR is "Ready for review"

- [ ] All commits are [signed-off](https://git-scm.com/docs/git-commit#Documentation/git-commit.txt--s) to indicate that your contribution adheres to the [Developer Certificate of Origin](https://developercertificate.org/) requirements
- [ ] Necessary tests have been added
- [ ] Documentation is up-to-date
- [ ] Auto-generated files modified by compiling Warp and building the documentation have been updated (e.g. `stubs.py`, `functions.rst`)
- [ ] Code passes formatting and linting checks with `pre-commit run -a`
