# SPDX-FileCopyrightText: Copyright (c) 2022 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Autogenerated file, do not edit, this file provides stubs for builtins autocomplete in VSCode, PyCharm, etc

from typing import Any
from typing import Tuple
from typing import Callable
from typing import TypeVar
from typing import Generic
from typing import overload as over

Length = TypeVar("Length", bound=int)
Rows = TypeVar("Rows", bound=int)
Cols = TypeVar("Cols", bound=int)
DType = TypeVar("DType")
Vector = Generic[Length, Scalar]
Matrix = Generic[Rows, Cols, Scalar]
Quaternion = Generic[Float]
Transformation = Generic[Float]
Array = Generic[DType]
FabricArray = Generic[DType]
IndexedFabricArray = Generic[DType]


from warp.types import array, array1d, array2d, array3d, array4d, constant, from_ptr
from warp.types import indexedarray, indexedarray1d, indexedarray2d, indexedarray3d, indexedarray4d
from warp.fabric import fabricarray, fabricarrayarray, indexedfabricarray, indexedfabricarrayarray

from warp.types import bool, int8, uint8, int16, uint16, int32, uint32, int64, uint64, float16, float32, float64
from warp.types import vec2, vec2b, vec2ub, vec2s, vec2us, vec2i, vec2ui, vec2l, vec2ul, vec2h, vec2f, vec2d
from warp.types import vec3, vec3b, vec3ub, vec3s, vec3us, vec3i, vec3ui, vec3l, vec3ul, vec3h, vec3f, vec3d
from warp.types import vec4, vec4b, vec4ub, vec4s, vec4us, vec4i, vec4ui, vec4l, vec4ul, vec4h, vec4f, vec4d
from warp.types import mat22, mat22h, mat22f, mat22d
from warp.types import mat33, mat33h, mat33f, mat33d
from warp.types import mat44, mat44h, mat44f, mat44d
from warp.types import quat, quath, quatf, quatd
from warp.types import transform, transformh, transformf, transformd
from warp.types import spatial_vector, spatial_vectorh, spatial_vectorf, spatial_vectord
from warp.types import spatial_matrix, spatial_matrixh, spatial_matrixf, spatial_matrixd

from warp.types import Int, Float, Scalar

from warp.types import Bvh, Mesh, HashGrid, Volume, MarchingCubes
from warp.types import BvhQuery, HashGridQuery, MeshQueryAABB, MeshQueryPoint, MeshQueryRay

from warp.types import matmul, adj_matmul, batched_matmul, adj_batched_matmul

from warp.types import vector as vec
from warp.types import matrix as mat

from warp.types import dtype_from_numpy, dtype_to_numpy

from warp.types import from_ipc_handle

from warp.context import init, func, func_grad, func_replay, func_native, kernel, struct, overload
from warp.context import is_cpu_available, is_cuda_available, is_device_available
from warp.context import get_devices, get_preferred_device
from warp.context import get_cuda_devices, get_cuda_device_count, get_cuda_device, map_cuda_device, unmap_cuda_device
from warp.context import get_device, set_device, synchronize_device
from warp.context import (
    zeros,
    zeros_like,
    ones,
    ones_like,
    full,
    full_like,
    clone,
    empty,
    empty_like,
    copy,
    from_numpy,
    launch,
    launch_tiled,
    synchronize,
    force_load,
    load_module,
    event_from_ipc_handle,
)
from warp.context import set_module_options, get_module_options, get_module
from warp.context import capture_begin, capture_end, capture_launch
from warp.context import Kernel, Function, Launch
from warp.context import Stream, get_stream, set_stream, wait_stream, synchronize_stream
from warp.context import Event, record_event, wait_event, synchronize_event, get_event_elapsed_time
from warp.context import RegisteredGLBuffer
from warp.context import is_mempool_supported, is_mempool_enabled, set_mempool_enabled
from warp.context import (
    set_mempool_release_threshold,
    get_mempool_release_threshold,
    get_mempool_used_mem_current,
    get_mempool_used_mem_high,
)
from warp.context import is_mempool_access_supported, is_mempool_access_enabled, set_mempool_access_enabled
from warp.context import is_peer_access_supported, is_peer_access_enabled, set_peer_access_enabled

from warp.tape import Tape
from warp.utils import ScopedTimer, ScopedDevice, ScopedStream
from warp.utils import ScopedMempool, ScopedMempoolAccess, ScopedPeerAccess
from warp.utils import ScopedCapture
from warp.utils import transform_expand, quat_between_vectors
from warp.utils import TimingResult, timing_begin, timing_end, timing_print
from warp.utils import (
    TIMING_KERNEL,
    TIMING_KERNEL_BUILTIN,
    TIMING_MEMCPY,
    TIMING_MEMSET,
    TIMING_GRAPH,
    TIMING_ALL,
)

from warp.torch import from_torch, to_torch
from warp.torch import dtype_from_torch, dtype_to_torch
from warp.torch import device_from_torch, device_to_torch
from warp.torch import stream_from_torch, stream_to_torch

from warp.jax import from_jax, to_jax
from warp.jax import dtype_from_jax, dtype_to_jax
from warp.jax import device_from_jax, device_to_jax

from warp.dlpack import from_dlpack, to_dlpack

from warp.paddle import from_paddle, to_paddle
from warp.paddle import dtype_from_paddle, dtype_to_paddle
from warp.paddle import device_from_paddle, device_to_paddle
from warp.paddle import stream_from_paddle

from warp.build import clear_kernel_cache
from warp.build import clear_lto_cache

from warp.constants import *

from . import builtins
from warp.builtins import static

from warp.math import *

import warp.config as config

__version__ = config.version


@over
def min(a: Scalar, b: Scalar) -> Scalar:
    """Return the minimum of two scalars."""
    ...


@over
def min(a: Vector[Any, Scalar], b: Vector[Any, Scalar]) -> Vector[Any, Scalar]:
    """Return the element-wise minimum of two vectors."""
    ...


@over
def min(a: Vector[Any, Scalar]) -> Scalar:
    """Return the minimum element of a vector ``a``."""
    ...


@over
def max(a: Scalar, b: Scalar) -> Scalar:
    """Return the maximum of two scalars."""
    ...


@over
def max(a: Vector[Any, Scalar], b: Vector[Any, Scalar]) -> Vector[Any, Scalar]:
    """Return the element-wise maximum of two vectors."""
    ...


@over
def max(a: Vector[Any, Scalar]) -> Scalar:
    """Return the maximum element of a vector ``a``."""
    ...


@over
def clamp(x: Scalar, low: Scalar, high: Scalar) -> Scalar:
    """Clamp the value of ``x`` to the range [low, high]."""
    ...


@over
def abs(x: Scalar) -> Scalar:
    """Return the absolute value of ``x``."""
    ...


@over
def abs(x: Vector[Any, Scalar]) -> Vector[Any, Scalar]:
    """Return the absolute values of the elements of ``x``."""
    ...


@over
def sign(x: Scalar) -> Scalar:
    """Return -1 if ``x`` < 0, return 1 otherwise."""
    ...


@over
def sign(x: Vector[Any, Scalar]) -> Scalar:
    """Return -1 for the negative elements of ``x``, and 1 otherwise."""
    ...


@over
def step(x: Scalar) -> Scalar:
    """Return 1.0 if ``x`` < 0.0, return 0.0 otherwise."""
    ...


@over
def nonzero(x: Scalar) -> Scalar:
    """Return 1.0 if ``x`` is not equal to zero, return 0.0 otherwise."""
    ...


@over
def sin(x: Float) -> Float:
    """Return the sine of ``x`` in radians."""
    ...


@over
def cos(x: Float) -> Float:
    """Return the cosine of ``x`` in radians."""
    ...


@over
def acos(x: Float) -> Float:
    """Return arccos of ``x`` in radians. Inputs are automatically clamped to [-1.0, 1.0]."""
    ...


@over
def asin(x: Float) -> Float:
    """Return arcsin of ``x`` in radians. Inputs are automatically clamped to [-1.0, 1.0]."""
    ...


@over
def sqrt(x: Float) -> Float:
    """Return the square root of ``x``, where ``x`` is positive."""
    ...


@over
def cbrt(x: Float) -> Float:
    """Return the cube root of ``x``."""
    ...


@over
def tan(x: Float) -> Float:
    """Return the tangent of ``x`` in radians."""
    ...


@over
def atan(x: Float) -> Float:
    """Return the arctangent of ``x`` in radians."""
    ...


@over
def atan2(y: Float, x: Float) -> Float:
    """Return the 2-argument arctangent, atan2, of the point ``(x, y)`` in radians."""
    ...


@over
def sinh(x: Float) -> Float:
    """Return the sinh of ``x``."""
    ...


@over
def cosh(x: Float) -> Float:
    """Return the cosh of ``x``."""
    ...


@over
def tanh(x: Float) -> Float:
    """Return the tanh of ``x``."""
    ...


@over
def degrees(x: Float) -> Float:
    """Convert ``x`` from radians into degrees."""
    ...


@over
def radians(x: Float) -> Float:
    """Convert ``x`` from degrees into radians."""
    ...


@over
def log(x: Float) -> Float:
    """Return the natural logarithm (base-e) of ``x``, where ``x`` is positive."""
    ...


@over
def log2(x: Float) -> Float:
    """Return the binary logarithm (base-2) of ``x``, where ``x`` is positive."""
    ...


@over
def log10(x: Float) -> Float:
    """Return the common logarithm (base-10) of ``x``, where ``x`` is positive."""
    ...


@over
def exp(x: Float) -> Float:
    """Return the value of the exponential function :math:`e^x`."""
    ...


@over
def pow(x: Float, y: Float) -> Float:
    """Return the result of ``x`` raised to power of ``y``."""
    ...


@over
def round(x: Float) -> Float:
    """Return the nearest integer value to ``x``, rounding halfway cases away from zero.

    This is the most intuitive form of rounding in the colloquial sense, but can be slower than other options like :func:`warp.rint()`.
    Differs from :func:`numpy.round()`, which behaves the same way as :func:`numpy.rint()`.
    """
    ...


@over
def rint(x: Float) -> Float:
    """Return the nearest integer value to ``x``, rounding halfway cases to nearest even integer.

    It is generally faster than :func:`warp.round()`. Equivalent to :func:`numpy.rint()`.
    """
    ...


@over
def trunc(x: Float) -> Float:
    """Return the nearest integer that is closer to zero than ``x``.

    In other words, it discards the fractional part of ``x``.
    It is similar to casting ``float(int(a))``, but preserves the negative sign when ``x`` is in the range [-0.0, -1.0).
    Equivalent to :func:`numpy.trunc()` and :func:`numpy.fix()`.
    """
    ...


@over
def floor(x: Float) -> Float:
    """Return the largest integer that is less than or equal to ``x``."""
    ...


@over
def ceil(x: Float) -> Float:
    """Return the smallest integer that is greater than or equal to ``x``."""
    ...


@over
def frac(x: Float) -> Float:
    """Retrieve the fractional part of ``x``.

    In other words, it discards the integer part of ``x`` and is equivalent to ``x - trunc(x)``.
    """
    ...


@over
def isfinite(a: Scalar) -> bool:
    """Return ``True`` if ``a`` is a finite number, otherwise return ``False``."""
    ...


@over
def isfinite(a: Vector[Any, Scalar]) -> bool:
    """Return ``True`` if all elements of the vector ``a`` are finite, otherwise return ``False``."""
    ...


@over
def isfinite(a: Quaternion[Scalar]) -> bool:
    """Return ``True`` if all elements of the quaternion ``a`` are finite, otherwise return ``False``."""
    ...


@over
def isfinite(a: Matrix[Any, Any, Scalar]) -> bool:
    """Return ``True`` if all elements of the matrix ``a`` are finite, otherwise return ``False``."""
    ...


@over
def isnan(a: Scalar) -> bool:
    """Return ``True`` if ``a`` is NaN, otherwise return ``False``."""
    ...


@over
def isnan(a: Vector[Any, Scalar]) -> bool:
    """Return ``True`` if any element of the vector ``a`` is NaN, otherwise return ``False``."""
    ...


@over
def isnan(a: Quaternion[Scalar]) -> bool:
    """Return ``True`` if any element of the quaternion ``a`` is NaN, otherwise return ``False``."""
    ...


@over
def isnan(a: Matrix[Any, Any, Scalar]) -> bool:
    """Return ``True`` if any element of the matrix ``a`` is NaN, otherwise return ``False``."""
    ...


@over
def isinf(a: Scalar) -> bool:
    """Return ``True`` if ``a`` is positive or negative infinity, otherwise return ``False``."""
    ...


@over
def isinf(a: Vector[Any, Scalar]) -> bool:
    """Return ``True`` if any element of the vector ``a`` is positive or negative infinity, otherwise return ``False``."""
    ...


@over
def isinf(a: Quaternion[Scalar]) -> bool:
    """Return ``True`` if any element of the quaternion ``a`` is positive or negative infinity, otherwise return ``False``."""
    ...


@over
def isinf(a: Matrix[Any, Any, Scalar]) -> bool:
    """Return ``True`` if any element of the matrix ``a`` is positive or negative infinity, otherwise return ``False``."""
    ...


@over
def dot(a: Vector[Any, Scalar], b: Vector[Any, Scalar]) -> Scalar:
    """Compute the dot product between two vectors."""
    ...


@over
def dot(a: Quaternion[Float], b: Quaternion[Float]) -> Float:
    """Compute the dot product between two quaternions."""
    ...


@over
def ddot(a: Matrix[Any, Any, Scalar], b: Matrix[Any, Any, Scalar]) -> Scalar:
    """Compute the double dot product between two matrices."""
    ...


@over
def argmin(a: Vector[Any, Scalar]) -> uint32:
    """Return the index of the minimum element of a vector ``a``."""
    ...


@over
def argmax(a: Vector[Any, Scalar]) -> uint32:
    """Return the index of the maximum element of a vector ``a``."""
    ...


@over
def outer(a: Vector[Any, Scalar], b: Vector[Any, Scalar]) -> Matrix[Any, Any, Scalar]:
    """Compute the outer product ``a*b^T`` for two vectors."""
    ...


@over
def cross(a: Vector[3, Scalar], b: Vector[3, Scalar]) -> Vector[3, Scalar]:
    """Compute the cross product of two 3D vectors."""
    ...


@over
def skew(vec: Vector[3, Scalar]) -> Matrix[3, 3, Scalar]:
    """Compute the skew-symmetric 3x3 matrix for a 3D vector ``vec``."""
    ...


@over
def length(a: Vector[Any, Float]) -> Float:
    """Compute the length of a floating-point vector ``a``."""
    ...


@over
def length(a: Quaternion[Float]) -> Float:
    """Compute the length of a quaternion ``a``."""
    ...


@over
def length_sq(a: Vector[Any, Scalar]) -> Scalar:
    """Compute the squared length of a vector ``a``."""
    ...


@over
def length_sq(a: Quaternion[Scalar]) -> Scalar:
    """Compute the squared length of a quaternion ``a``."""
    ...


@over
def normalize(a: Vector[Any, Float]) -> Vector[Any, Float]:
    """Compute the normalized value of ``a``. If ``length(a)`` is 0 then the zero vector is returned."""
    ...


@over
def normalize(a: Quaternion[Float]) -> Quaternion[Float]:
    """Compute the normalized value of ``a``. If ``length(a)`` is 0, then the zero quaternion is returned."""
    ...


@over
def transpose(a: Matrix[Any, Any, Scalar]) -> Matrix[Any, Any, Scalar]:
    """Return the transpose of the matrix ``a``."""
    ...


@over
def inverse(a: Matrix[2, 2, Float]) -> Matrix[Any, Any, Float]:
    """Return the inverse of a 2x2 matrix ``a``."""
    ...


@over
def inverse(a: Matrix[3, 3, Float]) -> Matrix[Any, Any, Float]:
    """Return the inverse of a 3x3 matrix ``a``."""
    ...


@over
def inverse(a: Matrix[4, 4, Float]) -> Matrix[Any, Any, Float]:
    """Return the inverse of a 4x4 matrix ``a``."""
    ...


@over
def determinant(a: Matrix[2, 2, Float]) -> Float:
    """Return the determinant of a 2x2 matrix ``a``."""
    ...


@over
def determinant(a: Matrix[3, 3, Float]) -> Float:
    """Return the determinant of a 3x3 matrix ``a``."""
    ...


@over
def determinant(a: Matrix[4, 4, Float]) -> Float:
    """Return the determinant of a 4x4 matrix ``a``."""
    ...


@over
def trace(a: Matrix[Any, Any, Scalar]) -> Scalar:
    """Return the trace of the matrix ``a``."""
    ...


@over
def diag(vec: Vector[Any, Scalar]) -> Matrix[Any, Any, Scalar]:
    """Returns a matrix with the components of the vector ``vec`` on the diagonal."""
    ...


@over
def get_diag(mat: Matrix[Any, Any, Scalar]) -> Vector[Any, Scalar]:
    """Returns a vector containing the diagonal elements of the square matrix ``mat``."""
    ...


@over
def cw_mul(a: Vector[Any, Scalar], b: Vector[Any, Scalar]) -> Vector[Any, Scalar]:
    """Component-wise multiplication of two vectors."""
    ...


@over
def cw_mul(a: Matrix[Any, Any, Scalar], b: Matrix[Any, Any, Scalar]) -> Matrix[Any, Any, Scalar]:
    """Component-wise multiplication of two matrices."""
    ...


@over
def cw_div(a: Vector[Any, Scalar], b: Vector[Any, Scalar]) -> Vector[Any, Scalar]:
    """Component-wise division of two vectors."""
    ...


@over
def cw_div(a: Matrix[Any, Any, Scalar], b: Matrix[Any, Any, Scalar]) -> Matrix[Any, Any, Scalar]:
    """Component-wise division of two matrices."""
    ...


@over
def vector(*args: Scalar, length: int32, dtype: Scalar) -> Vector[Any, Scalar]:
    """Construct a vector of given length and dtype."""
    ...


@over
def matrix(pos: Vector[3, Float], rot: Quaternion[Float], scale: Vector[3, Float], dtype: Float) -> Matrix[4, 4, Float]:
    """Construct a 4x4 transformation matrix that applies the transformations as
    Translation(pos)*Rotation(rot)*Scaling(scale) when applied to column vectors, i.e.: y = (TRS)*x
    """
    ...


@over
def matrix(*args: Scalar, shape: Tuple[int, int], dtype: Scalar) -> Matrix[Any, Any, Scalar]:
    """Construct a matrix. If the positional ``arg_types`` are not given, then matrix will be zero-initialized."""
    ...


@over
def matrix_from_cols(*args: Vector[Any, Scalar]) -> Matrix[Any, Any, Scalar]:
    """Construct a matrix from column vectors."""
    ...


@over
def matrix_from_rows(*args: Vector[Any, Scalar]) -> Matrix[Any, Any, Scalar]:
    """Construct a matrix from row vectors."""
    ...


@over
def identity(n: int32, dtype: Scalar) -> Matrix[Any, Any, Scalar]:
    """Create an identity matrix with shape=(n,n) with the type given by ``dtype``."""
    ...


@over
def svd3(A: Matrix[3, 3, Float], U: Matrix[3, 3, Float], sigma: Vector[3, Float], V: Matrix[3, 3, Scalar]):
    """Compute the SVD of a 3x3 matrix ``A``. The singular values are returned in ``sigma``,
    while the left and right basis vectors are returned in ``U`` and ``V``.
    """
    ...


@over
def svd2(A: Matrix[2, 2, Float], U: Matrix[2, 2, Float], sigma: Vector[2, Float], V: Matrix[2, 2, Scalar]):
    """Compute the SVD of a 2x2 matrix ``A``. The singular values are returned in ``sigma``,
    while the left and right basis vectors are returned in ``U`` and ``V``.
    """
    ...


@over
def qr3(A: Matrix[3, 3, Float], Q: Matrix[3, 3, Float], R: Matrix[3, 3, Float]):
    """Compute the QR decomposition of a 3x3 matrix ``A``. The orthogonal matrix is returned in ``Q``,
    while the upper triangular matrix is returned in ``R``.
    """
    ...


@over
def eig3(A: Matrix[3, 3, Float], Q: Matrix[3, 3, Float], d: Vector[3, Float]):
    """Compute the eigendecomposition of a 3x3 matrix ``A``. The eigenvectors are returned as the columns of ``Q``,
    while the corresponding eigenvalues are returned in ``d``.
    """
    ...


@over
def quaternion(dtype: Float) -> Quaternion[Float]:
    """Construct a zero-initialized quaternion. Quaternions are laid out as
    [ix, iy, iz, r], where ix, iy, iz are the imaginary part, and r the real part.
    """
    ...


@over
def quaternion(x: Float, y: Float, z: Float, w: Float, dtype: Scalar) -> Quaternion[Float]:
    """Create a quaternion using the supplied components (type inferred from component type)."""
    ...


@over
def quaternion(ijk: Vector[3, Float], real: Float, dtype: Float) -> Quaternion[Float]:
    """Create a quaternion using the supplied vector/scalar (type inferred from scalar type)."""
    ...


@over
def quaternion(quat: Quaternion[Float], dtype: Float) -> Quaternion[Float]:
    """Construct a quaternion of type dtype from another quaternion of a different dtype."""
    ...


@over
def quat_identity(dtype: Float) -> quatf:
    """Construct an identity quaternion with zero imaginary part and real part of 1.0"""
    ...


@over
def quat_from_axis_angle(axis: Vector[3, Float], angle: Float) -> Quaternion[Float]:
    """Construct a quaternion representing a rotation of angle radians around the given axis."""
    ...


@over
def quat_to_axis_angle(quat: Quaternion[Float], axis: Vector[3, Float], angle: Float):
    """Extract the rotation axis and angle radians a quaternion represents."""
    ...


@over
def quat_from_matrix(mat: Matrix[3, 3, Float]) -> Quaternion[Float]:
    """Construct a quaternion from a 3x3 matrix.

    If the matrix is not a pure rotation, but for example includes scaling or skewing, the result is undefined.
    """
    ...


@over
def quat_from_matrix(mat: Matrix[4, 4, Float]) -> Quaternion[Float]:
    """Construct a quaternion from a 4x4 matrix.

    If the top-left 3x3 block of the matrix is not a pure rotation, but for example includes scaling or skewing, the result is undefined.
    """
    ...


@over
def quat_rpy(roll: Float, pitch: Float, yaw: Float) -> Quaternion[Float]:
    """Construct a quaternion representing a combined roll (z), pitch (x), yaw rotations (y) in radians."""
    ...


@over
def quat_inverse(quat: Quaternion[Float]) -> Quaternion[Float]:
    """Compute quaternion conjugate."""
    ...


@over
def quat_rotate(quat: Quaternion[Float], vec: Vector[3, Float]) -> Vector[3, Float]:
    """Rotate a vector by a quaternion."""
    ...


@over
def quat_rotate_inv(quat: Quaternion[Float], vec: Vector[3, Float]) -> Vector[3, Float]:
    """Rotate a vector by the inverse of a quaternion."""
    ...


@over
def quat_slerp(a: Quaternion[Float], b: Quaternion[Float], t: Float) -> Quaternion[Float]:
    """Linearly interpolate between two quaternions."""
    ...


@over
def quat_to_matrix(quat: Quaternion[Float]) -> Matrix[3, 3, Float]:
    """Convert a quaternion to a 3x3 rotation matrix."""
    ...


@over
def transformation(pos: Vector[3, Float], rot: Quaternion[Float], dtype: Float) -> Transformation[Float]:
    """Construct a rigid-body transformation with translation part ``pos`` and rotation ``rot``."""
    ...


@over
def transform_identity(dtype: Float) -> transformf:
    """Construct an identity transform with zero translation and identity rotation."""
    ...


@over
def transform_get_translation(xform: Transformation[Float]) -> Vector[3, Float]:
    """Return the translational part of a transform ``xform``."""
    ...


@over
def transform_get_rotation(xform: Transformation[Float]) -> Quaternion[Float]:
    """Return the rotational part of a transform ``xform``."""
    ...


@over
def transform_multiply(a: Transformation[Float], b: Transformation[Float]) -> Transformation[Float]:
    """Multiply two rigid body transformations together."""
    ...


@over
def transform_point(xform: Transformation[Float], point: Vector[3, Float]) -> Vector[3, Float]:
    """Apply the transform to a point ``point`` treating the homogeneous coordinate as w=1 (translation and rotation)."""
    ...


@over
def transform_point(mat: Matrix[4, 4, Float], point: Vector[3, Float]) -> Vector[3, Float]:
    """Apply the transform to a point ``point`` treating the homogeneous coordinate as w=1.

    The transformation is applied treating ``point`` as a column vector, e.g.: ``y = mat*point``.

    This is in contrast to some libraries, notably USD, which applies transforms to row vectors, ``y^T = point^T*mat^T``.
    If the transform is coming from a library that uses row-vectors, then users should transpose the transformation
    matrix before calling this method.
    """
    ...


@over
def transform_vector(xform: Transformation[Float], vec: Vector[3, Float]) -> Vector[3, Float]:
    """Apply the transform to a vector ``vec`` treating the homogeneous coordinate as w=0 (rotation only)."""
    ...


@over
def transform_vector(mat: Matrix[4, 4, Float], vec: Vector[3, Float]) -> Vector[3, Float]:
    """Apply the transform to a vector ``vec`` treating the homogeneous coordinate as w=0.

    The transformation is applied treating ``vec`` as a column vector, e.g.: ``y = mat*vec``.

    This is in contrast to some libraries, notably USD, which applies transforms to row vectors, ``y^T = vec^T*mat^T``.
    If the transform is coming from a library that uses row-vectors, then users should transpose the transformation
    matrix before calling this method.
    """
    ...


@over
def transform_inverse(xform: Transformation[Float]) -> Transformation[Float]:
    """Compute the inverse of the transformation ``xform``."""
    ...


@over
def spatial_vector(dtype: Float) -> Vector[6, Float]:
    """Zero-initialize a 6D screw vector."""
    ...


@over
def spatial_vector(w: Vector[3, Float], v: Vector[3, Float], dtype: Float) -> Vector[6, Float]:
    """Construct a 6D screw vector from two 3D vectors."""
    ...


@over
def spatial_vector(wx: Float, wy: Float, wz: Float, vx: Float, vy: Float, vz: Float, dtype: Float) -> Vector[6, Float]:
    """Construct a 6D screw vector from six values."""
    ...


@over
def spatial_adjoint(r: Matrix[3, 3, Float], s: Matrix[3, 3, Float]) -> Matrix[6, 6, Float]:
    """Construct a 6x6 spatial inertial matrix from two 3x3 diagonal blocks."""
    ...


@over
def spatial_dot(a: Vector[6, Float], b: Vector[6, Float]) -> Float:
    """Compute the dot product of two 6D screw vectors."""
    ...


@over
def spatial_cross(a: Vector[6, Float], b: Vector[6, Float]) -> Vector[6, Float]:
    """Compute the cross product of two 6D screw vectors."""
    ...


@over
def spatial_cross_dual(a: Vector[6, Float], b: Vector[6, Float]) -> Vector[6, Float]:
    """Compute the dual cross product of two 6D screw vectors."""
    ...


@over
def spatial_top(svec: Vector[6, Float]) -> Vector[3, Float]:
    """Return the top (first) part of a 6D screw vector."""
    ...


@over
def spatial_bottom(svec: Vector[6, Float]) -> Vector[3, Float]:
    """Return the bottom (second) part of a 6D screw vector."""
    ...


@over
def spatial_jacobian(
    S: Array[Vector[6, Float]],
    joint_parents: Array[int32],
    joint_qd_start: Array[int32],
    joint_start: int32,
    joint_count: int32,
    J_start: int32,
    J_out: Array[Float],
):
    """ """
    ...


@over
def spatial_mass(
    I_s: Array[Matrix[6, 6, Float]], joint_start: int32, joint_count: int32, M_start: int32, M: Array[Float]
):
    """ """
    ...


@over
def tile_zeros(shape: Tuple[int, ...], dtype: Any, storage: str) -> Tile:
    """Allocate a tile of zero-initialized items.

    :param shape: Shape of the output tile
    :param dtype: Data type of output tile's elements (default float)
    :param storage: The storage location for the tile: ``"register"`` for registers
      (default) or ``"shared"`` for shared memory.
    :returns: A zero-initialized tile with shape and data type as specified
    """
    ...


@over
def tile_ones(shape: Tuple[int, ...], dtype: Any, storage: str) -> Tile:
    """Allocate a tile of one-initialized items.

    :param shape: Shape of the output tile
    :param dtype: Data type of output tile's elements
    :param storage: The storage location for the tile: ``"register"`` for registers
      (default) or ``"shared"`` for shared memory.
    :returns: A one-initialized tile with shape and data type as specified
    """
    ...


@over
def tile_arange(*args: Scalar, dtype: Any, storage: str) -> Tile:
    """Generate a tile of linearly spaced elements.

    :param args: Variable-length positional arguments, interpreted as:

        - ``(stop,)``: Generates values from ``0`` to ``stop - 1``
        - ``(start, stop)``: Generates values from ``start`` to ``stop - 1``
        - ``(start, stop, step)``: Generates values from ``start`` to ``stop - 1`` with a step size

    :param dtype: Data type of output tile's elements (optional, default: ``float``)
    :param storage: The storage location for the tile: ``"register"`` for registers
      (default) or ``"shared"`` for shared memory.
    :returns: A tile with ``shape=(n)`` with linearly spaced elements of specified data type
    """
    ...


@over
def tile_load(a: Array[Any], shape: Tuple[int, ...], offset: Tuple[int, ...], storage: str):
    """Loads a tile from a global memory array.

    This method will cooperatively load a tile from global memory using all threads in the block.

    :param a: The source array in global memory
    :param shape: Shape of the tile to load, must have the same number of dimensions as ``a``
    :param offset: Offset in the source array to begin reading from (optional)
    :param storage: The storage location for the tile: ``"register"`` for registers
      (default) or ``"shared"`` for shared memory.
    :returns: A tile with shape as specified and data type the same as the source array
    """
    ...


@over
def tile_store(a: Array[Any], t: Tile, offset: Tuple[int, ...]):
    """Store a tile to a global memory array.

    This method will cooperatively store a tile to global memory using all threads in the block.

    :param a: The destination array in global memory
    :param t: The source tile to store data from, must have the same data type and number of dimensions as the destination array
    :param offset: Offset in the destination array (optional)
    """
    ...


@over
def tile_atomic_add(a: Array[Any], t: Tile, offset: Tuple[int, ...]) -> Tile:
    """Atomically add a 1D tile to the array `a`, each element will be updated atomically.

    :param a: Array in global memory, should have the same ``dtype`` as the input tile
    :param t: Source tile to add to the destination array
    :param offset: Offset in the destination array (optional)
    :returns: A tile with the same dimensions and data type as the source tile, holding the original value of the destination elements
    """
    ...


@over
def tile_view(t: Tile, offset: Tuple[int, ...], shape: Tuple[int, ...]) -> Tile:
    """Return a slice of a given tile [offset, offset+shape], if shape is not specified it will be inferred from the unspecified offset dimensions.

    :param t: Input tile to extract a subrange from
    :param offset: Offset in the source tile
    :param shape: Shape of the returned slice
    :returns: A tile with dimensions given by the specified shape or the remaining source tile dimensions
    """
    ...


@over
def tile_assign(dst: Tile, src: Tile, offset: Tuple[int, ...]):
    """Assign a tile to a subrange of a destination tile.

    :param dst: The destination tile to assign to
    :param src: The source tile to read values from
    :param offset: Offset in the destination tile to write to
    """
    ...


@over
def tile(x: Any) -> Tile:
    """Construct a new tile from per-thread kernel values.

    This function converts values computed using scalar kernel code to a tile representation for input into collective operations.

    * If the input value is a scalar, then the resulting tile has ``shape=(block_dim,)``
    * If the input value is a vector, then the resulting tile has ``shape=(length(vector), block_dim)``

    :param x: A per-thread local value, e.g. scalar, vector, or matrix.
    :returns: A tile with first dimension according to the value type length and a second dimension equal to ``block_dim``

    This example shows how to create a linear sequence from thread variables:

    .. code-block:: python

        @wp.kernel
        def compute():
            i = wp.tid()
            t = wp.tile(i * 2)
            print(t)


        wp.launch(compute, dim=16, inputs=[], block_dim=16)

    Prints:

    .. code-block:: text

        [0 2 4 6 8 10 12 14 16 18 20 22 24 26 28 30] = tile(shape=(16), storage=register)


    """
    ...


@over
def untile(a: Tile) -> Scalar:
    """Convert a tile back to per-thread values.

    This function converts a block-wide tile back to per-thread values.

    * If the input tile is 1D, then the resulting value will be a per-thread scalar
    * If the input tile is 2D, then the resulting value will be a per-thread vector of length M

    :param a: A tile with dimensions ``shape=(M, block_dim)``
    :returns: A single value per-thread with the same data type as the tile

    This example shows how to create a linear sequence from thread variables:

    .. code-block:: python

        @wp.kernel
        def compute():
            i = wp.tid()

            # create block-wide tile
            t = wp.tile(i) * 2

            # convert back to per-thread values
            s = wp.untile(t)

            print(s)


        wp.launch(compute, dim=16, inputs=[], block_dim=16)

    Prints:

    .. code-block:: text

        0
        2
        4
        6
        8
        ...

    """
    ...


@over
def tile_transpose(a: Tile) -> Tile:
    """Transpose a tile.

    For shared memory tiles, this operation will alias the input tile.
    Register tiles will first be transferred to shared memory before transposition.

    :param a: Tile to transpose with ``shape=(M,N)``
    :returns: Tile with ``shape=(N,M)``
    """
    ...


@over
def tile_broadcast(a: Tile, shape: Tuple[int, ...]) -> Tile:
    """Broadcast a tile.

    Broadcasts the input tile ``a`` to the destination shape.
    Broadcasting follows NumPy broadcast rules.

    :param a: Tile to broadcast
    :param shape: The shape to broadcast to
    :returns: Tile with broadcast shape
    """
    ...


@over
def tile_sum(a: Tile) -> Tile:
    """Cooperatively compute the sum of the tile elements using all threads in the block.

    :param a: The tile to compute the sum of
    :returns: A single-element tile holding the sum

    Example:

    .. code-block:: python

        @wp.kernel
        def compute():
            t = wp.tile_ones(dtype=float, shape=(16, 16))
            s = wp.tile_sum(t)

            print(s)


        wp.launch_tiled(compute, dim=[1], inputs=[], block_dim=64)

    Prints:

    .. code-block:: text

        [256] = tile(shape=(1), storage=register)


    """
    ...


@over
def tile_min(a: Tile) -> Tile:
    """Cooperatively compute the minimum of the tile elements using all threads in the block.

    :param a: The tile to compute the minimum of
    :returns: A single-element tile holding the minimum value

    Example:

    .. code-block:: python

        @wp.kernel
        def compute():
            t = wp.tile_arange(64, 128)
            s = wp.tile_min(t)

            print(s)


        wp.launch_tiled(compute, dim=[1], inputs=[], block_dim=64)

    Prints:

    .. code-block:: text

        [64] = tile(shape=(1), storage=register)


    """
    ...


@over
def tile_max(a: Tile) -> Tile:
    """Cooperatively compute the maximum of the tile elements using all threads in the block.

    :param a: The tile to compute the maximum from
    :returns: A single-element tile holding the maximum value

    Example:

    .. code-block:: python

        @wp.kernel
        def compute():
            t = wp.tile_arange(64, 128)
            s = wp.tile_max(t)

            print(s)


        wp.launch_tiled(compute, dim=[1], inputs=[], block_dim=64)

    Prints:

    .. code-block:: text

        [127] = tile(shape=(1), storage=register)


    """
    ...


@over
def tile_reduce(op: Callable, a: Tile) -> Tile:
    """Apply a custom reduction operator across the tile.

    This function cooperatively performs a reduction using the provided operator across the tile.

    :param op: A callable function that accepts two arguments and returns one argument, may be a user function or builtin
    :param a: The input tile, the operator (or one of its overloads) must be able to accept the tile's data type
    :returns: A single-element tile with the same data type as the input tile.

    Example:

    .. code-block:: python

        @wp.kernel
        def factorial():
            t = wp.tile_arange(1, 10, dtype=int)
            s = wp.tile_reduce(wp.mul, t)

            print(s)


        wp.launch_tiled(factorial, dim=[1], inputs=[], block_dim=16)

    Prints:

    .. code-block:: text

        [362880] = tile(shape=(1), storage=register)

    """
    ...


@over
def tile_map(op: Callable, a: Tile) -> Tile:
    """Apply a unary function onto the tile.

    This function cooperatively applies a unary function to each element of the tile using all threads in the block.

    :param op: A callable function that accepts one argument and returns one argument, may be a user function or builtin
    :param a: The input tile, the operator (or one of its overloads) must be able to accept the tile's data type
    :returns: A tile with the same dimensions and data type as the input tile.

    Example:

    .. code-block:: python

        @wp.kernel
        def compute():
            t = wp.tile_arange(0.0, 1.0, 0.1, dtype=float)
            s = wp.tile_map(wp.sin, t)

            print(s)


        wp.launch_tiled(compute, dim=[1], inputs=[], block_dim=16)

    Prints:

    .. code-block:: text

        [0 0.0998334 0.198669 0.29552 0.389418 0.479426 0.564642 0.644218 0.717356 0.783327] = tile(shape=(10), storage=register)

    """
    ...


@over
def tile_map(op: Callable, a: Tile, b: Tile) -> Tile:
    """Apply a binary function onto the tile.

    This function cooperatively applies a binary function to each element of the tiles using all threads in the block.
    Both input tiles must have the same dimensions and datatype.

    :param op: A callable function that accepts two arguments and returns one argument, all of the same type, may be a user function or builtin
    :param a: The first input tile, the operator (or one of its overloads) must be able to accept the tile's dtype
    :param b: The second input tile, the operator (or one of its overloads) must be able to accept the tile's dtype
    :returns: A tile with the same dimensions and datatype as the input tiles.

    Example:

    .. code-block:: python

        @wp.kernel
        def compute():
            a = wp.tile_arange(0.0, 1.0, 0.1, dtype=float)
            b = wp.tile_ones(shape=10, dtype=float)

            s = wp.tile_map(wp.add, a, b)

            print(s)


        wp.launch_tiled(compute, dim=[1], inputs=[], block_dim=16)

    Prints:

    .. code-block:: text

        [1 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9] = tile(shape=(10), storage=register)
    """
    ...


@over
def mlp(
    weights: Array[float32],
    bias: Array[float32],
    activation: Callable,
    index: int32,
    x: Array[float32],
    out: Array[float32],
):
    """Evaluate a multi-layer perceptron (MLP) layer in the form: ``out = act(weights*x + bias)``.

    .. deprecated:: 1.6
        Use :doc:`tile primitives </modules/tiles>` instead.

    :param weights: A layer's network weights with dimensions ``(m, n)``.
    :param bias: An array with dimensions ``(n)``.
    :param activation: A ``wp.func`` function that takes a single scalar float as input and returns a scalar float as output
    :param index: The batch item to process, typically each thread will process one item in the batch, in which case
                  index should be ``wp.tid()``
    :param x: The feature matrix with dimensions ``(n, b)``
    :param out: The network output with dimensions ``(m, b)``

    :note: Feature and output matrices are transposed compared to some other frameworks such as PyTorch.
           All matrices are assumed to be stored in flattened row-major memory layout (NumPy default).
    """
    ...


@over
def bvh_query_aabb(id: uint64, low: vec3f, high: vec3f) -> bvh_query_t:
    """Construct an axis-aligned bounding box query against a BVH object.

    This query can be used to iterate over all bounds inside a BVH.

    :param id: The BVH identifier
    :param low: The lower bound of the bounding box in BVH space
    :param high: The upper bound of the bounding box in BVH space
    """
    ...


@over
def bvh_query_ray(id: uint64, start: vec3f, dir: vec3f) -> bvh_query_t:
    """Construct a ray query against a BVH object.

    This query can be used to iterate over all bounds that intersect the ray.

    :param id: The BVH identifier
    :param start: The start of the ray in BVH space
    :param dir: The direction of the ray in BVH space
    """
    ...


@over
def bvh_query_next(query: bvh_query_t, index: int32) -> bool:
    """Move to the next bound returned by the query.
    The index of the current bound is stored in ``index``, returns ``False`` if there are no more overlapping bound.
    """
    ...


@over
def mesh_query_point(id: uint64, point: vec3f, max_dist: float32) -> mesh_query_point_t:
    """Computes the closest point on the :class:`Mesh` with identifier ``id`` to the given ``point`` in space.

    Identifies the sign of the distance using additional ray-casts to determine if the point is inside or outside.
    This method is relatively robust, but does increase computational cost.
    See below for additional sign determination methods.

    :param id: The mesh identifier
    :param point: The point in space to query
    :param max_dist: Mesh faces above this distance will not be considered by the query
    """
    ...


@over
def mesh_query_point_no_sign(id: uint64, point: vec3f, max_dist: float32) -> mesh_query_point_t:
    """Computes the closest point on the :class:`Mesh` with identifier ``id`` to the given ``point`` in space.

    This method does not compute the sign of the point (inside/outside) which makes it faster than other point query methods.

    :param id: The mesh identifier
    :param point: The point in space to query
    :param max_dist: Mesh faces above this distance will not be considered by the query
    """
    ...


@over
def mesh_query_furthest_point_no_sign(id: uint64, point: vec3f, min_dist: float32) -> mesh_query_point_t:
    """Computes the furthest point on the mesh with identifier `id` to the given point in space.

    This method does not compute the sign of the point (inside/outside).

    :param id: The mesh identifier
    :param point: The point in space to query
    :param min_dist: Mesh faces below this distance will not be considered by the query
    """
    ...


@over
def mesh_query_point_sign_normal(id: uint64, point: vec3f, max_dist: float32, epsilon: float32) -> mesh_query_point_t:
    """Computes the closest point on the :class:`Mesh` with identifier ``id`` to the given ``point`` in space.

    Identifies the sign of the distance (inside/outside) using the angle-weighted pseudo normal.
    This approach to sign determination is robust for well conditioned meshes that are watertight and non-self intersecting.
    It is also comparatively fast to compute.

    :param id: The mesh identifier
    :param point: The point in space to query
    :param max_dist: Mesh faces above this distance will not be considered by the query
    :param epsilon: Epsilon treating distance values as equal, when locating the minimum distance vertex/face/edge, as a
                    fraction of the average edge length, also for treating closest point as being on edge/vertex default 1e-3
    """
    ...


@over
def mesh_query_point_sign_winding_number(
    id: uint64, point: vec3f, max_dist: float32, accuracy: float32, threshold: float32
) -> mesh_query_point_t:
    """Computes the closest point on the :class:`Mesh` with identifier ``id`` to the given point in space.

    Identifies the sign using the winding number of the mesh relative to the query point. This method of sign determination is robust for poorly conditioned meshes
    and provides a smooth approximation to sign even when the mesh is not watertight. This method is the most robust and accurate of the sign determination meshes
    but also the most expensive.

    .. note:: The :class:`Mesh` object must be constructed with ``support_winding_number=True`` for this method to return correct results.

    :param id: The mesh identifier
    :param point: The point in space to query
    :param max_dist: Mesh faces above this distance will not be considered by the query
    :param accuracy: Accuracy for computing the winding number with fast winding number method utilizing second-order dipole approximation, default 2.0
    :param threshold: The threshold of the winding number to be considered inside, default 0.5
    """
    ...


@over
def mesh_query_ray(id: uint64, start: vec3f, dir: vec3f, max_t: float32) -> mesh_query_ray_t:
    """Computes the closest ray hit on the :class:`Mesh` with identifier ``id``.

    :param id: The mesh identifier
    :param start: The start point of the ray
    :param dir: The ray direction (should be normalized)
    :param max_t: The maximum distance along the ray to check for intersections
    """
    ...


@over
def mesh_query_aabb(id: uint64, low: vec3f, high: vec3f) -> mesh_query_aabb_t:
    """Construct an axis-aligned bounding box query against a :class:`Mesh`.

    This query can be used to iterate over all triangles inside a volume.

    :param id: The mesh identifier
    :param low: The lower bound of the bounding box in mesh space
    :param high: The upper bound of the bounding box in mesh space
    """
    ...


@over
def mesh_query_aabb_next(query: mesh_query_aabb_t, index: int32) -> bool:
    """Move to the next triangle overlapping the query bounding box.

    The index of the current face is stored in ``index``, returns ``False`` if there are no more overlapping triangles.
    """
    ...


@over
def mesh_eval_position(id: uint64, face: int32, bary_u: float32, bary_v: float32) -> vec3f:
    """Evaluates the position on the :class:`Mesh` given a face index and barycentric coordinates."""
    ...


@over
def mesh_eval_velocity(id: uint64, face: int32, bary_u: float32, bary_v: float32) -> vec3f:
    """Evaluates the velocity on the :class:`Mesh` given a face index and barycentric coordinates."""
    ...


@over
def hash_grid_query(id: uint64, point: vec3f, max_dist: float32) -> hash_grid_query_t:
    """Construct a point query against a :class:`HashGrid`.

    This query can be used to iterate over all neighboring point within a fixed radius from the query point.
    """
    ...


@over
def hash_grid_query_next(query: hash_grid_query_t, index: int32) -> bool:
    """Move to the next point in the hash grid query.

    The index of the current neighbor is stored in ``index``, returns ``False`` if there are no more neighbors.
    """
    ...


@over
def hash_grid_point_id(id: uint64, index: int32) -> int:
    """Return the index of a point in the :class:`HashGrid`.

    This can be used to reorder threads such that grid traversal occurs in a spatially coherent order.

    Returns -1 if the :class:`HashGrid` has not been reserved.
    """
    ...


@over
def intersect_tri_tri(v0: vec3f, v1: vec3f, v2: vec3f, u0: vec3f, u1: vec3f, u2: vec3f) -> int:
    """Tests for intersection between two triangles (v0, v1, v2) and (u0, u1, u2) using Moller's method.

    Returns > 0 if triangles intersect.
    """
    ...


@over
def mesh_get(id: uint64) -> Mesh:
    """Retrieves the mesh given its index."""
    ...


@over
def mesh_eval_face_normal(id: uint64, face: int32) -> vec3f:
    """Evaluates the face normal the mesh given a face index."""
    ...


@over
def mesh_get_point(id: uint64, index: int32) -> vec3f:
    """Returns the point of the mesh given a index."""
    ...


@over
def mesh_get_velocity(id: uint64, index: int32) -> vec3f:
    """Returns the velocity of the mesh given a index."""
    ...


@over
def mesh_get_index(id: uint64, index: int32) -> int:
    """Returns the point-index of the mesh given a face-vertex index."""
    ...


@over
def closest_point_edge_edge(p1: vec3f, q1: vec3f, p2: vec3f, q2: vec3f, epsilon: float32) -> vec3f:
    """Finds the closest points between two edges.

    Returns barycentric weights to the points on each edge, as well as the closest distance between the edges.

    :param p1: First point of first edge
    :param q1: Second point of first edge
    :param p2: First point of second edge
    :param q2: Second point of second edge
    :param epsilon: Zero tolerance for determining if points in an edge are degenerate.
    :param out: vec3 output containing (s,t,d), where `s` in [0,1] is the barycentric weight for the first edge, `t` is the barycentric weight for the second edge, and `d` is the distance between the two edges at these two closest points.
    """
    ...


@over
def reversed(range: range_t) -> range_t:
    """Returns the range in reversed order."""
    ...


@over
def volume_sample(id: uint64, uvw: vec3f, sampling_mode: int32, dtype: Any) -> Any:
    """Sample the volume of type `dtype` given by ``id`` at the volume local-space point ``uvw``.

    Interpolation should be :attr:`warp.Volume.CLOSEST` or :attr:`wp.Volume.LINEAR.`
    """
    ...


@over
def volume_sample_grad(id: uint64, uvw: vec3f, sampling_mode: int32, grad: Any, dtype: Any) -> Any:
    """Sample the volume given by ``id`` and its gradient at the volume local-space point ``uvw``.

    Interpolation should be :attr:`warp.Volume.CLOSEST` or :attr:`wp.Volume.LINEAR.`
    """
    ...


@over
def volume_lookup(id: uint64, i: int32, j: int32, k: int32, dtype: Any) -> Any:
    """Returns the value of voxel with coordinates ``i``, ``j``, ``k`` for a volume of type type `dtype`.

    If the voxel at this index does not exist, this function returns the background value.
    """
    ...


@over
def volume_store(id: uint64, i: int32, j: int32, k: int32, value: Any):
    """Store ``value`` at the voxel with coordinates ``i``, ``j``, ``k``."""
    ...


@over
def volume_sample_f(id: uint64, uvw: vec3f, sampling_mode: int32) -> float:
    """Sample the volume given by ``id`` at the volume local-space point ``uvw``.

    Interpolation should be :attr:`warp.Volume.CLOSEST` or :attr:`wp.Volume.LINEAR.`
    """
    ...


@over
def volume_sample_grad_f(id: uint64, uvw: vec3f, sampling_mode: int32, grad: vec3f) -> float:
    """Sample the volume and its gradient given by ``id`` at the volume local-space point ``uvw``.

    Interpolation should be :attr:`warp.Volume.CLOSEST` or :attr:`wp.Volume.LINEAR.`
    """
    ...


@over
def volume_lookup_f(id: uint64, i: int32, j: int32, k: int32) -> float:
    """Returns the value of voxel with coordinates ``i``, ``j``, ``k``.

    If the voxel at this index does not exist, this function returns the background value
    """
    ...


@over
def volume_store_f(id: uint64, i: int32, j: int32, k: int32, value: float32):
    """Store ``value`` at the voxel with coordinates ``i``, ``j``, ``k``."""
    ...


@over
def volume_sample_v(id: uint64, uvw: vec3f, sampling_mode: int32) -> vec3f:
    """Sample the vector volume given by ``id`` at the volume local-space point ``uvw``.

    Interpolation should be :attr:`warp.Volume.CLOSEST` or :attr:`wp.Volume.LINEAR.`
    """
    ...


@over
def volume_lookup_v(id: uint64, i: int32, j: int32, k: int32) -> vec3f:
    """Returns the vector value of voxel with coordinates ``i``, ``j``, ``k``.

    If the voxel at this index does not exist, this function returns the background value.
    """
    ...


@over
def volume_store_v(id: uint64, i: int32, j: int32, k: int32, value: vec3f):
    """Store ``value`` at the voxel with coordinates ``i``, ``j``, ``k``."""
    ...


@over
def volume_sample_i(id: uint64, uvw: vec3f) -> int:
    """Sample the :class:`int32` volume given by ``id`` at the volume local-space point ``uvw``."""
    ...


@over
def volume_lookup_i(id: uint64, i: int32, j: int32, k: int32) -> int:
    """Returns the :class:`int32` value of voxel with coordinates ``i``, ``j``, ``k``.

    If the voxel at this index does not exist, this function returns the background value.
    """
    ...


@over
def volume_store_i(id: uint64, i: int32, j: int32, k: int32, value: int32):
    """Store ``value`` at the voxel with coordinates ``i``, ``j``, ``k``."""
    ...


@over
def volume_sample_index(id: uint64, uvw: vec3f, sampling_mode: int32, voxel_data: Array[Any], background: Any) -> Any:
    """Sample the volume given by ``id`` at the volume local-space point ``uvw``.

    Values for allocated voxels are read from the ``voxel_data`` array, and `background` is used as the value of non-existing voxels.
    Interpolation should be :attr:`warp.Volume.CLOSEST` or :attr:`wp.Volume.LINEAR`.
    This function is available for both index grids and classical volumes.

    """
    ...


@over
def volume_sample_grad_index(
    id: uint64, uvw: vec3f, sampling_mode: int32, voxel_data: Array[Any], background: Any, grad: Any
) -> Any:
    """Sample the volume given by ``id`` and its gradient at the volume local-space point ``uvw``.

    Values for allocated voxels are read from the ``voxel_data`` array, and `background` is used as the value of non-existing voxels.
    Interpolation should be :attr:`warp.Volume.CLOSEST` or :attr:`wp.Volume.LINEAR`.
    This function is available for both index grids and classical volumes.

    """
    ...


@over
def volume_lookup_index(id: uint64, i: int32, j: int32, k: int32) -> int32:
    """Returns the index associated to the voxel with coordinates ``i``, ``j``, ``k``.

    If the voxel at this index does not exist, this function returns -1.
    This function is available for both index grids and classical volumes.

    """
    ...


@over
def volume_index_to_world(id: uint64, uvw: vec3f) -> vec3f:
    """Transform a point ``uvw`` defined in volume index space to world space given the volume's intrinsic affine transformation."""
    ...


@over
def volume_world_to_index(id: uint64, xyz: vec3f) -> vec3f:
    """Transform a point ``xyz`` defined in volume world space to the volume's index space given the volume's intrinsic affine transformation."""
    ...


@over
def volume_index_to_world_dir(id: uint64, uvw: vec3f) -> vec3f:
    """Transform a direction ``uvw`` defined in volume index space to world space given the volume's intrinsic affine transformation."""
    ...


@over
def volume_world_to_index_dir(id: uint64, xyz: vec3f) -> vec3f:
    """Transform a direction ``xyz`` defined in volume world space to the volume's index space given the volume's intrinsic affine transformation."""
    ...


@over
def rand_init(seed: int32) -> uint32:
    """Initialize a new random number generator given a user-defined seed. Returns a 32-bit integer representing the RNG state."""
    ...


@over
def rand_init(seed: int32, offset: int32) -> uint32:
    """Initialize a new random number generator given a user-defined seed and an offset.

    This alternative constructor can be useful in parallel programs, where a kernel as a whole should share a seed,
    but each thread should generate uncorrelated values. In this case usage should be ``r = rand_init(seed, tid)``
    """
    ...


@over
def randi(state: uint32) -> int:
    """Return a random integer in the range [-2^31, 2^31)."""
    ...


@over
def randi(state: uint32, low: int32, high: int32) -> int:
    """Return a random integer between [low, high)."""
    ...


@over
def randu(state: uint32) -> uint32:
    """Return a random unsigned integer in the range [0, 2^32)."""
    ...


@over
def randu(state: uint32, low: uint32, high: uint32) -> uint32:
    """Return a random unsigned integer between [low, high)."""
    ...


@over
def randf(state: uint32) -> float:
    """Return a random float between [0.0, 1.0)."""
    ...


@over
def randf(state: uint32, low: float32, high: float32) -> float:
    """Return a random float between [low, high)."""
    ...


@over
def randn(state: uint32) -> float:
    """Sample a normal (Gaussian) distribution of mean 0 and variance 1."""
    ...


@over
def sample_cdf(state: uint32, cdf: Array[float32]) -> int:
    """Inverse-transform sample a cumulative distribution function."""
    ...


@over
def sample_triangle(state: uint32) -> vec2f:
    """Uniformly sample a triangle. Returns sample barycentric coordinates."""
    ...


@over
def sample_unit_ring(state: uint32) -> vec2f:
    """Uniformly sample a ring in the xy plane."""
    ...


@over
def sample_unit_disk(state: uint32) -> vec2f:
    """Uniformly sample a disk in the xy plane."""
    ...


@over
def sample_unit_sphere_surface(state: uint32) -> vec3f:
    """Uniformly sample a unit sphere surface."""
    ...


@over
def sample_unit_sphere(state: uint32) -> vec3f:
    """Uniformly sample a unit sphere."""
    ...


@over
def sample_unit_hemisphere_surface(state: uint32) -> vec3f:
    """Uniformly sample a unit hemisphere surface."""
    ...


@over
def sample_unit_hemisphere(state: uint32) -> vec3f:
    """Uniformly sample a unit hemisphere."""
    ...


@over
def sample_unit_square(state: uint32) -> vec2f:
    """Uniformly sample a unit square."""
    ...


@over
def sample_unit_cube(state: uint32) -> vec3f:
    """Uniformly sample a unit cube."""
    ...


@over
def poisson(state: uint32, lam: float32) -> uint32:
    """Generate a random sample from a Poisson distribution.

    :param state: RNG state
    :param lam: The expected value of the distribution
    """
    ...


@over
def noise(state: uint32, x: float32) -> float:
    """Non-periodic Perlin-style noise in 1D."""
    ...


@over
def noise(state: uint32, xy: vec2f) -> float:
    """Non-periodic Perlin-style noise in 2D."""
    ...


@over
def noise(state: uint32, xyz: vec3f) -> float:
    """Non-periodic Perlin-style noise in 3D."""
    ...


@over
def noise(state: uint32, xyzt: vec4f) -> float:
    """Non-periodic Perlin-style noise in 4D."""
    ...


@over
def pnoise(state: uint32, x: float32, px: int32) -> float:
    """Periodic Perlin-style noise in 1D."""
    ...


@over
def pnoise(state: uint32, xy: vec2f, px: int32, py: int32) -> float:
    """Periodic Perlin-style noise in 2D."""
    ...


@over
def pnoise(state: uint32, xyz: vec3f, px: int32, py: int32, pz: int32) -> float:
    """Periodic Perlin-style noise in 3D."""
    ...


@over
def pnoise(state: uint32, xyzt: vec4f, px: int32, py: int32, pz: int32, pt: int32) -> float:
    """Periodic Perlin-style noise in 4D."""
    ...


@over
def curlnoise(state: uint32, xy: vec2f, octaves: uint32, lacunarity: float32, gain: float32) -> vec2f:
    """Divergence-free vector field based on the gradient of a Perlin noise function."""
    ...


@over
def curlnoise(state: uint32, xyz: vec3f, octaves: uint32, lacunarity: float32, gain: float32) -> vec3f:
    """Divergence-free vector field based on the curl of three Perlin noise functions."""
    ...


@over
def curlnoise(state: uint32, xyzt: vec4f, octaves: uint32, lacunarity: float32, gain: float32) -> vec3f:
    """Divergence-free vector field based on the curl of three Perlin noise functions."""
    ...


@over
def printf(fmt: str, *args: Any):
    """Allows printing formatted strings using C-style format specifiers."""
    ...


@over
def print(value: Any):
    """Print variable to stdout"""
    ...


@over
def breakpoint():
    """Debugger breakpoint"""
    ...


@over
def tid() -> int:
    """Return the current thread index for a 1D kernel launch.

    Note that this is the *global* index of the thread in the range [0, dim)
    where dim is the parameter passed to kernel launch.

    This function may not be called from user-defined Warp functions.
    """
    ...


@over
def tid() -> Tuple[int, int]:
    """Return the current thread indices for a 2D kernel launch.

    Use ``i,j = wp.tid()`` syntax to retrieve the coordinates inside the kernel thread grid.

    This function may not be called from user-defined Warp functions.
    """
    ...


@over
def tid() -> Tuple[int, int, int]:
    """Return the current thread indices for a 3D kernel launch.

    Use ``i,j,k = wp.tid()`` syntax to retrieve the coordinates inside the kernel thread grid.

    This function may not be called from user-defined Warp functions.
    """
    ...


@over
def tid() -> Tuple[int, int, int, int]:
    """Return the current thread indices for a 4D kernel launch.

    Use ``i,j,k,l = wp.tid()`` syntax to retrieve the coordinates inside the kernel thread grid.

    This function may not be called from user-defined Warp functions.
    """
    ...


@over
def select(cond: bool, value_if_false: Any, value_if_true: Any) -> Any:
    """Select between two arguments, if ``cond`` is ``False`` then return ``value_if_false``, otherwise return ``value_if_true``.

    .. deprecated:: 1.7
         Use :func:`where` instead, which has the more intuitive argument order:
         ``where(cond, value_if_true, value_if_false)``.
    """
    ...


@over
def select(cond: int8, value_if_false: Any, value_if_true: Any) -> Any:
    """Select between two arguments, if ``cond`` is ``False`` then return ``value_if_false``, otherwise return ``value_if_true``.

    .. deprecated:: 1.7
         Use :func:`where` instead, which has the more intuitive argument order:
         ``where(cond, value_if_true, value_if_false)``.
    """
    ...


@over
def select(cond: uint8, value_if_false: Any, value_if_true: Any) -> Any:
    """Select between two arguments, if ``cond`` is ``False`` then return ``value_if_false``, otherwise return ``value_if_true``.

    .. deprecated:: 1.7
         Use :func:`where` instead, which has the more intuitive argument order:
         ``where(cond, value_if_true, value_if_false)``.
    """
    ...


@over
def select(cond: int16, value_if_false: Any, value_if_true: Any) -> Any:
    """Select between two arguments, if ``cond`` is ``False`` then return ``value_if_false``, otherwise return ``value_if_true``.

    .. deprecated:: 1.7
         Use :func:`where` instead, which has the more intuitive argument order:
         ``where(cond, value_if_true, value_if_false)``.
    """
    ...


@over
def select(cond: uint16, value_if_false: Any, value_if_true: Any) -> Any:
    """Select between two arguments, if ``cond`` is ``False`` then return ``value_if_false``, otherwise return ``value_if_true``.

    .. deprecated:: 1.7
         Use :func:`where` instead, which has the more intuitive argument order:
         ``where(cond, value_if_true, value_if_false)``.
    """
    ...


@over
def select(cond: int32, value_if_false: Any, value_if_true: Any) -> Any:
    """Select between two arguments, if ``cond`` is ``False`` then return ``value_if_false``, otherwise return ``value_if_true``.

    .. deprecated:: 1.7
         Use :func:`where` instead, which has the more intuitive argument order:
         ``where(cond, value_if_true, value_if_false)``.
    """
    ...


@over
def select(cond: uint32, value_if_false: Any, value_if_true: Any) -> Any:
    """Select between two arguments, if ``cond`` is ``False`` then return ``value_if_false``, otherwise return ``value_if_true``.

    .. deprecated:: 1.7
         Use :func:`where` instead, which has the more intuitive argument order:
         ``where(cond, value_if_true, value_if_false)``.
    """
    ...


@over
def select(cond: int64, value_if_false: Any, value_if_true: Any) -> Any:
    """Select between two arguments, if ``cond`` is ``False`` then return ``value_if_false``, otherwise return ``value_if_true``.

    .. deprecated:: 1.7
         Use :func:`where` instead, which has the more intuitive argument order:
         ``where(cond, value_if_true, value_if_false)``.
    """
    ...


@over
def select(cond: uint64, value_if_false: Any, value_if_true: Any) -> Any:
    """Select between two arguments, if ``cond`` is ``False`` then return ``value_if_false``, otherwise return ``value_if_true``.

    .. deprecated:: 1.7
         Use :func:`where` instead, which has the more intuitive argument order:
         ``where(cond, value_if_true, value_if_false)``.
    """
    ...


@over
def select(arr: Array[Any], value_if_false: Any, value_if_true: Any) -> Any:
    """Select between two arguments, if ``arr`` is null then return ``value_if_false``, otherwise return ``value_if_true``.

    .. deprecated:: 1.7
         Use :func:`where` instead, which has the more intuitive argument order:
         ``where(arr, value_if_true, value_if_false)``.
    """
    ...


@over
def where(cond: bool, value_if_true: Any, value_if_false: Any) -> Any:
    """Select between two arguments, if ``cond`` is ``True`` then return ``value_if_true``, otherwise return ``value_if_false``."""
    ...


@over
def where(cond: int8, value_if_true: Any, value_if_false: Any) -> Any:
    """Select between two arguments, if ``cond`` is ``True`` then return ``value_if_true``, otherwise return ``value_if_false``."""
    ...


@over
def where(cond: uint8, value_if_true: Any, value_if_false: Any) -> Any:
    """Select between two arguments, if ``cond`` is ``True`` then return ``value_if_true``, otherwise return ``value_if_false``."""
    ...


@over
def where(cond: int16, value_if_true: Any, value_if_false: Any) -> Any:
    """Select between two arguments, if ``cond`` is ``True`` then return ``value_if_true``, otherwise return ``value_if_false``."""
    ...


@over
def where(cond: uint16, value_if_true: Any, value_if_false: Any) -> Any:
    """Select between two arguments, if ``cond`` is ``True`` then return ``value_if_true``, otherwise return ``value_if_false``."""
    ...


@over
def where(cond: int32, value_if_true: Any, value_if_false: Any) -> Any:
    """Select between two arguments, if ``cond`` is ``True`` then return ``value_if_true``, otherwise return ``value_if_false``."""
    ...


@over
def where(cond: uint32, value_if_true: Any, value_if_false: Any) -> Any:
    """Select between two arguments, if ``cond`` is ``True`` then return ``value_if_true``, otherwise return ``value_if_false``."""
    ...


@over
def where(cond: int64, value_if_true: Any, value_if_false: Any) -> Any:
    """Select between two arguments, if ``cond`` is ``True`` then return ``value_if_true``, otherwise return ``value_if_false``."""
    ...


@over
def where(cond: uint64, value_if_true: Any, value_if_false: Any) -> Any:
    """Select between two arguments, if ``cond`` is ``True`` then return ``value_if_true``, otherwise return ``value_if_false``."""
    ...


@over
def where(arr: Array[Any], value_if_true: Any, value_if_false: Any) -> Any:
    """Select between two arguments, if ``arr`` is not null then return ``value_if_true``, otherwise return ``value_if_false``."""
    ...


@over
def atomic_add(arr: Array[Any], i: Int, value: Any) -> Any:
    """Atomically add ``value`` onto ``arr[i]`` and return the old value."""
    ...


@over
def atomic_add(arr: Array[Any], i: Int, j: Int, value: Any) -> Any:
    """Atomically add ``value`` onto ``arr[i,j]`` and return the old value."""
    ...


@over
def atomic_add(arr: Array[Any], i: Int, j: Int, k: Int, value: Any) -> Any:
    """Atomically add ``value`` onto ``arr[i,j,k]`` and return the old value."""
    ...


@over
def atomic_add(arr: Array[Any], i: Int, j: Int, k: Int, l: Int, value: Any) -> Any:
    """Atomically add ``value`` onto ``arr[i,j,k,l]`` and return the old value."""
    ...


@over
def atomic_add(arr: FabricArray[Any], i: Int, value: Any) -> Any:
    """Atomically add ``value`` onto ``arr[i]`` and return the old value."""
    ...


@over
def atomic_add(arr: FabricArray[Any], i: Int, j: Int, value: Any) -> Any:
    """Atomically add ``value`` onto ``arr[i,j]`` and return the old value."""
    ...


@over
def atomic_add(arr: FabricArray[Any], i: Int, j: Int, k: Int, value: Any) -> Any:
    """Atomically add ``value`` onto ``arr[i,j,k]`` and return the old value."""
    ...


@over
def atomic_add(arr: FabricArray[Any], i: Int, j: Int, k: Int, l: Int, value: Any) -> Any:
    """Atomically add ``value`` onto ``arr[i,j,k,l]`` and return the old value."""
    ...


@over
def atomic_add(arr: IndexedFabricArray[Any], i: Int, value: Any) -> Any:
    """Atomically add ``value`` onto ``arr[i]`` and return the old value."""
    ...


@over
def atomic_add(arr: IndexedFabricArray[Any], i: Int, j: Int, value: Any) -> Any:
    """Atomically add ``value`` onto ``arr[i,j]`` and return the old value."""
    ...


@over
def atomic_add(arr: IndexedFabricArray[Any], i: Int, j: Int, k: Int, value: Any) -> Any:
    """Atomically add ``value`` onto ``arr[i,j,k]`` and return the old value."""
    ...


@over
def atomic_add(arr: IndexedFabricArray[Any], i: Int, j: Int, k: Int, l: Int, value: Any) -> Any:
    """Atomically add ``value`` onto ``arr[i,j,k,l]`` and return the old value."""
    ...


@over
def atomic_sub(arr: Array[Any], i: Int, value: Any) -> Any:
    """Atomically subtract ``value`` onto ``arr[i]`` and return the old value."""
    ...


@over
def atomic_sub(arr: Array[Any], i: Int, j: Int, value: Any) -> Any:
    """Atomically subtract ``value`` onto ``arr[i,j]`` and return the old value."""
    ...


@over
def atomic_sub(arr: Array[Any], i: Int, j: Int, k: Int, value: Any) -> Any:
    """Atomically subtract ``value`` onto ``arr[i,j,k]`` and return the old value."""
    ...


@over
def atomic_sub(arr: Array[Any], i: Int, j: Int, k: Int, l: Int, value: Any) -> Any:
    """Atomically subtract ``value`` onto ``arr[i,j,k,l]`` and return the old value."""
    ...


@over
def atomic_sub(arr: FabricArray[Any], i: Int, value: Any) -> Any:
    """Atomically subtract ``value`` onto ``arr[i]`` and return the old value."""
    ...


@over
def atomic_sub(arr: FabricArray[Any], i: Int, j: Int, value: Any) -> Any:
    """Atomically subtract ``value`` onto ``arr[i,j]`` and return the old value."""
    ...


@over
def atomic_sub(arr: FabricArray[Any], i: Int, j: Int, k: Int, value: Any) -> Any:
    """Atomically subtract ``value`` onto ``arr[i,j,k]`` and return the old value."""
    ...


@over
def atomic_sub(arr: FabricArray[Any], i: Int, j: Int, k: Int, l: Int, value: Any) -> Any:
    """Atomically subtract ``value`` onto ``arr[i,j,k,l]`` and return the old value."""
    ...


@over
def atomic_sub(arr: IndexedFabricArray[Any], i: Int, value: Any) -> Any:
    """Atomically subtract ``value`` onto ``arr[i]`` and return the old value."""
    ...


@over
def atomic_sub(arr: IndexedFabricArray[Any], i: Int, j: Int, value: Any) -> Any:
    """Atomically subtract ``value`` onto ``arr[i,j]`` and return the old value."""
    ...


@over
def atomic_sub(arr: IndexedFabricArray[Any], i: Int, j: Int, k: Int, value: Any) -> Any:
    """Atomically subtract ``value`` onto ``arr[i,j,k]`` and return the old value."""
    ...


@over
def atomic_sub(arr: IndexedFabricArray[Any], i: Int, j: Int, k: Int, l: Int, value: Any) -> Any:
    """Atomically subtract ``value`` onto ``arr[i,j,k,l]`` and return the old value."""
    ...


@over
def atomic_min(arr: Array[Any], i: Int, value: Any) -> Any:
    """Compute the minimum of ``value`` and ``arr[i]``, atomically update the array, and return the old value.

    The operation is only atomic on a per-component basis for vectors and matrices.
    """
    ...


@over
def atomic_min(arr: Array[Any], i: Int, j: Int, value: Any) -> Any:
    """Compute the minimum of ``value`` and ``arr[i,j]``, atomically update the array, and return the old value.

    The operation is only atomic on a per-component basis for vectors and matrices.
    """
    ...


@over
def atomic_min(arr: Array[Any], i: Int, j: Int, k: Int, value: Any) -> Any:
    """Compute the minimum of ``value`` and ``arr[i,j,k]``, atomically update the array, and return the old value.

    The operation is only atomic on a per-component basis for vectors and matrices.
    """
    ...


@over
def atomic_min(arr: Array[Any], i: Int, j: Int, k: Int, l: Int, value: Any) -> Any:
    """Compute the minimum of ``value`` and ``arr[i,j,k,l]``, atomically update the array, and return the old value.

    The operation is only atomic on a per-component basis for vectors and matrices.
    """
    ...


@over
def atomic_min(arr: FabricArray[Any], i: Int, value: Any) -> Any:
    """Compute the minimum of ``value`` and ``arr[i]``, atomically update the array, and return the old value.

    The operation is only atomic on a per-component basis for vectors and matrices.
    """
    ...


@over
def atomic_min(arr: FabricArray[Any], i: Int, j: Int, value: Any) -> Any:
    """Compute the minimum of ``value`` and ``arr[i,j]``, atomically update the array, and return the old value.

    The operation is only atomic on a per-component basis for vectors and matrices.
    """
    ...


@over
def atomic_min(arr: FabricArray[Any], i: Int, j: Int, k: Int, value: Any) -> Any:
    """Compute the minimum of ``value`` and ``arr[i,j,k]``, atomically update the array, and return the old value.

    The operation is only atomic on a per-component basis for vectors and matrices.
    """
    ...


@over
def atomic_min(arr: FabricArray[Any], i: Int, j: Int, k: Int, l: Int, value: Any) -> Any:
    """Compute the minimum of ``value`` and ``arr[i,j,k,l]``, atomically update the array, and return the old value.

    The operation is only atomic on a per-component basis for vectors and matrices.
    """
    ...


@over
def atomic_min(arr: IndexedFabricArray[Any], i: Int, value: Any) -> Any:
    """Compute the minimum of ``value`` and ``arr[i]``, atomically update the array, and return the old value.

    The operation is only atomic on a per-component basis for vectors and matrices.
    """
    ...


@over
def atomic_min(arr: IndexedFabricArray[Any], i: Int, j: Int, value: Any) -> Any:
    """Compute the minimum of ``value`` and ``arr[i,j]``, atomically update the array, and return the old value.

    The operation is only atomic on a per-component basis for vectors and matrices.
    """
    ...


@over
def atomic_min(arr: IndexedFabricArray[Any], i: Int, j: Int, k: Int, value: Any) -> Any:
    """Compute the minimum of ``value`` and ``arr[i,j,k]``, atomically update the array, and return the old value.

    The operation is only atomic on a per-component basis for vectors and matrices.
    """
    ...


@over
def atomic_min(arr: IndexedFabricArray[Any], i: Int, j: Int, k: Int, l: Int, value: Any) -> Any:
    """Compute the minimum of ``value`` and ``arr[i,j,k,l]``, atomically update the array, and return the old value.

    The operation is only atomic on a per-component basis for vectors and matrices.
    """
    ...


@over
def atomic_max(arr: Array[Any], i: Int, value: Any) -> Any:
    """Compute the maximum of ``value`` and ``arr[i]``, atomically update the array, and return the old value.

    The operation is only atomic on a per-component basis for vectors and matrices.
    """
    ...


@over
def atomic_max(arr: Array[Any], i: Int, j: Int, value: Any) -> Any:
    """Compute the maximum of ``value`` and ``arr[i,j]``, atomically update the array, and return the old value.

    The operation is only atomic on a per-component basis for vectors and matrices.
    """
    ...


@over
def atomic_max(arr: Array[Any], i: Int, j: Int, k: Int, value: Any) -> Any:
    """Compute the maximum of ``value`` and ``arr[i,j,k]``, atomically update the array, and return the old value.

    The operation is only atomic on a per-component basis for vectors and matrices.
    """
    ...


@over
def atomic_max(arr: Array[Any], i: Int, j: Int, k: Int, l: Int, value: Any) -> Any:
    """Compute the maximum of ``value`` and ``arr[i,j,k,l]``, atomically update the array, and return the old value.

    The operation is only atomic on a per-component basis for vectors and matrices.
    """
    ...


@over
def atomic_max(arr: FabricArray[Any], i: Int, value: Any) -> Any:
    """Compute the maximum of ``value`` and ``arr[i]``, atomically update the array, and return the old value.

    The operation is only atomic on a per-component basis for vectors and matrices.
    """
    ...


@over
def atomic_max(arr: FabricArray[Any], i: Int, j: Int, value: Any) -> Any:
    """Compute the maximum of ``value`` and ``arr[i,j]``, atomically update the array, and return the old value.

    The operation is only atomic on a per-component basis for vectors and matrices.
    """
    ...


@over
def atomic_max(arr: FabricArray[Any], i: Int, j: Int, k: Int, value: Any) -> Any:
    """Compute the maximum of ``value`` and ``arr[i,j,k]``, atomically update the array, and return the old value.

    The operation is only atomic on a per-component basis for vectors and matrices.
    """
    ...


@over
def atomic_max(arr: FabricArray[Any], i: Int, j: Int, k: Int, l: Int, value: Any) -> Any:
    """Compute the maximum of ``value`` and ``arr[i,j,k,l]``, atomically update the array, and return the old value.

    The operation is only atomic on a per-component basis for vectors and matrices.
    """
    ...


@over
def atomic_max(arr: IndexedFabricArray[Any], i: Int, value: Any) -> Any:
    """Compute the maximum of ``value`` and ``arr[i]``, atomically update the array, and return the old value.

    The operation is only atomic on a per-component basis for vectors and matrices.
    """
    ...


@over
def atomic_max(arr: IndexedFabricArray[Any], i: Int, j: Int, value: Any) -> Any:
    """Compute the maximum of ``value`` and ``arr[i,j]``, atomically update the array, and return the old value.

    The operation is only atomic on a per-component basis for vectors and matrices.
    """
    ...


@over
def atomic_max(arr: IndexedFabricArray[Any], i: Int, j: Int, k: Int, value: Any) -> Any:
    """Compute the maximum of ``value`` and ``arr[i,j,k]``, atomically update the array, and return the old value.

    The operation is only atomic on a per-component basis for vectors and matrices.
    """
    ...


@over
def atomic_max(arr: IndexedFabricArray[Any], i: Int, j: Int, k: Int, l: Int, value: Any) -> Any:
    """Compute the maximum of ``value`` and ``arr[i,j,k,l]``, atomically update the array, and return the old value.

    The operation is only atomic on a per-component basis for vectors and matrices.
    """
    ...


@over
def lerp(a: Float, b: Float, t: Float) -> Float:
    """Linearly interpolate two values ``a`` and ``b`` using factor ``t``, computed as ``a*(1-t) + b*t``"""
    ...


@over
def lerp(a: Vector[Any, Float], b: Vector[Any, Float], t: Float) -> Vector[Any, Float]:
    """Linearly interpolate two values ``a`` and ``b`` using factor ``t``, computed as ``a*(1-t) + b*t``"""
    ...


@over
def lerp(a: Matrix[Any, Any, Float], b: Matrix[Any, Any, Float], t: Float) -> Matrix[Any, Any, Float]:
    """Linearly interpolate two values ``a`` and ``b`` using factor ``t``, computed as ``a*(1-t) + b*t``"""
    ...


@over
def lerp(a: Quaternion[Float], b: Quaternion[Float], t: Float) -> Quaternion[Float]:
    """Linearly interpolate two values ``a`` and ``b`` using factor ``t``, computed as ``a*(1-t) + b*t``"""
    ...


@over
def lerp(a: Transformation[Float], b: Transformation[Float], t: Float) -> Transformation[Float]:
    """Linearly interpolate two values ``a`` and ``b`` using factor ``t``, computed as ``a*(1-t) + b*t``"""
    ...


@over
def smoothstep(a: Float, b: Float, x: Float) -> Float:
    """Smoothly interpolate between two values ``a`` and ``b`` using a factor ``x``,
    and return a result between 0 and 1 using a cubic Hermite interpolation after clamping.
    """
    ...


@over
def expect_near(a: Float, b: Float, tolerance: Float):
    """Prints an error to stdout if ``a`` and ``b`` are not closer than tolerance in magnitude"""
    ...


@over
def expect_near(a: Vector[Any, Float], b: Vector[Any, Float], tolerance: Float):
    """Prints an error to stdout if any element of ``a`` and ``b`` are not closer than tolerance in magnitude"""
    ...


@over
def expect_near(a: Quaternion[Float], b: Quaternion[Float], tolerance: Float):
    """Prints an error to stdout if any element of ``a`` and ``b`` are not closer than tolerance in magnitude"""
    ...


@over
def expect_near(a: Matrix[Any, Any, Float], b: Matrix[Any, Any, Float], tolerance: Float):
    """Prints an error to stdout if any element of ``a`` and ``b`` are not closer than tolerance in magnitude"""
    ...


@over
def lower_bound(arr: Array[Scalar], value: Scalar) -> int:
    """Search a sorted array ``arr`` for the closest element greater than or equal to ``value``."""
    ...


@over
def lower_bound(arr: Array[Scalar], arr_begin: int32, arr_end: int32, value: Scalar) -> int:
    """Search a sorted array ``arr`` in the range [arr_begin, arr_end) for the closest element greater than or equal to ``value``."""
    ...


@over
def add(a: Scalar, b: Scalar) -> Scalar:
    """ """
    ...


@over
def add(a: Vector[Any, Scalar], b: Vector[Any, Scalar]) -> Vector[Any, Scalar]:
    """ """
    ...


@over
def add(a: Quaternion[Scalar], b: Quaternion[Scalar]) -> Quaternion[Scalar]:
    """ """
    ...


@over
def add(a: Matrix[Any, Any, Scalar], b: Matrix[Any, Any, Scalar]) -> Matrix[Any, Any, Scalar]:
    """ """
    ...


@over
def add(a: Transformation[Scalar], b: Transformation[Scalar]) -> Transformation[Scalar]:
    """ """
    ...


@over
def add(a: Tile, b: Tile) -> Tile:
    """Add each element of two tiles together"""
    ...


@over
def sub(a: Scalar, b: Scalar) -> Scalar:
    """ """
    ...


@over
def sub(a: Vector[Any, Scalar], b: Vector[Any, Scalar]) -> Vector[Any, Scalar]:
    """ """
    ...


@over
def sub(a: Matrix[Any, Any, Scalar], b: Matrix[Any, Any, Scalar]) -> Matrix[Any, Any, Scalar]:
    """ """
    ...


@over
def sub(a: Quaternion[Scalar], b: Quaternion[Scalar]) -> Quaternion[Scalar]:
    """ """
    ...


@over
def sub(a: Transformation[Scalar], b: Transformation[Scalar]) -> Transformation[Scalar]:
    """ """
    ...


@over
def sub(a: Tile, b: Tile) -> Tile:
    """Subtract each element b from a"""
    ...


@over
def bit_and(a: Int, b: Int) -> Int:
    """ """
    ...


@over
def bit_or(a: Int, b: Int) -> Int:
    """ """
    ...


@over
def bit_xor(a: Int, b: Int) -> Int:
    """ """
    ...


@over
def lshift(a: Int, b: Int) -> Int:
    """ """
    ...


@over
def rshift(a: Int, b: Int) -> Int:
    """ """
    ...


@over
def invert(a: Int) -> Int:
    """ """
    ...


@over
def mul(a: Scalar, b: Scalar) -> Scalar:
    """ """
    ...


@over
def mul(a: Vector[Any, Scalar], b: Scalar) -> Vector[Any, Scalar]:
    """ """
    ...


@over
def mul(a: Scalar, b: Vector[Any, Scalar]) -> Vector[Any, Scalar]:
    """ """
    ...


@over
def mul(a: Quaternion[Scalar], b: Scalar) -> Quaternion[Scalar]:
    """ """
    ...


@over
def mul(a: Scalar, b: Quaternion[Scalar]) -> Quaternion[Scalar]:
    """ """
    ...


@over
def mul(a: Quaternion[Scalar], b: Quaternion[Scalar]) -> Quaternion[Scalar]:
    """ """
    ...


@over
def mul(a: Scalar, b: Matrix[Any, Any, Scalar]) -> Matrix[Any, Any, Scalar]:
    """ """
    ...


@over
def mul(a: Matrix[Any, Any, Scalar], b: Scalar) -> Matrix[Any, Any, Scalar]:
    """ """
    ...


@over
def mul(a: Matrix[Any, Any, Scalar], b: Vector[Any, Scalar]) -> Vector[Any, Scalar]:
    """ """
    ...


@over
def mul(a: Vector[Any, Scalar], b: Matrix[Any, Any, Scalar]) -> Vector[Any, Scalar]:
    """ """
    ...


@over
def mul(a: Matrix[Any, Any, Scalar], b: Matrix[Any, Any, Scalar]) -> Matrix[Any, Any, Scalar]:
    """ """
    ...


@over
def mul(a: Transformation[Scalar], b: Transformation[Scalar]) -> Transformation[Scalar]:
    """ """
    ...


@over
def mul(a: Scalar, b: Transformation[Scalar]) -> Transformation[Scalar]:
    """ """
    ...


@over
def mul(a: Transformation[Scalar], b: Scalar) -> Transformation[Scalar]:
    """ """
    ...


@over
def mul(x: Tile, y: Scalar) -> Tile:
    """Multiply each element of a tile by a scalar"""
    ...


@over
def mul(x: Scalar, y: Tile) -> Tile:
    """Multiply each element of a tile by a scalar"""
    ...


@over
def mod(a: Scalar, b: Scalar) -> Scalar:
    """Modulo operation using truncated division."""
    ...


@over
def mod(a: Vector[Any, Scalar], b: Vector[Any, Scalar]) -> Scalar:
    """Modulo operation using truncated division."""
    ...


@over
def div(a: Scalar, b: Scalar) -> Scalar:
    """ """
    ...


@over
def div(a: Vector[Any, Scalar], b: Scalar) -> Vector[Any, Scalar]:
    """ """
    ...


@over
def div(a: Scalar, b: Vector[Any, Scalar]) -> Vector[Any, Scalar]:
    """ """
    ...


@over
def div(a: Matrix[Any, Any, Scalar], b: Scalar) -> Matrix[Any, Any, Scalar]:
    """ """
    ...


@over
def div(a: Scalar, b: Matrix[Any, Any, Scalar]) -> Matrix[Any, Any, Scalar]:
    """ """
    ...


@over
def div(a: Quaternion[Scalar], b: Scalar) -> Quaternion[Scalar]:
    """ """
    ...


@over
def div(a: Scalar, b: Quaternion[Scalar]) -> Quaternion[Scalar]:
    """ """
    ...


@over
def floordiv(a: Scalar, b: Scalar) -> Scalar:
    """ """
    ...


@over
def pos(x: Scalar) -> Scalar:
    """ """
    ...


@over
def pos(x: Vector[Any, Scalar]) -> Vector[Any, Scalar]:
    """ """
    ...


@over
def pos(x: Quaternion[Scalar]) -> Quaternion[Scalar]:
    """ """
    ...


@over
def pos(x: Matrix[Any, Any, Scalar]) -> Matrix[Any, Any, Scalar]:
    """ """
    ...


@over
def neg(x: Scalar) -> Scalar:
    """ """
    ...


@over
def neg(x: Vector[Any, Scalar]) -> Vector[Any, Scalar]:
    """ """
    ...


@over
def neg(x: Quaternion[Scalar]) -> Quaternion[Scalar]:
    """ """
    ...


@over
def neg(x: Matrix[Any, Any, Scalar]) -> Matrix[Any, Any, Scalar]:
    """ """
    ...


@over
def neg(x: Tile) -> Tile:
    """Negate each element of a tile"""
    ...


@over
def unot(a: bool) -> bool:
    """ """
    ...


@over
def unot(a: int8) -> bool:
    """ """
    ...


@over
def unot(a: uint8) -> bool:
    """ """
    ...


@over
def unot(a: int16) -> bool:
    """ """
    ...


@over
def unot(a: uint16) -> bool:
    """ """
    ...


@over
def unot(a: int32) -> bool:
    """ """
    ...


@over
def unot(a: uint32) -> bool:
    """ """
    ...


@over
def unot(a: int64) -> bool:
    """ """
    ...


@over
def unot(a: uint64) -> bool:
    """ """
    ...


@over
def unot(a: Array[Any]) -> bool:
    """ """
    ...


@over
def tile_diag_add(a: Tile, d: Tile) -> Tile:
    """Add a square matrix and a diagonal matrix 'd' represented as a 1D tile"""
    ...


@over
def tile_matmul(a: Tile, b: Tile, out: Tile) -> Tile:
    """Computes the matrix product and accumulates ``out += a*b``.

    Supported datatypes are:
        * fp16, fp32, fp64 (real)
        * vec2h, vec2f, vec2d (complex)

    All input and output tiles must have the same datatype. Tile data will automatically be migrated
    to shared memory if necessary and will use TensorCore operations when available.

    :param a: A tile with ``shape=(M, K)``
    :param b: A tile with ``shape=(K, N)``
    :param out: A tile with ``shape=(M, N)``

    """
    ...


@over
def tile_matmul(a: Tile, b: Tile) -> Tile:
    """Computes the matrix product ``out = a*b``.

    Supported datatypes are:
        * fp16, fp32, fp64 (real)
        * vec2h, vec2f, vec2d (complex)

    Both input tiles must have the same datatype. Tile data will automatically be migrated
    to shared memory if necessary and will use TensorCore operations when available.

    :param a: A tile with ``shape=(M, K)``
    :param b: A tile with ``shape=(K, N)``
    :returns: A tile with ``shape=(M, N)``

    """
    ...


@over
def tile_fft(inout: Tile) -> Tile:
    """Compute the forward FFT along the second dimension of a 2D tile of data.

    This function cooperatively computes the forward FFT on a tile of data inplace, treating each row individually.

    Note that computing the adjoint is not yet supported.

    Supported datatypes are:
        * vec2f, vec2d

    :param inout: The input/output tile
    """
    ...


@over
def tile_ifft(inout: Tile) -> Tile:
    """Compute the inverse FFT along the second dimension of a 2D tile of data.

    This function cooperatively computes the inverse FFT on a tile of data inplace, treating each row individually.

    Note that computing the adjoint is not yet supported.

    Supported datatypes are:
        * vec2f, vec2d

    :param inout: The input/output tile
    """
    ...


@over
def tile_cholesky(A: Tile) -> Tile:
    """Compute the Cholesky factorization L of a matrix A.
    L is lower triangular and satisfies LL^T = A.

    Note that computing the adjoint is not yet supported.

    Supported datatypes are:
        * float32
        * float64

    :param A: A square, symmetric positive-definite, matrix.
    :returns L: A square, lower triangular, matrix, such that LL^T = A
    """
    ...


@over
def tile_cholesky_solve(L: Tile, x: Tile):
    """With L such that LL^T = A, solve for x in Ax = y

    Note that computing the adjoint is not yet supported.

    Supported datatypes are:
        * float32
        * float64

    :param L: A square, lower triangular, matrix, such that LL^T = A
    :param x: An 1D tile of length M
    :returns y: An 1D tile of length M such that LL^T y = x
    """
    ...


@over
def static(expr: Any) -> Any:
    """Evaluate a static Python expression and replaces it with its result.

    See the :ref:`code generation guide <static_expressions>` for more details.

    The inner expression must only reference variables that are available from the current scope where the Warp kernel or function containing the expression is defined,
    which includes constant variables and variables captured in the current closure in which the function or kernel is implemented.
    The return type of the expression must be either a Warp function, a string, or a type that is supported inside Warp kernels and functions
    (excluding Warp arrays since they cannot be created in a Warp kernel at the moment).
    """
    ...


@over
def len(a: Vector[Any, Scalar]) -> int:
    """Return the number of elements in a vector."""
    ...


@over
def len(a: Quaternion[Scalar]) -> int:
    """Return the number of elements in a quaternion."""
    ...


@over
def len(a: Matrix[Any, Any, Scalar]) -> int:
    """Return the number of rows in a matrix."""
    ...


@over
def len(a: Transformation[Float]) -> int:
    """Return the number of elements in a transformation."""
    ...


@over
def len(a: Array[Any]) -> int:
    """Return the size of the first dimension in an array."""
    ...


@over
def len(a: Tile) -> int:
    """Return the number of rows in a tile."""
    ...


@over
def norm_l1(v: Any):
    """Computes the L1 norm of a vector v.

    .. math:: \|v\|_1 = \sum_i |v_i|

    Args:
        v (Vector[Any,Float]): The vector to compute the L1 norm of.

    Returns:
        float: The L1 norm of the vector.
    """
    ...


@over
def norm_l2(v: Any):
    """Computes the L2 norm of a vector v.

    .. math:: \|v\|_2 = \sqrt{\sum_i v_i^2}

    Args:
        v (Vector[Any,Float]): The vector to compute the L2 norm of.

    Returns:
        float: The L2 norm of the vector.
    """
    ...


@over
def norm_huber(v: Any, delta: float):
    """Computes the Huber norm of a vector v with a given delta.

    .. math::
        H(v) = \begin{cases} \frac{1}{2} \|v\|^2 & \text{if } \|v\| \leq \delta \\ \delta(\|v\| - \frac{1}{2}\delta) & \text{otherwise} \end{cases}

    .. image:: /img/norm_huber.svg
        :align: center

    Args:
        v (Vector[Any,Float]): The vector to compute the Huber norm of.
        delta (float): The threshold value, defaults to 1.0.

    Returns:
        float: The Huber norm of the vector.
    """
    ...


@over
def norm_pseudo_huber(v: Any, delta: float):
    """Computes the "pseudo" Huber norm of a vector v with a given delta.

    .. math::
        H^\prime(v) = \delta \sqrt{1 + \frac{\|v\|^2}{\delta^2}}

    .. image:: /img/norm_pseudo_huber.svg
        :align: center

    Args:
        v (Vector[Any,Float]): The vector to compute the Huber norm of.
        delta (float): The threshold value, defaults to 1.0.

    Returns:
        float: The Huber norm of the vector.
    """
    ...


@over
def smooth_normalize(v: Any, delta: float):
    """Normalizes a vector using the pseudo-Huber norm.

    See :func:`norm_pseudo_huber`.

    .. math::
        \frac{v}{H^\prime(v)}

    Args:
        v (Vector[Any,Float]): The vector to normalize.
        delta (float): The threshold value, defaults to 1.0.

    Returns:
        Vector[Any,Float]: The normalized vector.
    """
    ...


@over
def transform_from_matrix(mat: Matrix[4, 4, float32]) -> Transformation[float32]:
    """Construct a transformation from a 4x4 matrix.

    Args:
        mat (Matrix[4, 4, Float]): Matrix to convert.

    Returns:
        Transformation[Float]: The transformation.
    """
    ...


@over
def transform_to_matrix(xform: Transformation[float32]) -> Matrix[4, 4, float32]:
    """Convert a transformation to a 4x4 matrix.

    Args:
        xform (Transformation[Float]): Transformation to convert.

    Returns:
        Matrix[4, 4, Float]: The matrix.
    """
    ...
