## Submitting issues

If you have questions about how to install or use ownCloud, please direct these to the [mailing list][mailinglist] or our [forum][forum]. We are also available on [IRC][irc].

### TL;DR

 * The [issue template can be found here][template] but be aware of the different repositories! See list below.

### Guidelines
* Please search the existing issues first, it's likely that your issue was already reported or even fixed.
  - Go to one of the repositories, click "issues" and type any word in the top search/command bar.
  - You can also filter by appending e. g. "state:open" to the search string.
  - More info on [search syntax within github](https://help.github.com/articles/searching-issues)
* This repository ([core](https://github.com/owncloud/core/issues)) is *only* for issues within the ownCloud core code. This also includes the apps: files, encryption, external storage, sharing, deleted files, versions, LDAP, and WebDAV Auth
* The issues in other components should be reported in their respective repositories: 
  - [Android client](https://github.com/owncloud/android/issues)
  - [iOS client](https://github.com/owncloud/ios-issues/issues)
  - [Desktop client](https://github.com/owncloud/mirall/issues)
  - Apps:
      - [Bookmarks](https://github.com/owncloud/bookmarks/issues)
      - [Calendar](https://github.com/owncloud/calendar/issues)
      - [Contacts](https://github.com/owncloud/contacts/issues)
      - [Documents](https://github.com/owncloud/documents/issues)
      - [Mail](https://github.com/owncloud/mail/issues)
      - [Media/Music](https://github.com/owncloud/media/issues)
      - [News](https://github.com/owncloud/news/issues)
      - [Notes](https://github.com/owncloud/notes/issues)
      - [Shorty](https://github.com/owncloud/shorty/issues)
      - [All other apps](https://github.com/owncloud/apps/issues) (e.g. Pictures, Tasks, ...)
* Report the issue using our [template][template], it includes all the information we need to track down the issue.

Help us to maximize the effort we can spend fixing issues and adding new features, by not reporting duplicate issues.

[template]: https://raw.github.com/owncloud/core/master/issue_template.md
[mailinglist]: https://mail.kde.org/mailman/listinfo/owncloud
[forum]: http://forum.owncloud.org/
[irc]: http://webchat.freenode.net/?channels=owncloud&uio=d4

## Contributing to Source Code

Thanks for wanting to contribute source code to ownCloud. That's great!

Before we're able to merge your code into the ownCloud core, you need to sign our [Contributor Agreement][agreement].

Please read the [Developer Manuals][devmanual] to learn how to create your first application or how to test the ownCloud code with PHPUnit.

[agreement]: http://owncloud.org/about/contributor-agreement/
[devmanual]: http://owncloud.org/dev/

## Translations
Please submit translations via [Transifex][transifex].

[transifex]: https://www.transifex.com/projects/p/owncloud/
