/*
 * Decompiled with CFR 0.152.
 */
package de.java2html;

import de.java2html.Version;
import de.java2html.gui.DirectTextConversionPanel;
import de.java2html.gui.GuiTools;
import de.java2html.gui.IStatisticsView;
import de.java2html.gui.Java2HtmlOptionsPanel;
import de.java2html.javasource.JavaSourceStatistic;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.Box;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Java2HtmlApplet
extends JApplet {
    private static final String EMPTY_STATISTICS_TEXT = "<html>-<br>-<br>-</html>";
    private JLabel lStatistics;
    private Java2HtmlOptionsPanel optionsPanel;

    public String getAppletInfo() {
        return Version.getJava2HtmlAppletTitle();
    }

    public void init() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    Java2HtmlApplet.this.createGui();
                }
            });
        }
        catch (Exception e) {
            System.err.println("createGui didn't successfully complete");
        }
    }

    private void createGui() {
        GuiTools.setNativeLookAndFeel();
        this.optionsPanel = new Java2HtmlOptionsPanel();
        this.lStatistics = new JLabel(EMPTY_STATISTICS_TEXT);
        DirectTextConversionPanel directTextConversionPanel = new DirectTextConversionPanel(this.optionsPanel, new IStatisticsView(){

            public void setStatistics(JavaSourceStatistic statistic) {
                Java2HtmlApplet.this.lStatistics.setText(statistic == null ? Java2HtmlApplet.EMPTY_STATISTICS_TEXT : "<html>" + statistic.getScreenString("<br>") + "</html>");
            }
        });
        JPanel statisticsPanel = GuiTools.createBorderedPanel("Statistics");
        statisticsPanel.add(this.lStatistics);
        JPanel optionsPanelComponent = GuiTools.createBorderedPanel("Options");
        optionsPanelComponent.add(this.optionsPanel.getContent());
        JPanel eastPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c1 = new GridBagConstraints();
        c1.fill = 2;
        c1.gridx = 0;
        c1.anchor = 18;
        eastPanel.add((Component)optionsPanelComponent, c1);
        eastPanel.add((Component)statisticsPanel, c1);
        c1.fill = 1;
        c1.weighty = 1.0;
        eastPanel.add(Box.createVerticalGlue(), c1);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(4, 4));
        container.add((Component)directTextConversionPanel.getContent(), "Center");
        container.add((Component)eastPanel, "East");
        directTextConversionPanel.requestFocus();
    }

    public void start() {
    }

    public void stop() {
    }

    public static void main(String[] args) {
        JFrame appletFrame = new JFrame("Applet viewer frame");
        appletFrame.setDefaultCloseOperation(3);
        appletFrame.setLayout(new GridLayout());
        Java2HtmlApplet myApplet = new Java2HtmlApplet();
        appletFrame.getContentPane().add((Component)myApplet, "Center");
        appletFrame.setSize(700, 420);
        myApplet.init();
        myApplet.start();
        appletFrame.setVisible(true);
        appletFrame.setResizable(false);
    }
}

