/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.converter;

import de.java2html.converter.AbstractJavaSourceConverter;
import de.java2html.converter.ConverterMetaData;
import de.java2html.javasource.JavaSourceType;
import de.java2html.options.JavaSourceConversionOptions;
import de.java2html.options.JavaSourceStyleTable;
import de.java2html.util.HtmlUtilities;
import java.io.BufferedWriter;
import java.io.IOException;

public abstract class AbstractJavaSourceToXmlConverter
extends AbstractJavaSourceConverter {
    protected static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    protected boolean lineNumbers = true;
    protected boolean pre = true;
    protected String lineEnd = "";
    private String space = " ";
    private String headEnd = "";
    private String foot = "";
    private static final String TAG_START = "<span class=\"java";
    private static final String TAG_END = "\">";
    private static final String TAG_CLOSE = "</span>";

    public AbstractJavaSourceToXmlConverter(ConverterMetaData metaData) {
        super(metaData);
        this.setOptions(false, false);
    }

    public void setOptions(boolean lineNumbers, boolean pre) {
        this.lineNumbers = lineNumbers;
        this.pre = pre;
        this.foot = this.getFooter();
        this.headEnd = this.getHeaderEnd();
        if (pre) {
            this.lineEnd = "";
            this.space = " ";
        } else {
            this.lineEnd = "<br />";
            this.space = "&#xA0;";
        }
    }

    public String getDocumentHeader(JavaSourceConversionOptions options, String title) {
        return this.createHeader(options.getStyleTable(), title) + this.headEnd;
    }

    public String getDocumentFooter(JavaSourceConversionOptions options) {
        return this.foot;
    }

    protected abstract String createHeader(JavaSourceStyleTable var1, String var2);

    protected abstract String getHeaderEnd();

    protected abstract String getFooter();

    protected static String createStyleSheet(JavaSourceStyleTable styleTable) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("td.java, td.java-ln {vertical-align:top;}\ntt.java, tt.java-ln, pre.java, pre.java-ln {line-height:1em; margin-bottom:0em;}\ntd.java-ln { text-align:right; }\ntt.java-ln, pre.java-ln { color:#888888 }\n");
        JavaSourceType[] types = JavaSourceType.getAll();
        for (int i = 0; i < types.length; ++i) {
            AbstractJavaSourceToXmlConverter.appendStyle(buffer, types[i], styleTable);
        }
        return buffer.toString();
    }

    private static void appendStyle(StringBuffer buffer, JavaSourceType type, JavaSourceStyleTable styleTable) {
        buffer.append("/* " + type.getName() + "       */ ");
        buffer.append("span.java" + type.getID() + "  { ");
        buffer.append("font-size: 10pt; ");
        buffer.append("color:" + styleTable.get(type).getHtmlColor() + "; ");
        if (styleTable.get(type).isBold()) {
            buffer.append("font-weight:bold; ");
        }
        if (styleTable.get(type).isItalic()) {
            buffer.append("font-style:italic; ");
        }
        buffer.append("}\n");
    }

    public String getBlockSeparator(JavaSourceConversionOptions options) {
        return "";
    }

    protected void toXml(String sourceCode, JavaSourceType[] sourceTypes, int start, int end, BufferedWriter writer) throws IOException {
        writer.write(TAG_START + sourceTypes[start].getID() + TAG_END);
        String t = HtmlUtilities.encode(sourceCode, start, end + 1, "\r\n ");
        for (int i = 0; i < t.length(); ++i) {
            char ch = t.charAt(i);
            if (ch == ' ') {
                if (i < t.length() - 1 && t.charAt(i + 1) == ' ') {
                    writer.write(this.space);
                    continue;
                }
                writer.write(" ");
                continue;
            }
            if (ch == '\n') {
                writer.write(this.lineEnd + "\n");
                continue;
            }
            if (ch == '\r') continue;
            writer.write(ch);
        }
        writer.write(TAG_CLOSE);
    }
}

