/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.converter;

import de.java2html.Version;
import de.java2html.converter.AbstractJavaSourceConverter;
import de.java2html.converter.ConverterMetaData;
import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceIterator;
import de.java2html.javasource.JavaSourceRun;
import de.java2html.javasource.JavaSourceType;
import de.java2html.options.HorizontalAlignment;
import de.java2html.options.IHorizontalAlignmentVisitor;
import de.java2html.options.JavaSourceConversionOptions;
import de.java2html.options.JavaSourceStyleEntry;
import de.java2html.options.JavaSourceStyleTable;
import de.java2html.util.HtmlUtilities;
import de.java2html.util.StringHolder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.text.MessageFormat;

public class JavaSource2HTMLConverter
extends AbstractJavaSourceConverter {
    public static boolean java2HtmlHomepageLinkEnabled = false;
    private static final String HTML_SITE_HEADER = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html><head>\n<title>{0}</title>\n  <style type=\"text/css\">\n    <!--code '{' font-family: Courier New, Courier; font-size: 10pt; margin: 0px; '}'-->\n  </style>\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\" />\n</head><body>\n";
    private static final String HTML_SITE_FOOTER = "\n</body></html>";
    private static final String HTML_BLOCK_SEPARATOR = "<p />\n";
    private static final String HTML_BLOCK_HEADER = "\n\n<!-- ======================================================== -->\n<!-- = Java Sourcecode to HTML automatically converted code = -->\n<!-- =   " + Version.getJava2HtmlConverterTitle() + " " + Version.getBuildDate() + " by Markus Gebhard  markus@jave.de   = -->\n" + "<!-- =     Further information: http://www.java2html.de     = -->\n" + "<div align=\"{0}\" class=\"java\">\n" + "<table border=\"{1}\" cellpadding=\"3\" " + "cellspacing=\"0\" bgcolor=\"{2}\">\n";
    private static final String HTML_HEAD_START = "  <!-- start headline -->\n   <tr>\n    <td colspan=\"2\">\n     <center><font size=\"+2\">\n      <code><b>\n";
    private static final String HTML_HEAD_END = "      </b></code>\n     </font></center>\n    </td>\n   </tr>\n  <!-- end headline -->\n";
    private static final String HTML_COL2_START = "  <!-- start source code -->\n   <td nowrap=\"nowrap\" valign=\"top\" align=\"left\">\n    <code>\n";
    private static final String HTML_COL2_END = "</code>\n    \n   </td>\n  <!-- end source code -->\n";
    private static final String HTML_LINK = "  <!-- start Java2Html link -->\n   <tr>\n    <td align=\"right\">\n<small>\n<a href=\"http://www.java2html.de\" target=\"_blank\">Java2html</a>\n</small>\n    </td>\n   </tr>\n  <!-- end Java2Html link -->\n";
    private static final String HTML_BLOCK_FOOTER = "</table>\n</div>\n<!-- =       END of automatically generated HTML code       = -->\n<!-- ======================================================== -->\n\n";
    private int lineCifferCount;

    public JavaSource2HTMLConverter() {
        super(new ConverterMetaData("html", "XHTML 1.0 Transitional (inlined fonts)", "html"));
    }

    public String getDocumentHeader(JavaSourceConversionOptions options, String title) {
        if (title == null) {
            title = "";
        }
        return MessageFormat.format(HTML_SITE_HEADER, title);
    }

    public String getDocumentFooter(JavaSourceConversionOptions options) {
        return HTML_SITE_FOOTER;
    }

    public String getBlockSeparator(JavaSourceConversionOptions options) {
        return HTML_BLOCK_SEPARATOR;
    }

    public void convert(JavaSource source, JavaSourceConversionOptions options, BufferedWriter writer) throws IOException {
        if (source == null) {
            throw new IllegalStateException("Trying to write out converted code without having source set.");
        }
        String alignValue = this.getHtmlAlignValue(options.getHorizontalAlignment());
        String bgcolorValue = options.getStyleTable().get(JavaSourceType.BACKGROUND).getHtmlColor();
        String borderValue = options.isShowTableBorder() ? "2" : "0";
        writer.write(MessageFormat.format(HTML_BLOCK_HEADER, alignValue, borderValue, bgcolorValue));
        if (options.isShowFileName() && source.getFileName() != null) {
            this.writeFileName(source, writer);
        }
        writer.write("   <tr>");
        writer.newLine();
        this.writeSourceCode(source, options, writer);
        writer.write("   </tr>");
        writer.newLine();
        if (options.isShowJava2HtmlLink() || java2HtmlHomepageLinkEnabled) {
            writer.write(HTML_LINK);
        }
        writer.write(HTML_BLOCK_FOOTER);
    }

    private String getHtmlAlignValue(HorizontalAlignment alignment) {
        final StringHolder stringHolder = new StringHolder();
        alignment.accept(new IHorizontalAlignmentVisitor(){

            public void visitLeftAlignment(HorizontalAlignment horizontalAlignment) {
                stringHolder.setValue("left");
            }

            public void visitRightAlignment(HorizontalAlignment horizontalAlignment) {
                stringHolder.setValue("right");
            }

            public void visitCenterAlignment(HorizontalAlignment horizontalAlignment) {
                stringHolder.setValue("center");
            }
        });
        return stringHolder.getValue();
    }

    private void writeFileName(JavaSource source, BufferedWriter writer) throws IOException {
        writer.write(HTML_HEAD_START);
        writer.write(source.getFileName());
        writer.newLine();
        writer.write(HTML_HEAD_END);
    }

    private void writeSourceCode(JavaSource source, JavaSourceConversionOptions options, BufferedWriter writer) throws IOException {
        writer.write(HTML_COL2_START);
        this.lineCifferCount = String.valueOf(source.getLineCount()).length();
        JavaSourceIterator iterator = source.getIterator();
        int lineNumber = 1;
        while (iterator.hasNext()) {
            JavaSourceRun run = iterator.getNext();
            if (run.isAtStartOfLine()) {
                if (options.isAddLineAnchors()) {
                    this.writeLineAnchorStart(options, writer, lineNumber);
                }
                if (options.isShowLineNumbers()) {
                    this.writeLineNumber(options, writer, lineNumber);
                }
                if (options.isAddLineAnchors()) {
                    this.writeLineAnchorEnd(writer);
                }
                ++lineNumber;
            }
            this.toHTML(options.getStyleTable(), run, writer);
            if (!run.isAtEndOfLine() || !iterator.hasNext()) continue;
            writer.write("<br />");
            writer.newLine();
        }
        writer.write(HTML_COL2_END);
    }

    private void writeLineAnchorEnd(BufferedWriter writer) throws IOException {
        writer.write("</a>");
    }

    private void writeLineAnchorStart(JavaSourceConversionOptions options, BufferedWriter writer, int lineNumber) throws IOException {
        writer.write("<a name=\"");
        writer.write(options.getLineAnchorPrefix() + lineNumber);
        writer.write("\">");
    }

    private void writeLineNumber(JavaSourceConversionOptions options, BufferedWriter writer, int lineNo) throws IOException {
        JavaSourceStyleEntry styleEntry = options.getStyleTable().get(JavaSourceType.LINE_NUMBERS);
        this.writeStyleStart(writer, styleEntry);
        String lineNumber = String.valueOf(lineNo);
        for (int cifferCount = this.lineCifferCount - lineNumber.length(); cifferCount > 0; --cifferCount) {
            writer.write(48);
        }
        writer.write(lineNumber);
        this.writeStyleEnd(writer, styleEntry);
        writer.write("&nbsp;");
    }

    private void toHTML(JavaSourceStyleTable styleTable, JavaSourceRun run, BufferedWriter writer) throws IOException {
        JavaSourceStyleEntry style = styleTable.get(run.getType());
        this.writeStyleStart(writer, style);
        String t = HtmlUtilities.encode(run.getCode(), "\n ");
        for (int i = 0; i < t.length(); ++i) {
            char ch = t.charAt(i);
            if (ch == ' ') {
                writer.write("&nbsp;");
                continue;
            }
            writer.write(ch);
        }
        this.writeStyleEnd(writer, style);
    }

    private void writeStyleStart(BufferedWriter writer, JavaSourceStyleEntry style) throws IOException {
        writer.write("<font color=\"" + style.getHtmlColor() + "\">");
        if (style.isBold()) {
            writer.write("<b>");
        }
        if (style.isItalic()) {
            writer.write("<i>");
        }
    }

    private void writeStyleEnd(BufferedWriter writer, JavaSourceStyleEntry style) throws IOException {
        if (style.isItalic()) {
            writer.write("</i>");
        }
        if (style.isBold()) {
            writer.write("</b>");
        }
        writer.write("</font>");
    }
}

