/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.converter;

import de.java2html.converter.IJavaSourceConverter;
import de.java2html.converter.JavaSource2HTMLConverter;
import de.java2html.converter.JavaSource2RtfConverter;
import de.java2html.converter.JavaSource2TeXConverter;
import de.java2html.converter.JavaSource2Xhtml11Converter;
import de.java2html.converter.JavaSource2XhtmlConverter;
import de.java2html.converter.JavaSource2XmlConverter;
import java.util.ArrayList;
import java.util.List;

public class JavaSourceConverterProvider {
    private static final List converters = new ArrayList(){
        {
            this.add(new JavaSource2HTMLConverter());
            this.add(new JavaSource2Xhtml11Converter());
            this.add(new JavaSource2XhtmlConverter());
            this.add(new JavaSource2TeXConverter());
            this.add(new JavaSource2RtfConverter());
            this.add(new JavaSource2XmlConverter());
        }
    };

    public static String getDefaultConverterName() {
        return ((IJavaSourceConverter)converters.get(0)).getMetaData().getName().toLowerCase();
    }

    public static IJavaSourceConverter getJavaSourceConverterByName(String name) {
        for (int i = 0; i < converters.size(); ++i) {
            IJavaSourceConverter converter = (IJavaSourceConverter)converters.get(i);
            if (!converter.getMetaData().getName().equalsIgnoreCase(name)) continue;
            return converter;
        }
        return null;
    }

    public static String[] getAllConverterNames() {
        String[] names = new String[converters.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = ((IJavaSourceConverter)converters.get(i)).getMetaData().getName();
        }
        return names;
    }

    public static IJavaSourceConverter[] getAllConverters() {
        return converters.toArray(new IJavaSourceConverter[converters.size()]);
    }

    public static String[] getAllConverterPrintNames() {
        String[] printNames = new String[converters.size()];
        for (int i = 0; i < printNames.length; ++i) {
            printNames[i] = ((IJavaSourceConverter)converters.get(i)).getMetaData().getPrintName();
        }
        return printNames;
    }
}

