/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.util.test;

import de.java2html.util.RGB;
import junit.framework.TestCase;

public class RGBTest
extends TestCase {
    public void testCreate() {
        RGB rgb = new RGB(1, 2, 3);
        RGBTest.assertEquals((int)1, (int)rgb.getRed());
        RGBTest.assertEquals((int)2, (int)rgb.getGreen());
        RGBTest.assertEquals((int)3, (int)rgb.getBlue());
    }

    public void testIllegalArgumentsInConstructor() {
        this.assertConstructorArgumentsThrowsIllegalArgumentException(-1, 0, 0);
        this.assertConstructorArgumentsThrowsIllegalArgumentException(0, -1, 0);
        this.assertConstructorArgumentsThrowsIllegalArgumentException(0, 0, -1);
        this.assertConstructorArgumentsThrowsIllegalArgumentException(256, 0, 0);
        this.assertConstructorArgumentsThrowsIllegalArgumentException(0, 256, 0);
        this.assertConstructorArgumentsThrowsIllegalArgumentException(0, 0, 256);
    }

    private void assertConstructorArgumentsThrowsIllegalArgumentException(int red, int green, int blue) {
        try {
            new RGB(red, green, blue);
            RGBTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
    }

    public void testSameEquals() {
        RGB rgb = new RGB(1, 2, 3);
        RGBTest.assertEquals((Object)rgb, (Object)rgb);
    }

    public void testEqualEquals() {
        RGBTest.assertEquals((Object)new RGB(1, 2, 3), (Object)new RGB(1, 2, 3));
    }

    public void testEqualHasEqualHashCode() {
        RGBTest.assertEquals((int)new RGB(1, 2, 3).hashCode(), (int)new RGB(1, 2, 3).hashCode());
    }

    public void testDifferentNotEquals() {
        RGBTest.assertFalse((boolean)new RGB(0, 0, 0).equals(new RGB(1, 0, 0)));
        RGBTest.assertFalse((boolean)new RGB(0, 0, 0).equals(new RGB(0, 1, 0)));
        RGBTest.assertFalse((boolean)new RGB(0, 0, 0).equals(new RGB(0, 0, 1)));
    }
}

