# Play 2.1 documentation

> Play is a high-productivity Java and Scala web application framework that integrates the components and APIs you need for modern web application development. 
>
> Play is based on a lightweight, stateless, web-friendly architecture and features predictable and minimal resource consumption (CPU, memory, threads) for highly-scalable applications thanks to its reactive model, based on Iteratee IO.

- [[What's new in Play 2.1?| Highlights]]
- [[Migration Guide| Migration]]

## Getting started

1. [[Installing Play | Installing]]
1. [[Creating a new application | NewApplication]]
1. [[Anatomy of a Play application | Anatomy]]
1. [[Using the Play console | PlayConsole ]]
1. [[Setting up your preferred IDE | IDE]]
1. [[Sample applications | Samples]]
1. [[Security policy | http://www.playframework.org/code/security]]

## Working with Play

1. [[Play for Scala developers | ScalaHome]]
1. [[Play for Java developers | JavaHome]]

## Detailed topics

1. [[The Build system | Build]]
    1. [[About sbt settings | SBTSettings]]
    1. [[Manage application dependencies | SBTDependencies]]
    1. [[Working with sub-projects | SBTSubProjects]]
1. [[Working with public assets | Assets]]
    1. [[Using CoffeeScript | AssetsCoffeeScript]]
    1. [[Using LESS CSS | AssetsLess]]
    1. [[Using Google Closure Compiler | AssetsGoogleClosureCompiler]]
    1. [[Using RequireJS | RequireJS-support]]
1. [[Working with the in-memory H2 database | Developing-with-the-H2-Database]]
1. [[Managing database evolutions | Evolutions]]
1. [[Configuration file syntax and features | Configuration]]
    1. [[Configuring the JDBC connection pool | SettingsJDBC]]
    1. [[Configuring the internal Akka system | AkkaCore]]
    1. [[Configuring logging | SettingsLogger]]
1. [[Deploying your application | Production]]
    1. [[Creating a standalone package | ProductionDist]]
    1. [[Additional configuration | ProductionConfiguration]]
    1. [[Set-up a front-end HTTP server | HTTPServer]]
    1. [[Deploying to Heroku | ProductionHeroku]]
    1. [[Deploying to CloudBees | Deploying-to-CloudBees]]
    1. [[Deploying to Cloud Foundry | Deploying-CloudFoundry]]

## Additional documentation

1. [[Scala|http://docs.scala-lang.org/]]
1. [[Akka|http://akka.io/docs/]]
1. [[sbt|http://www.scala-sbt.org/learn.html]]
1. [[Configuration|https://github.com/typesafehub/config]]
1. [[Logback|http://logback.qos.ch/documentation.html]]

## Hacking Play

1. [[Building Play from source | BuildingFromSource]]
1. [[CI server at Cloudbees | CIServer]]
1. [[Repositories | Repositories]]
1. [[Issue tracker | Issues]]
1. [[Contributor guidelines | Guidelines]]

## Modules and plugins

1. [[Temporary modules directory | Modules]]

