# Play 2.0 Modules

> This is a temporary location for listing modules, until there will be a location to register them on the Play website.

> Blog posts describing the process of writing a module can be found on [objectify.be](http://www.objectify.be/wordpress/?p=363).

## Airbrake.io notifier

* **Website:** [http://teamon.github.com/play-airbrake/]
* **Documentation:** [https://github.com/teamon/play-airbrake/blob/master/README.md]
* **Short description:** Send exception notifications to airbrake.io

## Amazon STS module (Scala)

* **Website:** [https://github.com/Rhinofly/play-libraries/tree/master/apis/sts]
* **Documentation:** [https://github.com/Rhinofly/play-libraries/tree/master/apis/sts/README.md]
* **Short description:** STS (Security Token Service) API wrapper for Play 2.0

## Amazon SES module (Scala)

* **Website:** [https://github.com/Rhinofly/play-libraries/tree/master/apis/ses]
* **Documentation:** [https://github.com/Rhinofly/play-libraries/tree/master/apis/ses/README.md]
* **Short description:** SES (Simple Email Service) API wrapper for Play 2.0

## Amazon S3 module (Scala)

* **Website:** [https://github.com/Rhinofly/play-libraries/tree/master/apis/s3]
* **Documentation:** [https://github.com/Rhinofly/play-libraries/tree/master/apis/s3/README.md]
* **Short description:** S3 (Simple Storage Service) API wrapper for Play 2.0

## Amf module (Scala)

* **Website:** [https://github.com/Rhinofly/play-libraries/tree/master/amf]
* **Documentation:** [https://github.com/Rhinofly/play-libraries/blob/master/amf/README.md]
* **Short description:** AMF (ActionScript Message Format) support for Play 2.0

## Authentication and Authorization module (Scala)

* **Website:** [https://github.com/t2v/play20-auth]
* **Documentation(en):** [https://github.com/t2v/play20-auth/blob/master/README.md]
* **Documentation(ja):** [https://github.com/t2v/play20-auth/blob/master/README.ja.md]
* **Short description** This module provides an authentication and authorization way
* Now also has 2.1-SNAPSHOT support: [https://github.com/t2v/play20-auth/tree/play21]

## Authenticity Token module

* **Website:** [https://github.com/orefalo/play2-authenticitytoken](https://github.com/orefalo/play2-authenticitytoken)
* **Documentation:** [https://github.com/orefalo/play2-authenticitytoken/blob/master/README.md](https://github.com/orefalo/play2-authenticitytoken/blob/master/README.md)
* **Short description:** Brings back play1 authenticity token - provides a way around CSRF attacks

## Cache Utilities
* **Website:** [http://hakandilek.github.com/play2-cache/](http://hakandilek.github.com/play2-cache/)
* **Documentation:** [https://github.com/hakandilek/play2-cache/blob/master/README.md]
* **Repository:** [http://hakandilek.github.com/play2-cache/releases/]
* **Repository(snapshot):** [http://hakandilek.github.com/play2-cache/snapshots/]
* **Short description:** Utilities for simplifying caching

## Cloudfront module (Scala)

* **Website:** [https://github.com/mchv/play2-cloudfront]
* **Documentation:** [https://github.com/mchv/play2-cloudfront/blob/master/README.md]
* **Short description** This module helps to integrate a play application with Cloudfront CDN. 

## Deadbolt 2 Plugin
* **Website (docs, sample):** [https://github.com/schaloner/deadbolt-2](https://github.com/schaloner/deadbolt-2)
* **Short description:** Deadbolt is an authorisation mechanism for defining access rights to certain controller methods or parts of a view using a simple AND/OR/NOT syntax

## DDSL Plugin - Dynamic Distributed Service Locator
* **Website (docs, sample):** [https://github.com/mbknor/ddsl-play2-module](https://github.com/mbknor/ddsl-play2-module)
* **Short description:** DDSL - Dynamic Distributed Service Locator - Makes it really easy to create your own dynamic "private cloud" in-house or on EC2/Joyent etc using ZooKeeper

## Dust Plugin
* **Website (docs, sample):** [https://github.com/typesafehub/play-plugins/tree/master/dust](https://github.com/typesafehub/play-plugins/tree/master/dust)
* **Short description:** provides support for the dust client side template language

## Elasticsearch

* **Website:** [https://github.com/cleverage/play2-elasticsearch]
* **Documentation:** [https://github.com/cleverage/play2-elasticsearch/blob/master/README.md]
* **Repository:** [http://cleverage.github.com/play2-elasticsearch/releases/]
* **Short description** Indexing/Requesting Object in Embedded ElasticSearch Server or remote(s) Node(s). 

## funcy - Page Driven Functional Tests (Java)

* **Website:** [https://github.com/joergviola/funcy]
* **Documentation:** [https://github.com/joergviola/funcy/blob/master/README.md]
* **Repository:** [http://joergviola.github.com/releases/]
* **Short description** Simplifies writing functional test using Page Driver classes.

## Groovy Templates plugin

* **Website:** [https://github.com/manuelbernhardt/play2-groovy-templates](https://github.com/manuelbernhardt/play2-groovy-templates)
* **Documentation:** [https://github.com/manuelbernhardt/play2-groovy-templates/blob/master/README.md](https://github.com/manuelbernhardt/play2-groovy-templates/blob/master/README.md)
* **Short description:** This module brings the Groovy templates engine of Play 1 to Play 2. 

## Groovy Templates plugin - gt-engine-play2

* **Website:** [https://github.com/mbknor/gt-engine-play2](https://github.com/mbknor/gt-engine-play2)
* **Documentation:** [https://github.com/mbknor/gt-engine-play2/blob/master/README.markdown](https://github.com/mbknor/gt-engine-play2/blob/master/README.markdown)
* **Short description:** This module brings the Groovy Template engine from play 1 to Play 2. It uses gt-engine which is used by the Play 1 module "Faster Groovy Templates" [http://www.playframework.org/modules/fastergt](http://www.playframework.org/modules/fastergt)
* **Samples:** [https://github.com/mbknor/gt-engine-play2/tree/master/samples](https://github.com/mbknor/gt-engine-play2/tree/master/samples)

## Guice Plugin (Java and Scala)
* **Website (docs, sample):** [https://github.com/typesafehub/play-plugins/tree/master/guice](https://github.com/typesafehub/play-plugins/tree/master/guice)
* **Short description:** provides DI via Guice

## HTML5 Tags module (Java and Scala)
* **Website:** [https://github.com/loicdescotte/Play2-HTML5Tags](https://github.com/loicdescotte/Play2-HTML5Tags)
* **Documentation:** [https://github.com/loicdescotte/Play2-HTML5Tags/blob/master/README.md](https://github.com/loicdescotte/Play2-HTML5Tags/blob/master/README.md)
* **Short description:** This tags add client side validation capabilities, based on model contraints (e.g required, email pattern, max|min lentgh...) and specific input fields (date, telephone number, url...) to Play 2.0 templates

## InputValidator (Scala)

* **Website:** [https://github.com/seratch/inputvalidator/tree/master/play-module](https://github.com/seratch/inputvalidator/tree/master/play-module)
* **Short description:** provides a simple validation API for Play20

## Japid module

* **Website:** [https://github.com/branaway/japid42](https://github.com/branaway/japid42)
* **Documentation:** [https://github.com/branaway/japid42](https://github.com/branaway/japid42)
* **Short description:** This module provides Japid java templates for play 2

## JsMessages

* **Wesite:** [https://github.com/julienrf/play-jsmessages](https://github.com/julienrf/play-jsmessages)
* **Short description:** Allows to compute localized messages on client side.

## JSON minification Plugin

* **Website:** [https://github.com/joscha/play-jsonminify](https://github.com/joscha/play-jsonminify)
* **Documentation:** [https://github.com/joscha/play-jsonminify/blob/master/README.md](https://github.com/joscha/play-jsonminify/blob/master/README.md)
* **Short description:** Allows JSON asset pretty-printing and minification

## Manual Dependency Injection Plugin (Java and Scala)
* **Website (docs, sample):** [https://github.com/typesafehub/play-plugins](https://github.com/typesafehub/play-plugins)
* **Short description:** provides DI via manual injection

## Memcached Plugin

* **Website:** [https://github.com/mumoshu/play2-memcached](https://github.com/mumoshu/play2-memcached)
* **Short description:** provides a memcached based cache implementation

## MongoDB Jackson Mapper Plugin (Java)

* **Website (docs, sample):** [https://github.com/vznet/play-mongo-jackson-mapper](https://github.com/vznet/play-mongo-jackson-mapper)
* **Short description:** provides managed MongoDB access and object mapping using Jackson annotations

## MongoDB Jongo Plugin (Java)
* **Website (docs, sample):** [https://github.com/alexanderjarvis/play-jongo](https://github.com/alexanderjarvis/play-jongo)
* **Short description:** provides managed MongoDB access and object mapping using [Jongo](http://jongo.org/)

## MongoDB Morphia Plugin (Java)
* **Website (docs, sample):** [https://github.com/leodagdag/play2-morphia-plugin](https://github.com/leodagdag/play2-morphia-plugin)
* **Short description:** provides managed MongoDB access and object mapping via Morphia

## MongoDB Salat, Casbah Plugin (Scala)
* **Website (docs, sample):** [https://github.com/leon/play-salat](https://github.com/leon/play-salat)
* **Short description:** provides managed MongoDB access and object mapping using Salat and Casbah 

## Mountable routing

* **Website:** [http://teamon.github.com/play-navigator/]
* **Documentation:** [https://github.com/teamon/play-navigator/blob/master/README.md]
* **Description:** [http://codetunes.com/2012/05/09/scala-dsl-tutorial-writing-web-framework-router]

## Mustache (Java,Scala)

* **Website:** [https://github.com/julienba/play2-mustache]
* **Documentation:** [https://github.com/julienba/play2-mustache]
* **Short description:** Mustache template support

## Native Packaging Module

* **Website:** [https://github.com/kryptt/play2-native-packager-plugin](https://github.com/kryptt/play2-native-packager-plugin)
* **Documentation:** [https://github.com/kryptt/play2-native-packager-plugin/blob/master/README.md](https://github.com/kryptt/play2-native-packager-plugin/blob/master/README.md)
* **Short description:** Allow to package Play! 2.x applications as a standard system package (deb/rpm/msi).

## NINA (Scala)
* **Website (docs, sample):** [https://github.com/dontcare4free/nina](https://github.com/dontcare4free/nina)
* **Short description:** provides a typesafe way to query SQL databases with a special emphasis on selective querying

## PDF module (Java)

* **Website:** [https://github.com/joergviola/play20-pdf]
* **Documentation:** [https://github.com/joergviola/play20-pdf/blob/master/README.md]
* **Repository:** [http://joergviola.github.com/releases/]
* **Short description** Generate PDF output from HTML templates

## Play! Authenticate (Java)

* **Website:** [http://joscha.github.com/play-authenticate/]
* **Documentation:** [https://github.com/joscha/play-authenticate/blob/master/README.md]
* **Short description:** A highly customizable authentication module for Play 2.0

## Play Mini (Java and Scala)
* **Website (docs, sample):** [https://github.com/typesafehub/play2-mini](https://github.com/typesafehub/play2-mini)
* **Short description:** uses play as an HTTP library (in a standard SBT project)

## Play Plovr Plugin
* **Website (docs, sample):** [https://github.com/benmccann/play-plovr-plugin](https://github.com/benmccann/play-plovr-plugin)
* **Short description:** Adds Closure Compiler and Closure Library support to Play

## Pusher
* **Website:** https://github.com/tindr/Play2Pusher
* **Short description:** Easily interact with the [Pusher Service](http://www.pusher.com) within 
your Play 2 application.

## Qunit (Java)

* **Website:** [https://github.com/gcusnieux/play20-qunit]
* **Documentation:** [https://github.com/gcusnieux/play20-qunit]
* **Short description:** JavaScript unit test suite

## Redis Plugin  (Java and Scala)
* **Website (docs, sample):** [https://github.com/typesafehub/play-plugins](https://github.com/typesafehub/play-plugins)
* **Short description:** provides a redis based cache implementation, also lets you use Redis specific APIs

## Swaggerkit (Scala)
* **Website (docs, sample, code):** https://github.com/eamelink/swaggerkit
* **Short description:** Helps you expose a [Swagger](http://swagger.wordnik.com/) specification of a JSON REST API built with Play in a clean way.

## Emailer Plugin  (Java and Scala)
* **Website (docs, sample):** [https://github.com/typesafehub/play-plugins](https://github.com/typesafehub/play-plugins)
* **Short description:** provides an emailer based on apache commons-email

## Roy Compiled Asset Plugin (Ray)
* **Website:** [https://github.com/pufuwozu/ray](https://github.com/pufuwozu/ray)
* **Blog post:** [http://brianmckenna.org/blog/ray](http://brianmckenna.org/blog/ray)
* **Short description:** compiles [Roy](http://roy.brianmckenna.org/) files to JavaScript

## Sass Plugin
* **Website:** <https://github.com/jlitola/play-sass>
* **Short description:** Asset handling for [Sass](http://sass-lang.com/) files

## ScalikeJDBC Plugin (Scala)

* **Website:** [https://github.com/seratch/scalikejdbc-play-plugin](https://github.com/seratch/scalikejdbc-play-plugin)
* **Short description:** provides yet another database access API for Play20

## SecureSocial (Java and Scala)

* **Website:** [http://www.securesocial.ws/](http://www.securesocial.ws/)
* **Short description:** An authentication module supporting OAuth, OAuth2, OpenID, Username/Password and custom authentication schemes.
 
## Session cache (Scala)

* **Website:** [https://github.com/Rhinofly/play-libraries/tree/master/session-cache]
* **Documentation:** [https://github.com/Rhinofly/play-libraries/tree/master/session-cache/README.md]
* **Short description:** Session cache for Play 2.0 

## Snapshot Plugin (Java and Scala)
* **Website (docs, sample):** [https://github.com/vznet/play-snapshot](https://github.com/vznet/play-snapshot)
* **Short description:** provides a hash bang snapshot functionality using HtmlUnit, as described by Google [here](https://developers.google.com/webmasters/ajax-crawling/docs/html-snapshot)

## socket.io.play (scala only, pre-alpha)

* **Website:** [https://github.com/rohit-tingendab/socket.io.play]
* **Documentation:** [https://github.com/rohit-tingendab/socket.io.play/blob/master/README.md]

## Spring Module 

* **Website:** [https://github.com/wsargent/play-2.0-spring-module](https://github.com/wsargent/play-2.0-spring-module)
* **Documentation:** [https://github.com/wsargent/play-2.0-spring-module/blob/master/README.md](https://github.com/wsargent/play-2.0-spring-module/blob/master/README.md)
* **Short description:** Updated version of the original Spring module for Play 2.0

## Stateless client authentication (Scala)
* **Website:** [https://github.com/blendlabs/play20-stateless-auth]
* **Documentation:** [https://github.com/blendlabs/play20-stateless-auth/blob/master/README.md]
* **Short description** Provides required and optional authentication without requiring server-side state (signed auth data is stored on the client)

## Statsd Plugin (Java and Scala)
* **Website (docs, sample):** [https://github.com/vznet/play-statsd](https://github.com/vznet/play-statsd)
* **Short description:** provides a statsd client

## Stylus Plugin

* **Website:** [https://github.com/patiencelabs/play-stylus](https://github.com/patiencelabs/play-stylus)
* **Short description:** Support for [Stylus](https://github.com/learnboost/stylus) CSS compilation

## Typesafe util Plugin (Scala)
* **Website (docs, sample):** [https://github.com/typesafehub/play-plugins](https://github.com/typesafehub/play-plugins)
* **Short description:** provides request header based security and syntactic sugar to deal with plugins

## Typesafe SbtGoodies Plugin 
* **Website (docs, sample):** [https://github.com/typesafehub/play-plugins/tree/master/sbtgoodies](https://github.com/typesafehub/play-plugins/tree/master/sbtgoodies)
* **Short description:** provides extra sbt commands

## TypeScript Plugin
* **Website:** <https://github.com/mumoshu/play2-typescript>
* **Short description:** Asset handling for [TypeScript](http://www.typescriptlang.org/) files

## WAR Module

* **Website:** [https://github.com/dlecan/play2-war-plugin](https://github.com/dlecan/play2-war-plugin)
* **Documentation:** [https://github.com/dlecan/play2-war-plugin/blob/develop/README.md](https://github.com/dlecan/play2-war-plugin/blob/develop/README.md)
* **Short description:** Allow to package Play! 2.x applications into standard WAR packages.

## XForward module

* **Website:** [https://github.com/orefalo/play2-xforward](https://github.com/orefalo/play2-xforward)
* **Documentation:** [https://github.com/orefalo/play2-xforward/blob/master/Readme.md](https://github.com/orefalo/play2-xforward/blob/master/Readme.md)
* **Short description:** This module brings back the missing Proxy forwarding settings from Play1.

## XWiki Rendering module (Scala)

* **Website:** http://literalice.github.com/play-xwiki-rendering/
* **Documentation:** https://github.com/literalice/play-xwiki-rendering/
* **Short description:** XWiki Rendering Framework integration for Play 2.0
