# Play 2.0 documentation

Play 2.0 is a high-productivity Java and Scala web application framework that integrates the components and APIs you need for modern web application development. 

Play is based on a lightweight, stateless, web-friendly architecture and features predictable and minimal resource consumption (CPU, memory, threads) for highly-scalable applications, thanks to its reactive model, based on Iteratee IO.

1. About
1. Getting started
1. [[Play 2.0 for Scala developers | ScalaHome]]
    1. [[HTTP programming | ScalaActions]]
    1. [[Asynchronous HTTP programming | ScalaAsync]]
    1. [[The template engine | ScalaTemplates]]
    1. [[HTTP form submission and validation | ScalaForms]]
    1. [[Working with JSON | ScalaJson]]
    1. [[Working with XML | ScalaXmlRequests]]
    1. [[Handling file upload | ScalaFileUpload]]
    1. [[Accessing an SQL database | ScalaDatabase]]
    1. [[Using the cache | ScalaCache]]
    1. [[Calling web services | ScalaWS]]
    1. [[Integrating with Akka | ScalaAkka]]
    1. [[Internationalization | ScalaI18N]]
    1. [[The application Global object | ScalaGlobal]]
    1. [[Testing your application | ScalaTest]]
    1. [[Handling data streams reactively | Iteratees]]
    1. [[Your first application | ScalaTodoList]]
1. [[Play 2.0 for Java developers | JavaHome]]
    1. [[HTTP programming | JavaActions]]
    1. [[Asynchronous HTTP programming | JavaAsync]]
    1. [[The template engine | JavaTemplates]]
    1. [[HTTP form submission and validation | JavaForms]]
    1. [[Working with JSON | JavaJsonRequests]]
    1. [[Working with XML | JavaXmlRequests]]
    1. [[Handling file upload | JavaFileUpload]]
    1. [[Accessing an SQL database | JavaDatabase]]
    1. [[Using the cache | JavaCache]]
    1. [[Calling web services | JavaWS]]
    1. [[Integrating with Akka | JavaAkka]]
    1. [[Internationalization | JavaI18N]]
    1. [[The application Global object | JavaGlobal]]
    1. [[Testing your application | JavaTest]]
    1. [[Your first application | JavaTodoList]]
1. Detailed topics
    1. [[The build system | Build]]
    1. [[Working with public assets | Assets]]
    1. [[Managing database evolutions | Evolutions]]
    1. [[Configuration file syntax and features | Configuration]]
    1. [[Deploying your application | Production]]
1. Hacking Play 2.0
