# The Build System

The Play build system is based on [[sbt|http://www.scala-sbt.org/]], a minimally non-intrusive build tool for Scala and Java projects.

## The `/project` directory

All the build configuration is stored in the `project` directory. This folder contains 3 main files:

- `build.properties`: This is a marker file that describes the sbt version used.
- `Build.scala`: This is the application project build description.
- `plugins.sbt`: SBT plugins used by the project build.

> Note that `build.properties` and `plugins.sbt` have to be manually updated when you are changing the play version.

## Default build for a Play 2.0 application

The default build description generated by the `play new` command looks like this:

```scala
import sbt._
import Keys._
import PlayProject._

object ApplicationBuild extends Build {

  val appName         = "Your application"
  val appVersion      = "1.0"

  val appDependencies = Seq(
    // Add your project dependencies here,
  )

  val main = PlayProject(
    appName, appVersion, appDependencies, mainLang = SCALA
  ).settings(
    // Add your own project settings here      
  )

}
```

It is written this way to make it easy to define standard options like application name, version and dependencies. 

> Note that every sbt feature is available in a Play 2.0 project. 

## Play plugin for sbt

The Play console and all development features like live reloading are implemented via a sbt plugin. It is registred in the `plugins.sbt` file:

```scala
addSbtPlugin("play" % "sbt-plugin" % "2.0")
```

You might need to add the Typesafe repository in your list of resolvers, see : http://github.com/playframework/Play20/wiki/Repositories

## Adding dependencies and resolvers

Adding dependencies is simple:

```scala
val appDependencies = Seq(
  "group" % "name" % "version number",
)
```

So is adding resolvers:

```scala
val main = PlayProject(
  appName, appVersion, appDependencies, mainLang = SCALA
).settings(
  // Add custom repository: 
  resolvers += "Repository name" at "http://url.to/repository" 
)
```



> **Next:** [[About SBT Settings | SBTSettings]]