# Additional configuration

When running an application in production mode you can override any configuration. This section covers the more common use cases.

All these additional configurations are specified using Java System properties and can be used directly if you are using one of the `start` script generated by Play.

## Specifying the HTTP server address and port

You can provide both HTTP port and address. The default is to listen on port `9000` at the `0.0.0.0` address (all addresses).

```
$ start -Dhttp.port=1234 -Dhttp.address=127.0.0.1
```

> Note that these configuration are only provided for the default embeded Netty server.

## Specifying additional JVM arguments

You can specify any JVM arguments to the `start` script. Otherwise the default JVM settings will be used:

```
$ start -Xms128M -Xmx512m -server
```

## Specifying alternative configuration file

The default is to load the `application.conf` file from the classpath. You can specify an alternative configuration file if needed:

### Using `-Dconfig.resource`

It will search for an alternative configuration file in the application classpath (you usually provide these alternative configuration files into your application `conf/` directory before packaging). Play will look into `conf/` so you don't have to add `conf/`.

```
$ start -Dconfig.resource=prod.conf
```

### Using `-Dconfig.file`

You can also specify another local configuration file not packaged into the application artifacts:

```
$ start -Dconfig.file=/opt/conf/prod.conf
```

### Using `-Dconfig.url`

You can also specify a configuration file to be loaded from any URL:

```
$ start -Dconfig.url=http://conf.mycompany.com/conf/prod.conf
```

> Note that you can always reference the original configuration file in a new `prod.conf` file using the `include` directive, such as:
> 
> ```
> include "application.conf"
> 
> key.to.override=blah
> ```

## Overriding specific configuration keys

Sometimes you don't want to specify another complete configuration file, but just override a bunch of specific keys. You can do that by specifying then as Java System properties:

```
$ start -Dapplication.secret=verysecretkey -Ddb.default.password=toto
```

## Using environment variables

You can also reference environment variables from your `application.conf` file:

```
my.key = defaultvalue
my.key = ${?MY_KEY_ENV}
```

Here, the override field `my.key = ${?MY_KEY_ENV}` simply vanishes if there's no value for `MY_KEY_ENV`, but if you set an environment variable `MY_KEY_ENV` for example, it would be used.

## Changing the logback configuration file

### Bundling a custom logback configuration file with your application

Create an alternative logback config file called `application-logger.xml` and copy that to `<app>/conf`

You can also specify another logback configuration file via a System property.

### Using `-Dlogger.resource`

Specify another loback configuration file to be loaded from the classpath:

```
$ start -Dlogger.resource=conf/prod-logger.xml
```

### Using `-Dlogger.file`

Specify another logback configuration file to be loaded from the file system:

```
$ start -Dlogger.file=/opt/prod/prod-logger.xml
```

### Using `-Dlogger.url`

Specify another loback configuration file to be loaded from an URL:

```
$ start -Dlogger.url=http://conf.mycompany.com/logger.xml
```

## Changing the path of RUNNING_PID

It is possible to change the file path to the created RUNNING_PID file which contains the process id of the started application. Normally this file is placed in the root directory of your play project.

```
$ start -Dpidfile.path=instance1
```
This changes the directory relative to the root folder. You could also use absolute paths. With this option it is possible to start multiple play instances without colliding RUNNING_PID files (actually play won't start another instance). Don't forget to create the directory.
